/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.ConnectionDescription;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.exceptions.CannotLoadClassException;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;

public class ConnectionAssembler
extends AssemblerBase
implements Assembler {
    public final String defaultURL;
    public final String defaultUser;
    public final String defaultPassword;
    public final String defaultType;
    protected static final Resource emptyRoot = ModelFactory.createDefaultModel().createResource();

    public ConnectionAssembler(Resource init) {
        this.defaultUser = this.get(init, "dbUser", null);
        this.defaultPassword = this.get(init, "dbPassword", null);
        this.defaultURL = this.get(init, "dbURL", null);
        this.defaultType = this.get(init, "dbType", null);
    }

    public ConnectionAssembler() {
        this(emptyRoot);
    }

    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, JA.Connection);
        String dbUser = this.getUser(root);
        String dbPassword = this.getPassword(root);
        String dbURL = this.getURL(root);
        String dbType = this.getType(root);
        this.loadClasses(root);
        return this.createConnection(root.getURI(), dbURL, dbType, dbUser, dbPassword);
    }

    private void loadClasses(Resource root) {
        StmtIterator it = root.listProperties(JA.dbClassProperty);
        while (it.hasNext()) {
            String propertyName = ConnectionAssembler.getString(it.nextStatement());
            String className = JenaRuntime.getSystemProperty(propertyName);
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new CannotLoadClassException(root, className, e);
            }
        }
        it = root.listProperties(JA.dbClass);
        while (it.hasNext()) {
            String className = ConnectionAssembler.getString(it.nextStatement());
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new CannotLoadClassException(root, className, e);
            }
        }
    }

    protected ConnectionDescription createConnection(String subject, String dbURL, String dbType, String dbUser, String dbPassword) {
        return ConnectionDescription.create(subject, dbURL, dbUser, dbPassword, dbType);
    }

    public String getUser(Resource root) {
        return this.get(root, "dbUser", this.defaultUser);
    }

    public String getPassword(Resource root) {
        return this.get(root, "dbPassword", this.defaultPassword);
    }

    public String getURL(Resource root) {
        return this.get(root, "dbURL", this.defaultURL);
    }

    public String getType(Resource root) {
        return this.get(root, "dbType", this.defaultType);
    }

    protected String get(Resource root, String label, String ifAbsent) {
        Property property = JA.property(label);
        RDFNode L = ConnectionAssembler.getUnique(root, property);
        return L == null ? this.getIndirect(root, label, ifAbsent) : (L.isLiteral() ? ((Literal)L).getLexicalForm() : ((Resource)L).getURI());
    }

    private String getIndirect(Resource root, String label, String ifAbsent) {
        Property property = JA.property(label + "Property");
        Literal name = ConnectionAssembler.getUniqueLiteral(root, property);
        return name == null ? ifAbsent : JenaRuntime.getSystemProperty(name.getLexicalForm());
    }
}

