/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.n3.RelURI;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileUtils;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.LogFactory;

public abstract class JenaReaderBase
implements RDFReader {
    RDFErrorHandler errorHandler = null;

    public final void read(Model model, Reader r, String base) {
        this.checkReader(r);
        this.readImpl(model, r, base);
    }

    public final void read(Model model, String url) {
        try {
            URLConnection conn = new URL(url).openConnection();
            String encoding = conn.getContentEncoding();
            if (encoding == null) {
                this.read(model, new InputStreamReader(conn.getInputStream(), "utf-8"), url);
            } else {
                LogFactory.getLog(this.getClass()).warn((Object)"URL content is not UTF-8");
                this.read(model, new InputStreamReader(conn.getInputStream(), encoding), url);
            }
        }
        catch (JenaException e) {
            if (this.errorHandler == null) {
                throw e;
            }
            this.errorHandler.error(e);
        }
        catch (Exception ex) {
            if (this.errorHandler == null) {
                throw new JenaException(ex);
            }
            this.errorHandler.error(ex);
        }
    }

    public final void read(Model model, InputStream in, String base) {
        this.readImpl(model, FileUtils.asBufferedUTF8(in), base);
    }

    public final RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }

    public final Object setProperty(String propName, Object propValue) {
        return null;
    }

    protected void checkReader(Reader r) {
        FileReader f;
        if (r instanceof FileReader && (f = (FileReader)r).getEncoding().equalsIgnoreCase("utf-8")) {
            LogFactory.getLog(this.getClass()).warn((Object)"FileReader is not UTF-8");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readImpl(Model model, Reader reader, String base) {
        if (base != null) {
            base = RelURI.resolve(base);
        }
        try {
            model.notifyEvent(GraphEvents.startRead);
            this.readWorker(model, reader, base);
        }
        catch (JenaException e) {
            if (this.errorHandler == null) {
                throw e;
            }
            this.errorHandler.error(e);
        }
        catch (Exception ex) {
            if (this.errorHandler == null) {
                throw new JenaException(ex);
            }
            this.errorHandler.error(ex);
        }
        finally {
            model.notifyEvent(GraphEvents.finishRead);
        }
    }

    protected abstract void readWorker(Model var1, Reader var2, String var3) throws Exception;
}

