/*
 * Decompiled with CFR 0.152.
 */
package org.sercho.masp.space;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.sercho.masp.space.EqualityChecker;
import org.sercho.masp.space.ObjectMatcher;
import org.sercho.masp.util.GetterSetterFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveObjectMatcher
implements ObjectMatcher {
    private static final long serialVersionUID = 1183295966086510164L;
    private static final EqualityChecker<?> SIMPLE_CHECKER = new EqualityChecker<Object>(){
        private static final long serialVersionUID = -4911347274269483883L;

        @Override
        public boolean equals(Object a, Object b) {
            return a.equals(b);
        }
    };
    private static final EqualityChecker<Comparable<?>> COMPARABLE_CHECKER = new EqualityChecker<Comparable<?>>(){
        private static final long serialVersionUID = -1100209996139204383L;

        @Override
        public boolean equals(Comparable a, Comparable b) {
            return a.compareTo(b) == 0;
        }
    };
    private static final EqualityChecker<AtomicInteger> ATOMIC_INTEGER_CHECKER = new EqualityChecker<AtomicInteger>(){
        private static final long serialVersionUID = -9030190654301276557L;

        @Override
        public boolean equals(AtomicInteger a, AtomicInteger b) {
            return a.intValue() == b.intValue();
        }
    };
    private static final EqualityChecker<AtomicLong> ATOMIC_LONG_CHECKER = new EqualityChecker<AtomicLong>(){
        private static final long serialVersionUID = -3290726947458669682L;

        @Override
        public boolean equals(AtomicLong a, AtomicLong b) {
            return a.longValue() == b.longValue();
        }
    };
    private final Map<Class<?>, EqualityChecker<?>> checkers = new HashMap();

    public ReflectiveObjectMatcher() {
        this.checkers.put(Integer.class, COMPARABLE_CHECKER);
        this.checkers.put(String.class, COMPARABLE_CHECKER);
        this.checkers.put(Long.class, COMPARABLE_CHECKER);
        this.checkers.put(Number.class, COMPARABLE_CHECKER);
        this.checkers.put(Boolean.class, COMPARABLE_CHECKER);
        this.checkers.put(Float.class, COMPARABLE_CHECKER);
        this.checkers.put(Double.class, COMPARABLE_CHECKER);
        this.checkers.put(Byte.class, COMPARABLE_CHECKER);
        this.checkers.put(BigDecimal.class, COMPARABLE_CHECKER);
        this.checkers.put(BigInteger.class, COMPARABLE_CHECKER);
        this.checkers.put(AtomicInteger.class, ATOMIC_INTEGER_CHECKER);
        this.checkers.put(AtomicLong.class, ATOMIC_LONG_CHECKER);
    }

    public final <T> boolean isMatching(T template, T object) {
        return this.isMatchingWithChains(template, new LinkedList<Object>(), object, new LinkedList<Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> boolean isMatchingWithChains(T template, List<Object> templateChain, T object, List<Object> objectChain) {
        if (template == null) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (template == object) {
            return true;
        }
        int indexInTemplateChain = templateChain.indexOf(template);
        if (indexInTemplateChain > -1) {
            return objectChain.get(indexInTemplateChain) == object;
        }
        templateChain.add(template);
        objectChain.add(object);
        try {
            boolean bl = this.isMatching(template, templateChain, object, objectChain);
            return bl;
        }
        finally {
            templateChain.remove(templateChain.size() - 1);
            objectChain.remove(objectChain.size() - 1);
        }
    }

    private <T> boolean isMatching(T template, List<Object> templateChain, T object, List<Object> objectChain) {
        Class<?> c = template.getClass();
        if (!c.isInstance(object)) {
            return Iterable.class.isAssignableFrom(c) && object instanceof Iterable && this.isMatchingIterable((Iterable)Iterable.class.cast(template), templateChain, (Iterable)Iterable.class.cast(object), objectChain);
        }
        EqualityChecker<T> checker = this.getChecker(c);
        if (checker != null) {
            return checker.equals(template, object);
        }
        if (!this.isMatchingReflective(template, templateChain, object, objectChain)) {
            return false;
        }
        if (Iterable.class.isAssignableFrom(c) && object instanceof Iterable) {
            return this.isMatchingIterable((Iterable)Iterable.class.cast(template), templateChain, (Iterable)Iterable.class.cast(object), objectChain);
        }
        return true;
    }

    private <T> EqualityChecker<T> getChecker(Class<?> c) {
        EqualityChecker<?> checker = this.checkers.get(c);
        if (checker == null && Enum.class.isAssignableFrom(c)) {
            this.addChecker(c, SIMPLE_CHECKER);
            return SIMPLE_CHECKER;
        }
        return checker;
    }

    private <T> boolean isMatchingReflective(T template, List<Object> templateChain, T object, List<Object> objectChain) {
        return this.isMatchingFields(template, templateChain, object, objectChain) && this.isMatchingGetters(template, templateChain, object, objectChain);
    }

    private <T> boolean isMatchingFields(T template, List<Object> templateChain, T object, List<Object> objectChain) {
        Map nonNullFields = GetterSetterFinder.getNonNullFields(template);
        for (Map.Entry fieldEntry : nonNullFields.entrySet()) {
            try {
                if (this.isMatchingWithChains(fieldEntry.getValue(), templateChain, ((Field)fieldEntry.getKey()).get(object), objectChain)) continue;
                return false;
            }
            catch (IllegalArgumentException e) {
                System.out.println("ReflectiveObjectMatcher.isMatching(): Cannot access field " + fieldEntry.getKey() + " of object " + object);
                return false;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private <T> boolean isMatchingGetters(T template, List<Object> templateChain, T object, List<Object> objectChain) {
        Map nonNullGetters = GetterSetterFinder.getNonNullGettersOfHiddenFields(template);
        for (Map.Entry getterEntry : nonNullGetters.entrySet()) {
            try {
                if (this.isMatchingWithChains(getterEntry.getValue(), templateChain, ((Method)getterEntry.getKey()).invoke(object, (Object[])null), objectChain)) continue;
                return false;
            }
            catch (IllegalArgumentException e) {
                System.out.println("ReflectiveObjectMatcher.isMatching(): Cannot access getter " + getterEntry.getKey() + " of object " + object);
                return false;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return false;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private boolean isMatchingIterable(Iterable<?> template, List<Object> templateChain, Iterable<?> object, List<Object> objectChain) {
        block0: for (Object t : template) {
            for (Object o : object) {
                if (!this.isMatchingWithChains(t, templateChain, o, objectChain)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public final void addChecker(Class<?> c, EqualityChecker<?> checker) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (checker == null) {
            throw new IllegalArgumentException("checker is null");
        }
        this.checkers.put(c, checker);
    }
}

