/*
 * Decompiled with CFR 0.152.
 */
package org.sercho.masp.space;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sercho.masp.space.ObjectUpdater;
import org.sercho.masp.util.GetterSetterFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectiveObjectUpdater
implements ObjectUpdater {
    private static final long serialVersionUID = -5868719671377098301L;
    private static final Map<Class<?>, Map<Method, Method>> CLASS_SETTERS = new HashMap();

    @Override
    public <E> void update(E prototype, E object) {
        Map fields = GetterSetterFinder.getNonNullFields(prototype);
        Map<Method, Object> setters = ReflectiveObjectUpdater.getNonNullSettersOfHiddenFields(prototype);
        for (Map.Entry entry : fields.entrySet()) {
            Field field = (Field)entry.getKey();
            if (Modifier.isFinal(field.getModifiers())) continue;
            try {
                field.set(object, entry.getValue());
            }
            catch (IllegalArgumentException e1) {
                System.err.println("Could not set field: " + field.getName() + ", IllegalArgumentException for " + object.getClass().getName());
            }
            catch (IllegalAccessException e1) {
                System.err.println("Could not set field: " + field.getName() + ", IllegalAccessException for " + object.getClass().getName());
            }
        }
        for (Map.Entry<Object, Object> entry : setters.entrySet()) {
            try {
                ((Method)entry.getKey()).invoke(object, entry.getValue());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<Method, Object> getNonNullSettersOfHiddenFields(Object prototype) {
        HashMap<Method, Object> nonNullSetters = new HashMap<Method, Object>();
        Class<?> c = prototype.getClass();
        Map<Method, Method> setterMap = ReflectiveObjectUpdater.getSettersOfHiddenFields(c);
        Iterator<Map.Entry<Method, Method>> i = setterMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Method, Method> entry = i.next();
            Method getter = entry.getValue();
            try {
                Object value = getter.invoke(prototype, (Object[])null);
                if (value == null) continue;
                nonNullSetters.put(entry.getKey(), value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                i.remove();
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return nonNullSetters;
    }

    private static Map<Method, Method> getSettersOfHiddenFields(Class<?> c) {
        Map<Method, Method> setters = CLASS_SETTERS.get(c);
        if (setters == null) {
            HashMap getterMap = new HashMap(GetterSetterFinder.getGetters(c));
            HashMap setterMap = new HashMap(GetterSetterFinder.getSetters(c));
            List fields = GetterSetterFinder.getFields(c);
            for (Field field : fields) {
                String fieldName = field.getName();
                if (getterMap.remove(fieldName) != null) {
                    setterMap.remove(fieldName);
                    continue;
                }
                fieldName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                getterMap.remove(fieldName);
                setterMap.remove(fieldName);
            }
            setters = new HashMap<Method, Method>();
            for (Map.Entry setterEntry : setterMap.entrySet()) {
                Method getter = (Method)getterMap.get(setterEntry.getKey());
                if (getter == null) continue;
                setters.put((Method)setterEntry.getValue(), getter);
            }
            CLASS_SETTERS.put(c, setters);
        }
        return setters;
    }

    @Override
    public <E> void update(E prototype, Set<E> objects) {
        Map fields = GetterSetterFinder.getNonNullFields(prototype);
        Map<Method, Object> setters = ReflectiveObjectUpdater.getNonNullSettersOfHiddenFields(prototype);
        for (E object : objects) {
            for (Map.Entry entry : fields.entrySet()) {
                Field field = (Field)entry.getKey();
                if (Modifier.isFinal(field.getModifiers())) continue;
                try {
                    field.set(object, entry.getValue());
                }
                catch (IllegalArgumentException e1) {
                    System.err.println("Could not set field: " + field.getName() + ", IllegalArgumentException for " + object.getClass().getName());
                }
                catch (IllegalAccessException e1) {
                    System.err.println("Could not set field: " + field.getName() + ", IllegalAccessException for " + object.getClass().getName());
                }
            }
            for (Map.Entry<Object, Object> entry : setters.entrySet()) {
                try {
                    ((Method)entry.getKey()).invoke(object, entry.getValue());
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

