/*
 * Decompiled with CFR 0.152.
 */
package org.sercho.masp.space;

import java.util.Iterator;
import java.util.Set;
import org.sercho.masp.space.ObjectMatcher;
import org.sercho.masp.space.ObjectUpdater;
import org.sercho.masp.space.event.EventedTupleSpace;
import org.sercho.masp.space.event.SpaceObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecureSpaceWrapper<T>
implements EventedTupleSpace<T> {
    private static final long serialVersionUID = -4673565862225194868L;
    private final EventedTupleSpace<T> space;
    private final boolean readAccess;
    private final boolean writeAccess;
    private final boolean removeAccess;
    private final boolean attachAccess;

    public SecureSpaceWrapper(EventedTupleSpace<T> ts, boolean read, boolean write, boolean remove) {
        this(ts, read, write, remove, true);
    }

    public SecureSpaceWrapper(EventedTupleSpace<T> ts, boolean read, boolean write, boolean remove, boolean attach) {
        if (ts == null) {
            throw new IllegalArgumentException("space is null");
        }
        this.space = ts;
        this.readAccess = read;
        this.writeAccess = write;
        this.removeAccess = remove;
        this.attachAccess = attach;
    }

    @Override
    public String getID() {
        return this.space.getID();
    }

    @Override
    public <E extends T> E read(E template) {
        if (this.readAccess) {
            return this.space.read(template);
        }
        throw new SecurityException("No read access");
    }

    @Override
    public <E extends T> E read(E template, long timeout) {
        if (this.readAccess) {
            return this.space.read(template, timeout);
        }
        throw new SecurityException("No read access");
    }

    @Override
    public <E extends T> Set<E> readAll(E template) {
        if (this.readAccess) {
            return this.space.readAll(template);
        }
        throw new SecurityException("No read access");
    }

    @Override
    public Set<T> readAll() {
        if (this.readAccess) {
            return this.space.readAll();
        }
        throw new SecurityException("No read access");
    }

    @Override
    public <E extends T> E remove(E template) {
        if (this.removeAccess) {
            return this.space.remove(template);
        }
        throw new SecurityException("No remove access");
    }

    @Override
    public <E extends T> E remove(E template, long timeout) {
        if (this.removeAccess) {
            return this.space.remove(template, timeout);
        }
        throw new SecurityException("No remove access");
    }

    @Override
    public <E extends T> Set<E> removeAll(E template) {
        if (this.removeAccess) {
            return this.space.removeAll(template);
        }
        throw new SecurityException("No remove access");
    }

    @Override
    public void write(T o) {
        if (this.writeAccess) {
            this.space.write(o);
            return;
        }
        throw new SecurityException("No write access");
    }

    @Override
    public <E extends T> boolean update(E template, E o) {
        if (this.writeAccess) {
            return this.space.update(template, o);
        }
        throw new SecurityException("No write access");
    }

    @Override
    public void attach(SpaceObserver<? super T> observer) {
        if (this.attachAccess) {
            this.space.attach(observer);
            return;
        }
        throw new SecurityException("No attach access");
    }

    @Override
    public void attach(SpaceObserver<? super T> observer, T template) {
        if (this.attachAccess) {
            this.space.attach(observer, (T)template);
            return;
        }
        throw new SecurityException("No attach access");
    }

    @Override
    public void detach(SpaceObserver<? super T> observer) {
        this.space.detach(observer);
    }

    @Override
    public ObjectMatcher getMatcher() {
        return this.space.getMatcher();
    }

    @Override
    public ObjectUpdater getUpdater() {
        return this.space.getUpdater();
    }

    @Override
    public Iterator<T> iterator() {
        return this.space.iterator();
    }

    @Override
    public <E extends T> Set<E> readAllOfType(Class<E> type) {
        if (this.readAccess) {
            return this.space.readAllOfType(type);
        }
        throw new SecurityException("No read access");
    }
}

