/*
 * Decompiled with CFR 0.152.
 */
package org.sercho.masp.space;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sercho.masp.space.ObjectMatcher;
import org.sercho.masp.space.ObjectUpdater;
import org.sercho.masp.space.ReflectiveObjectMatcher;
import org.sercho.masp.space.ReflectiveObjectUpdater;
import org.sercho.masp.space.TupleSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleObjectSpace<T>
implements TupleSpace<T> {
    private static final long serialVersionUID = -250768605830422851L;
    final Map<Class<?>, Set<T>> objects = new HashMap();
    private final ReadWriteLock objectsLock = new ReentrantReadWriteLock(true);
    private final Lock readObjects = this.objectsLock.readLock();
    private final Lock writeObjects = this.objectsLock.writeLock();
    private final Map<Class<?>, Set<Class<?>>> classes = new HashMap();
    private final ReadWriteLock classesLock = new ReentrantReadWriteLock(true);
    private final Lock readClasses = this.classesLock.readLock();
    private final Lock writeClasses = this.classesLock.writeLock();
    private ObjectMatcher matcher;
    private ObjectUpdater updater = new ReflectiveObjectUpdater();
    private final String id;
    private final String mutex = "";

    public SimpleObjectSpace(String spaceID) {
        this(new ReflectiveObjectMatcher(), spaceID);
    }

    public SimpleObjectSpace(ObjectMatcher objectMatcher, String spaceID) {
        if (spaceID == null) {
            throw new IllegalArgumentException("spaceID is null");
        }
        this.matcher = objectMatcher == null ? new ReflectiveObjectMatcher() : objectMatcher;
        this.id = spaceID;
    }

    @Override
    public final <E extends T> E read(E template) {
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        return this.readNotNull(template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends T> E readNotNull(E template) {
        Set<Class<?>> cls = this.getClasses(template.getClass());
        this.readObjects.lock();
        try {
            Iterator<Class<?>> cIter = cls.iterator();
            while (cIter.hasNext()) {
                Set<T> eObjects = this.objects.get(cIter.next());
                if (eObjects == null) continue;
                for (T e : eObjects) {
                    if (!this.matcher.isMatching(template, e)) continue;
                    T t = e;
                    return (E)t;
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        finally {
            this.readObjects.unlock();
        }
        return null;
    }

    @Override
    public final <E extends T> E read(E template, long timeout) {
        long last = System.currentTimeMillis();
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        if (timeout < 1L) {
            return this.readNotNull(template);
        }
        E entry = this.readNotNull(template);
        if (entry != null) {
            return entry;
        }
        long current = System.currentTimeMillis();
        timeout -= current - last;
        last = current;
        while (timeout > 0L) {
            this.waitForInterrupt(timeout);
            entry = this.readNotNull(template);
            if (entry != null) {
                return entry;
            }
            current = System.currentTimeMillis();
            timeout -= current - last;
            last = current;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForInterrupt(long timeout) {
        String string = this.mutex;
        synchronized (string) {
            if (Thread.interrupted()) {
                return true;
            }
            try {
                this.mutex.wait(timeout);
            }
            catch (InterruptedException e) {
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <E extends T> Set<E> readAll(E template) {
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        Set<Class<?>> cls = this.getClasses(template.getClass());
        HashSet<T> all = new HashSet<T>();
        this.readObjects.lock();
        try {
            Iterator<Class<?>> cIter = cls.iterator();
            while (cIter.hasNext()) {
                Set<T> eObjects = this.objects.get(cIter.next());
                if (eObjects == null) continue;
                for (T e : eObjects) {
                    if (!this.matcher.isMatching(template, e)) continue;
                    all.add(e);
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        finally {
            this.readObjects.unlock();
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <E extends T> E remove(E template) {
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        Set<Class<?>> cls = this.getClasses(template.getClass());
        this.writeObjects.lock();
        try {
            for (Class<?> c : cls) {
                Set<T> eObjects = this.objects.get(c);
                if (eObjects == null) continue;
                Iterator<T> i = eObjects.iterator();
                while (i.hasNext()) {
                    T e = i.next();
                    if (!this.matcher.isMatching(template, e)) continue;
                    i.remove();
                    if (eObjects.size() < 1) {
                        this.objects.remove(c);
                        this.writeClasses.lock();
                        try {
                            this.classes.remove(c);
                        }
                        catch (RuntimeException re) {
                            re.printStackTrace();
                        }
                        finally {
                            this.writeClasses.unlock();
                        }
                    }
                    T t = e;
                    return (E)t;
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
        finally {
            this.writeObjects.unlock();
        }
        return null;
    }

    @Override
    public final <E extends T> E remove(E template, long timeout) {
        long last = System.currentTimeMillis();
        if (timeout < 1L) {
            return this.remove(template);
        }
        E entry = this.remove(template);
        if (entry != null) {
            return entry;
        }
        long current = System.currentTimeMillis();
        timeout -= current - last;
        last = current;
        while (timeout > 0L) {
            this.waitForInterrupt(timeout);
            entry = this.remove(template);
            if (entry != null) {
                return entry;
            }
            current = System.currentTimeMillis();
            timeout -= current - last;
            last = current;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <E extends T> Set<E> removeAll(E template) {
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        Set<Class<?>> cls = this.getClasses(template.getClass());
        HashSet<T> all = new HashSet<T>();
        this.writeObjects.lock();
        try {
            for (Class<?> c : cls) {
                Set<T> eObjects = this.objects.get(c);
                if (eObjects == null) continue;
                Iterator<T> i = eObjects.iterator();
                while (i.hasNext()) {
                    T e = i.next();
                    if (!this.matcher.isMatching(template, e)) continue;
                    i.remove();
                    all.add(e);
                }
                if (eObjects.size() >= 1) continue;
                this.objects.remove(c);
                this.writeClasses.lock();
                try {
                    this.classes.remove(c);
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                }
                finally {
                    this.writeClasses.unlock();
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
        finally {
            this.writeObjects.unlock();
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(T o) {
        if (o == null) {
            throw new IllegalArgumentException("o is null");
        }
        Class<?> c = o.getClass();
        this.writeObjects.lock();
        try {
            Set<T> allC = this.objects.get(c);
            if (allC == null) {
                allC = new HashSet<T>();
                this.objects.put(c, allC);
                HashSet newClasses = new HashSet();
                newClasses.add(c);
                this.writeClasses.lock();
                try {
                    for (Class<?> old : this.classes.keySet()) {
                        if (old.isInstance(o)) {
                            HashSet oldClasses = new HashSet((Collection)this.classes.get(old));
                            oldClasses.add(c);
                            this.classes.put(old, oldClasses);
                            continue;
                        }
                        if (!c.isAssignableFrom(old)) continue;
                        newClasses.add(old);
                    }
                    this.classes.put(c, newClasses);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                finally {
                    this.writeClasses.unlock();
                }
            }
            allC.add(o);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        finally {
            this.writeObjects.unlock();
        }
        String string = this.mutex;
        synchronized (string) {
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <E extends T> boolean update(E template, E o) {
        Set<E> matched = this.readAll(template);
        if (matched.isEmpty()) {
            return false;
        }
        this.updater.update(o, matched);
        String string = this.mutex;
        synchronized (string) {
            this.mutex.notifyAll();
        }
        return true;
    }

    @Override
    public final String getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Class<?>> getClasses(Class<?> c) {
        Set<Class<?>> cls = this.classes.get(c);
        if (cls == null) {
            cls = new HashSet();
            this.readClasses.lock();
            try {
                for (Class<?> old : this.classes.keySet()) {
                    if (!c.isAssignableFrom(old)) continue;
                    cls.add(old);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            finally {
                this.readClasses.unlock();
            }
            this.writeClasses.lock();
            try {
                this.classes.put(c, cls);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            finally {
                this.writeClasses.unlock();
            }
        }
        return cls;
    }

    @Override
    public final ObjectMatcher getMatcher() {
        return this.matcher;
    }

    @Override
    public final ObjectUpdater getUpdater() {
        return this.updater;
    }

    @Override
    public final Iterator<T> iterator() {
        return new SimpleObjectSpaceIterator(this);
    }

    public final String toString() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <E extends T> Set<E> readAllOfType(Class<E> type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        HashSet<T> entries = new HashSet<T>();
        HashSet<Class<E>> types = new HashSet<Class<E>>(this.getClasses(type));
        this.readObjects.lock();
        try {
            for (Class clazz : types) {
                Set<T> eObjects = this.objects.get(clazz);
                if (eObjects == null) continue;
                entries.addAll(eObjects);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            HashSet<T> hashSet = entries;
            return hashSet;
        }
        finally {
            this.readObjects.unlock();
        }
        return entries;
    }

    @Override
    public final Set<T> readAll() {
        HashSet<T> elements = new HashSet<T>(this.objects.size() * 10);
        for (Set<T> set : this.objects.values()) {
            elements.addAll(set);
        }
        return elements;
    }

    protected final void setMatcher(ObjectMatcher newMatcher) {
        if (newMatcher == null) {
            throw new IllegalArgumentException("newMatcher is null");
        }
        this.matcher = newMatcher;
    }

    protected final void setUpdater(ObjectUpdater newUpdater) {
        if (newUpdater == null) {
            throw new IllegalArgumentException("newUpdater is null");
        }
        this.updater = newUpdater;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleObjectSpaceIterator<E>
    implements Iterator<E>,
    Serializable {
        private static final long serialVersionUID = 6809554849397188676L;
        private static final int ELEMENTS_ALLOCATED_PER_CLASS = 10;
        private final TupleSpace<E> space;
        private final List<E> elements;
        private int size;
        private int index = 0;
        private boolean canRemove = false;

        SimpleObjectSpaceIterator(SimpleObjectSpace<E> initSpace) {
            this.space = initSpace;
            this.elements = new ArrayList(initSpace.objects.size() * 10);
            for (Set set : initSpace.objects.values()) {
                this.elements.addAll(set);
            }
            this.size = this.elements.size();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.canRemove = true;
            return this.elements.get(this.index++);
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            this.space.remove(this.elements.remove(this.index - 1));
            --this.size;
            this.canRemove = false;
        }
    }
}

