/*
 * Decompiled with CFR 0.152.
 */
package org.sercho.masp.space.copy;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sercho.masp.space.ObjectMatcher;
import org.sercho.masp.space.ObjectUpdater;
import org.sercho.masp.space.copy.ObjectCloner;
import org.sercho.masp.space.copy.ReflectiveCloner;
import org.sercho.masp.space.copy.SerializableCloner;
import org.sercho.masp.space.event.EventedTupleSpace;
import org.sercho.masp.space.event.SpaceObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CopyingSpaceWrapper<T>
implements EventedTupleSpace<T> {
    private static final long serialVersionUID = 6360830556234738518L;
    private final EventedTupleSpace<T> space;
    private final List<ObjectCloner<T>> cloners = new LinkedList<ObjectCloner<T>>();

    public CopyingSpaceWrapper(EventedTupleSpace<T> ts) {
        if (ts == null) {
            throw new IllegalArgumentException("tuple space is null");
        }
        this.space = ts;
        this.cloners.add(new SerializableCloner());
        this.cloners.add(new ReflectiveCloner());
    }

    public CopyingSpaceWrapper(EventedTupleSpace<T> ts, Set<ObjectCloner<T>> objectCloners) {
        if (ts == null) {
            throw new IllegalArgumentException("tuple space is null");
        }
        if (objectCloners == null) {
            throw new IllegalArgumentException("objectCloners set is null");
        }
        this.space = ts;
        for (ObjectCloner<T> cloner : objectCloners) {
            if (cloner == null) continue;
            this.cloners.add(cloner);
        }
        if (this.cloners.isEmpty()) {
            throw new IllegalArgumentException("objectCloners set is empty");
        }
    }

    @Override
    public String getID() {
        return this.space.getID();
    }

    @Override
    public <E extends T> E read(E template) {
        return this.copy(this.space.read(template));
    }

    @Override
    public <E extends T> E read(E template, long timeout) {
        return this.copy(this.space.read(template, timeout));
    }

    @Override
    public <E extends T> Set<E> readAll(E template) {
        HashSet<E> copies = new HashSet<E>();
        for (E e : this.space.readAll(template)) {
            copies.add(this.copy(e));
        }
        return copies;
    }

    @Override
    public <E extends T> E remove(E template) {
        return this.space.remove(template);
    }

    @Override
    public <E extends T> E remove(E template, long timeout) {
        return this.space.remove(template, timeout);
    }

    @Override
    public <E extends T> Set<E> removeAll(E template) {
        return this.space.removeAll(template);
    }

    @Override
    public void write(T o) {
        this.space.write(this.copy(o));
    }

    @Override
    public <E extends T> boolean update(E template, E o) {
        return this.space.update(template, this.copy(o));
    }

    private T copy(T original) {
        if (original == null) {
            return null;
        }
        for (ObjectCloner<T> cloner : this.cloners) {
            T copy = cloner.copy(original);
            if (copy == null) continue;
            return copy;
        }
        System.out.println("CopyingSpaceWrapper.copy: Failed to copy: " + original);
        return null;
    }

    public void addCloner(ObjectCloner<T> cloner) {
        if (cloner != null) {
            this.cloners.add(cloner);
        }
    }

    @Override
    public void attach(SpaceObserver<? super T> observer) {
        this.space.attach(observer);
    }

    @Override
    public void attach(SpaceObserver<? super T> observer, T template) {
        this.space.attach(observer, (T)template);
    }

    @Override
    public void detach(SpaceObserver<? super T> observer) {
        this.space.detach(observer);
    }

    @Override
    public ObjectMatcher getMatcher() {
        return this.space.getMatcher();
    }

    @Override
    public ObjectUpdater getUpdater() {
        return this.space.getUpdater();
    }

    @Override
    public Iterator<T> iterator() {
        return this.space.iterator();
    }

    @Override
    public <E extends T> Set<E> readAllOfType(Class<E> type) {
        HashSet<E> copies = new HashSet<E>();
        for (E e : this.space.readAllOfType(type)) {
            copies.add(this.copy(e));
        }
        return copies;
    }

    @Override
    public Set<T> readAll() {
        HashSet copies = new HashSet();
        for (Object t : this.space.readAll()) {
            copies.add(this.copy(t));
        }
        return copies;
    }
}

