/*
 * Decompiled with CFR 0.152.
 */
package org.sercho.masp.space.copy;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.sercho.masp.space.copy.ObjectCloner;
import org.sercho.masp.util.GetterSetterFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectiveCloner<T>
implements ObjectCloner<T> {
    private static final long serialVersionUID = 164255209259861741L;
    public static final Map<Class<?>, ObjectCloner<? extends Object>> CLONERS = new HashMap();

    private <E> E copyReflective(E original) {
        Object copy;
        if (original == null) {
            return null;
        }
        Class<?> c = original.getClass();
        ObjectCloner<? extends Object> cloner = CLONERS.get(c);
        if (cloner != null) {
            return (E)cloner.copy(original);
        }
        try {
            copy = c.newInstance();
        }
        catch (Exception e) {
            return null;
        }
        catch (ExceptionInInitializerError e) {
            return null;
        }
        return this.copyFields(original, copy) && this.copyGetters(c, original, copy) ? (E)copy : null;
    }

    private boolean copyFields(Object original, Object copy) {
        for (Map.Entry entry : GetterSetterFinder.getNonNullFields((Object)original).entrySet()) {
            Object value = this.copyReflective(entry.getValue());
            if (value == null) {
                return false;
            }
            try {
                ((Field)entry.getKey()).set(copy, value);
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }
        return true;
    }

    private boolean copyGetters(Class<?> c, Object original, Object copy) {
        for (Map.Entry entry : GetterSetterFinder.getGetters(c).entrySet()) {
            Object value;
            try {
                value = ((Method)entry.getValue()).invoke(original, new Object[0]);
            }
            catch (IllegalAccessException e1) {
                return false;
            }
            catch (InvocationTargetException e1) {
                return false;
            }
            if (value == null) continue;
            if ((value = this.copyReflective(value)) == null) {
                return false;
            }
            try {
                GetterSetterFinder.setFieldValue((Object)copy, (String)((String)entry.getKey()), (Object)value);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public T copy(T original) {
        return this.copyReflective(original);
    }

    static {
        CLONERS.put(Double.class, new ImmutableCloner());
        CLONERS.put(Integer.class, new ImmutableCloner());
        CLONERS.put(Float.class, new ImmutableCloner());
        CLONERS.put(Byte.class, new ImmutableCloner());
        CLONERS.put(Character.class, new ImmutableCloner());
        CLONERS.put(String.class, new ImmutableCloner());
        CLONERS.put(Long.class, new ImmutableCloner());
        CLONERS.put(Boolean.class, new ImmutableCloner());
        CLONERS.put(BigDecimal.class, (ObjectCloner<? extends Object>)new ObjectCloner<BigDecimal>(){
            private static final long serialVersionUID = 3683164492863061611L;

            @Override
            public BigDecimal copy(BigDecimal original) {
                return new BigDecimal(original.toString());
            }
        });
        CLONERS.put(BigInteger.class, (ObjectCloner<? extends Object>)new ObjectCloner<BigInteger>(){
            private static final long serialVersionUID = 8536180218714964017L;

            @Override
            public BigInteger copy(BigInteger original) {
                return new BigInteger(original.toString());
            }
        });
        CLONERS.put(AtomicInteger.class, (ObjectCloner<? extends Object>)new ObjectCloner<AtomicInteger>(){
            private static final long serialVersionUID = -483497795218177959L;

            @Override
            public AtomicInteger copy(AtomicInteger original) {
                return new AtomicInteger(original.intValue());
            }
        });
        CLONERS.put(AtomicLong.class, (ObjectCloner<? extends Object>)new ObjectCloner<AtomicLong>(){
            private static final long serialVersionUID = -2903234346526793481L;

            @Override
            public AtomicLong copy(AtomicLong original) {
                return new AtomicLong(original.longValue());
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImmutableCloner<I>
    implements ObjectCloner<I> {
        private static final long serialVersionUID = -1741726175254704928L;

        ImmutableCloner() {
        }

        @Override
        public I copy(I original) {
            return original;
        }
    }
}

