/*
 * Decompiled with CFR 0.152.
 */
package org.sercho.masp.space.event;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.sercho.masp.space.ObjectMatcher;
import org.sercho.masp.space.ObjectUpdater;
import org.sercho.masp.space.SimpleObjectSpace;
import org.sercho.masp.space.TupleSpace;
import org.sercho.masp.space.event.EventedTupleSpace;
import org.sercho.masp.space.event.RemoveAllCallEvent;
import org.sercho.masp.space.event.RemoveCallEvent;
import org.sercho.masp.space.event.SpaceEvent;
import org.sercho.masp.space.event.SpaceObserver;
import org.sercho.masp.space.event.UpdateCallEvent;
import org.sercho.masp.space.event.WriteCallEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventedSpaceWrapper<T>
implements EventedTupleSpace<T> {
    private static final long serialVersionUID = -9045219999652665459L;
    private final EventDispatcher<T> dispatcher;
    private final TupleSpace<T> space;

    public static <T> SpaceDestroyer<T> getSpaceWithDestroyer(String spaceName) {
        return new SpaceDestroyer<T>(new EventedSpaceWrapper<T>(spaceName));
    }

    public static <T> SpaceDestroyer<T> getSpaceWithDestroyer(TupleSpace<T> space) {
        return new SpaceDestroyer<T>(new EventedSpaceWrapper<T>(space));
    }

    public EventedSpaceWrapper(TupleSpace<T> ts) {
        if (ts == null) {
            throw new IllegalArgumentException("tuple space is null");
        }
        this.space = ts;
        this.dispatcher = new EventDispatcher<T>(this.space);
        this.dispatcher.start();
    }

    public EventedSpaceWrapper(String spaceName) {
        this(new SimpleObjectSpace(spaceName));
    }

    @Override
    public String getID() {
        return this.space.getID();
    }

    @Override
    public <E extends T> E read(E template) {
        return this.space.read(template);
    }

    @Override
    public <E extends T> Set<E> readAll(E template) {
        return this.space.readAll(template);
    }

    @Override
    public <E extends T> E remove(E template) {
        E removed = this.space.remove(template);
        this.fireEvent(new RemoveCallEvent<E>(this, template, removed));
        return removed;
    }

    @Override
    public <E extends T> E remove(E template, long timeout) {
        E removed = this.space.remove(template, timeout);
        this.fireEvent(new RemoveCallEvent<E>(this, template, removed));
        return removed;
    }

    @Override
    public <E extends T> Set<E> removeAll(E template) {
        Set<E> removed = this.space.removeAll(template);
        this.fireEvent(new RemoveAllCallEvent<E>(this, template, removed));
        return removed;
    }

    @Override
    public void write(T o) {
        this.space.write(o);
        this.fireEvent(new WriteCallEvent<T>(this, o));
    }

    @Override
    public <E extends T> boolean update(E template, E o) {
        if (this.space.update(template, o)) {
            this.fireEvent(new UpdateCallEvent<E>(this, template, o));
            return true;
        }
        return false;
    }

    protected void fireEvent(SpaceEvent<? extends T> event) {
        if (event == null) {
            return;
        }
        this.dispatcher.eventQueue.add(event);
    }

    @Override
    public void attach(SpaceObserver<? super T> observer) {
        if (observer != null) {
            this.dispatcher.attach(observer);
        }
    }

    @Override
    public void attach(SpaceObserver<? super T> observer, T template) {
        if (observer != null) {
            if (template == null) {
                this.dispatcher.attach(observer);
            } else {
                this.dispatcher.attach(observer, (T)template);
            }
        }
    }

    @Override
    public void detach(SpaceObserver<? super T> observer) {
        if (observer != null) {
            this.dispatcher.detach(observer);
        }
    }

    @Override
    public <E extends T> E read(E template, long timeout) {
        return this.space.read(template, timeout);
    }

    @Override
    public ObjectMatcher getMatcher() {
        return this.space.getMatcher();
    }

    @Override
    public ObjectUpdater getUpdater() {
        return this.space.getUpdater();
    }

    @Override
    public Iterator<T> iterator() {
        return new SpaceIterator(this.space.iterator(), this);
    }

    @Override
    public <E extends T> Set<E> readAllOfType(Class<E> type) {
        return this.space.readAllOfType(type);
    }

    @Override
    public Set<T> readAll() {
        return this.space.readAll();
    }

    private void destroy() {
        this.dispatcher.close();
        try {
            this.dispatcher.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SpaceIterator<T>
    implements Iterator<T>,
    Serializable {
        private static final long serialVersionUID = 1235436715378376301L;
        private final Iterator<T> iterator;
        private final EventedTupleSpace<T> space;
        private T current;

        public SpaceIterator(Iterator<T> nonEventedIterator, EventedTupleSpace<T> eventedSpace) {
            this.iterator = nonEventedIterator;
            this.space = eventedSpace;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.space.remove(this.current);
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SpaceDestroyer<T>
    implements Destroyable,
    Serializable {
        private static final long serialVersionUID = 6554557223485705865L;
        private boolean destroyed = false;
        public final EventedSpaceWrapper<T> destroybleSpace;

        SpaceDestroyer(EventedSpaceWrapper<T> toDestroy) {
            this.destroybleSpace = toDestroy;
        }

        @Override
        public synchronized void destroy() throws DestroyFailedException {
            if (this.destroyed) {
                throw new DestroyFailedException("Already destroyed");
            }
            ((EventedSpaceWrapper)this.destroybleSpace).destroy();
            this.destroyed = true;
        }

        @Override
        public synchronized boolean isDestroyed() {
            return this.destroyed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventDispatcher<T>
    extends Thread
    implements Serializable {
        private static final long serialVersionUID = 3499376172310222579L;
        private static final int EVENT_POLLING_TIMEOUT = 3;
        volatile Set<SpaceObserver<T>> observers = Collections.emptySet();
        final Map<SpaceObserver<T>, T> templates = new HashMap<SpaceObserver<T>, T>();
        private final ObjectMatcher matcher;
        private volatile boolean running = true;
        final BlockingQueue<SpaceEvent<? extends T>> eventQueue = new LinkedBlockingQueue<SpaceEvent<? extends T>>();

        EventDispatcher(TupleSpace<T> eventedSpace) {
            this.matcher = eventedSpace.getMatcher();
            this.setName(eventedSpace.getID() + " EventDispatcher");
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    this.fire(this.eventQueue.poll(3L, TimeUnit.SECONDS));
                }
                catch (InterruptedException interruptedException) {}
            }
            System.out.println("EventDispatcher thread closed");
        }

        private void fire(SpaceEvent<? extends T> event) {
            if (event == null) {
                return;
            }
            T eventTemplate = this.getTemplate(event);
            try {
                if (eventTemplate == null) {
                    for (SpaceObserver<T> observer : this.observers) {
                        this.notify(observer, event);
                    }
                } else {
                    for (SpaceObserver<T> observer : this.observers) {
                        T observerTemplate = this.templates.get(observer);
                        if (observerTemplate != null && !this.matcher.isMatching(observerTemplate, eventTemplate)) continue;
                        this.notify(observer, event);
                    }
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }

        private T getTemplate(SpaceEvent<? extends T> event) {
            if (event instanceof WriteCallEvent) {
                return (T)((WriteCallEvent)event).getObject();
            }
            if (event instanceof UpdateCallEvent) {
                return (T)((UpdateCallEvent)event).getTemplate();
            }
            if (event instanceof RemoveCallEvent) {
                return (T)((RemoveCallEvent)event).getTemplate();
            }
            if (event instanceof RemoveAllCallEvent) {
                return (T)((RemoveAllCallEvent)event).getTemplate();
            }
            return null;
        }

        private void notify(SpaceObserver<T> observer, SpaceEvent<? extends T> event) {
            try {
                observer.notify(event);
            }
            catch (RuntimeException e) {
                System.err.println("Observer " + observer + " thrown an exception in notify(SpaceEvent) for event: " + event);
                e.printStackTrace();
            }
        }

        final void attach(SpaceObserver<T> observer) {
            HashSet<SpaceObserver<T>> newObservers = new HashSet<SpaceObserver<T>>(this.observers);
            newObservers.add(observer);
            this.observers = newObservers;
        }

        final void attach(SpaceObserver<T> observer, T template) {
            HashSet<SpaceObserver<T>> newObservers = new HashSet<SpaceObserver<T>>(this.observers);
            newObservers.add(observer);
            this.templates.put(observer, template);
            this.observers = newObservers;
        }

        final void detach(SpaceObserver<T> observer) {
            HashSet<SpaceObserver<T>> newObservers = new HashSet<SpaceObserver<T>>(this.observers);
            newObservers.remove(observer);
            this.observers = newObservers;
            this.templates.remove(observer);
        }

        final void close() {
            this.running = false;
            this.observers = Collections.emptySet();
            this.templates.clear();
        }
    }
}

