/*
 * Decompiled with CFR 0.152.
 */
package org.sercho.masp.space.remote;

import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.sercho.masp.space.ObjectMatcher;
import org.sercho.masp.space.ObjectUpdater;
import org.sercho.masp.space.event.EventedSpaceWrapper;
import org.sercho.masp.space.event.EventedTupleSpace;
import org.sercho.masp.space.event.SpaceObserver;
import org.sercho.masp.space.remote.JMXSpaceClientException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JMXSpaceClient<T>
implements EventedTupleSpace<T> {
    private static final long serialVersionUID = -4355583864813080237L;
    private final MBeanServerConnection server;
    private final ObjectName space;

    public JMXSpaceClient(MBeanServerConnection serverConnection, ObjectName spaceName) {
        if (serverConnection == null) {
            throw new IllegalArgumentException("serverConnection is null");
        }
        if (spaceName == null) {
            throw new IllegalArgumentException("spaceName is null");
        }
        this.server = serverConnection;
        this.space = spaceName;
    }

    @Override
    public void attach(SpaceObserver<? super T> observer) {
        try {
            this.server.invoke(this.space, "attach", new Object[]{observer}, new String[]{SpaceObserver.class.getName()});
        }
        catch (Exception e) {
            throw new JMXSpaceClientException(e);
        }
    }

    @Override
    public void attach(SpaceObserver<? super T> observer, T template) {
        try {
            this.server.invoke(this.space, "attach", new Object[]{observer, template}, new String[]{SpaceObserver.class.getName(), Object.class.getName()});
        }
        catch (Exception e) {
            throw new JMXSpaceClientException(e);
        }
    }

    @Override
    public void detach(SpaceObserver<? super T> observer) {
        try {
            this.server.invoke(this.space, "detach", new Object[]{observer}, new String[]{SpaceObserver.class.getName()});
        }
        catch (Exception e) {
            throw new JMXSpaceClientException(e);
        }
    }

    @Override
    public String getID() {
        Object result;
        try {
            result = this.server.getAttribute(this.space, "ID");
        }
        catch (Exception e) {
            throw new JMXSpaceClientException(e);
        }
        if (result instanceof String) {
            return (String)result;
        }
        throw new JMXSpaceClientException("getID did not return a String, but: " + result);
    }

    @Override
    public ObjectMatcher getMatcher() {
        Object result;
        try {
            result = this.server.getAttribute(this.space, "Matcher");
        }
        catch (Exception e) {
            throw new JMXSpaceClientException(e);
        }
        if (result instanceof ObjectMatcher) {
            return (ObjectMatcher)result;
        }
        throw new JMXSpaceClientException("Matcher attribute is not an ObjectMatcher, but: " + result);
    }

    @Override
    public ObjectUpdater getUpdater() {
        Object result;
        try {
            result = this.server.getAttribute(this.space, "Updater");
        }
        catch (Exception e) {
            throw new JMXSpaceClientException(e);
        }
        if (result instanceof ObjectUpdater) {
            return (ObjectUpdater)result;
        }
        throw new JMXSpaceClientException("Updater attribute is not an ObjectUpdater, but: " + result);
    }

    @Override
    public <E extends T> E read(E template) {
        Object result;
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        try {
            result = this.server.invoke(this.space, "read", new Object[]{template}, new String[]{Object.class.getName()});
        }
        catch (Exception e) {
            throw new JMXSpaceClientException(e);
        }
        if (result == null) {
            return null;
        }
        if (template.getClass().isInstance(result)) {
            return (E)result;
        }
        throw new JMXSpaceClientException("Wrong class of result: " + result);
    }

    @Override
    public <E extends T> E read(E template, long timeout) {
        Object result;
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        try {
            result = this.server.invoke(this.space, "read", new Object[]{template, timeout}, new String[]{Object.class.getName(), Long.TYPE.getName()});
        }
        catch (Exception e) {
            throw new JMXSpaceClientException(e);
        }
        if (result == null) {
            return null;
        }
        if (template.getClass().isInstance(result)) {
            return (E)result;
        }
        throw new JMXSpaceClientException("Wrong class of result: " + result);
    }

    @Override
    public <E extends T> Set<E> readAll(E template) {
        Object result;
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        try {
            result = this.server.invoke(this.space, "readAll", new Object[]{template}, new String[]{Object.class.getName()});
        }
        catch (Exception e) {
            throw new JMXSpaceClientException(e);
        }
        if (result == null) {
            return null;
        }
        if (result instanceof Set) {
            return (Set)result;
        }
        throw new JMXSpaceClientException("Wrong class of result: " + result);
    }

    @Override
    public <E extends T> Set<E> readAllOfType(Class<E> type) {
        Object result;
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        try {
            result = this.server.invoke(this.space, "readAllOfType", new Object[]{type}, new String[]{Class.class.getName()});
        }
        catch (Exception e) {
            throw new JMXSpaceClientException(e);
        }
        if (result == null) {
            return null;
        }
        if (result instanceof Set) {
            return (Set)result;
        }
        throw new JMXSpaceClientException("Wrong class of result: " + result);
    }

    @Override
    public <E extends T> E remove(E template) {
        Object result;
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        try {
            result = this.server.invoke(this.space, "remove", new Object[]{template}, new String[]{Object.class.getName()});
        }
        catch (Exception e) {
            throw new JMXSpaceClientException(e);
        }
        if (result == null) {
            return null;
        }
        if (template.getClass().isInstance(result)) {
            return (E)result;
        }
        throw new JMXSpaceClientException("Wrong class of result: " + result);
    }

    @Override
    public <E extends T> E remove(E template, long timeout) {
        Object result;
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        try {
            result = this.server.invoke(this.space, "read", new Object[]{template, timeout}, new String[]{Object.class.getName(), Long.TYPE.getName()});
        }
        catch (Exception e) {
            throw new JMXSpaceClientException(e);
        }
        if (result == null) {
            return null;
        }
        if (template.getClass().isInstance(result)) {
            return (E)result;
        }
        throw new JMXSpaceClientException("Wrong class of result: " + result);
    }

    @Override
    public <E extends T> Set<E> removeAll(E template) {
        Object result;
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        try {
            result = this.server.invoke(this.space, "removeAll", new Object[]{template}, new String[]{Object.class.getName()});
        }
        catch (Exception e) {
            throw new JMXSpaceClientException(e);
        }
        if (result == null) {
            return null;
        }
        if (result instanceof Set) {
            return (Set)result;
        }
        throw new JMXSpaceClientException("Wrong class of result: " + result);
    }

    @Override
    public <E extends T> boolean update(E template, E o) {
        Object result;
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        if (o == null) {
            throw new IllegalArgumentException("o is null");
        }
        try {
            result = this.server.invoke(this.space, "update", new Object[]{template, o}, new String[]{Object.class.getName(), Object.class.getName()});
        }
        catch (Exception e) {
            throw new JMXSpaceClientException(e);
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new JMXSpaceClientException("Wrong class of result: " + result);
    }

    @Override
    public void write(T o) {
        try {
            this.server.invoke(this.space, "write", new Object[]{o}, new String[]{Object.class.getName()});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JMXSpaceClientException(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new EventedSpaceWrapper.SpaceIterator<T>(this.readAll().iterator(), this);
    }

    @Override
    public Set<T> readAll() {
        Object result;
        try {
            result = this.server.invoke(this.space, "readAll", new Object[0], new String[0]);
        }
        catch (Exception e) {
            throw new JMXSpaceClientException(e);
        }
        if (result == null) {
            return null;
        }
        if (result instanceof Set) {
            return (Set)result;
        }
        throw new JMXSpaceClientException("Wrong class of result: " + result);
    }
}

