/*
 * Decompiled with CFR 0.152.
 */
package org.sercho.masp.space.remote;

import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.sercho.masp.space.ObjectMatcher;
import org.sercho.masp.space.ObjectUpdater;
import org.sercho.masp.space.event.EventedTupleSpace;
import org.sercho.masp.space.event.SpaceObserver;
import org.sercho.masp.space.remote.JMXSpaceWrapperMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JMXSpaceWrapper<T>
implements JMXSpaceWrapperMBean<T> {
    private static final long serialVersionUID = -8929486020038848258L;
    private static int index = 0;
    private final EventedTupleSpace<T> space;

    public static ObjectName register(EventedTupleSpace<?> space) {
        return JMXSpaceWrapper.register(space, ManagementFactory.getPlatformMBeanServer());
    }

    public static <T> ObjectName register(EventedTupleSpace<T> space, MBeanServer server) {
        if (space == null) {
            throw new IllegalArgumentException("space is null");
        }
        if (server == null) {
            throw new IllegalArgumentException("server is null");
        }
        ObjectName name = JMXSpaceWrapper.getObjectName();
        try {
            server.registerMBean(new JMXSpaceWrapper<T>(space), name);
            return name;
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            return null;
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            return null;
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ObjectName getObjectName() {
        try {
            return new ObjectName("org.sercho.masp.space.remote:type=JMXSpace,index=" + index++);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public JMXSpaceWrapper(EventedTupleSpace<T> spaceToWrap) {
        if (spaceToWrap == null) {
            throw new IllegalArgumentException("spaceToWrap is null");
        }
        this.space = spaceToWrap;
    }

    @Override
    public String getID() {
        return this.space.getID();
    }

    @Override
    public <E extends T> E read(E template) {
        return this.space.read(template);
    }

    @Override
    public <E extends T> E read(E template, long timeout) {
        return this.space.read(template, timeout);
    }

    @Override
    public <E extends T> Set<E> readAll(E template) {
        return this.space.readAll(template);
    }

    @Override
    public <E extends T> E remove(E template) {
        return this.space.remove(template);
    }

    @Override
    public <E extends T> E remove(E template, long timeout) {
        return this.space.remove(template, timeout);
    }

    @Override
    public <E extends T> Set<E> removeAll(E template) {
        return this.space.removeAll(template);
    }

    @Override
    public void write(T o) {
        this.space.write(o);
    }

    @Override
    public <E extends T> boolean update(E template, E o) {
        return this.space.update(template, o);
    }

    @Override
    public <E extends T> Set<E> readAllOfType(Class<E> type) {
        return this.space.readAllOfType(type);
    }

    @Override
    public void attach(SpaceObserver<? super T> observer) {
        this.space.attach(observer);
    }

    @Override
    public void attach(SpaceObserver<? super T> observer, T template) {
        this.space.attach(observer, (T)template);
    }

    @Override
    public void detach(SpaceObserver<? super T> observer) {
        this.space.detach(observer);
    }

    @Override
    public ObjectMatcher getMatcher() {
        return this.space.getMatcher();
    }

    @Override
    public ObjectUpdater getUpdater() {
        return this.space.getUpdater();
    }

    @Override
    public Iterator<T> iterator() {
        return this.space.iterator();
    }

    @Override
    public Set<T> readAll() {
        return this.space.readAll();
    }
}

