/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeListener;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.util.OWLEntityCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionTracker
implements OWLOntologyChangeListener {
    private Map<OWLEntity, Integer> referenceCounts = new HashMap<OWLEntity, Integer>();
    private OWLEntityCollector entityCollector = new OWLEntityCollector();
    private Set<OWLOntology> ontologies = new LinkedHashSet<OWLOntology>();
    private Set<OWLAxiom> axioms = new HashSet<OWLAxiom>();
    private OWLOntologyManager manager;
    private Integer ONE = 1;

    public DefinitionTracker(OWLOntologyManager manager) {
        this.manager = manager;
        manager.addOntologyChangeListener(this);
    }

    private void clear() {
        this.axioms.clear();
        this.ontologies.clear();
        this.referenceCounts.clear();
    }

    private void addAxiom(OWLAxiom axiom) {
        if (this.axioms.add(axiom)) {
            for (OWLEntity entity : this.getEntities(axiom)) {
                Integer count = this.referenceCounts.get(entity);
                count = count == null ? this.ONE : Integer.valueOf(count + 1);
                this.referenceCounts.put(entity, count);
            }
        }
    }

    private Set<OWLEntity> getEntities(OWLObject obj) {
        this.entityCollector.reset();
        obj.accept(this.entityCollector);
        return this.entityCollector.getObjects();
    }

    private void removeAxiom(OWLAxiom axiom) {
        if (this.axioms.remove(axiom)) {
            for (OWLEntity entity : this.getEntities(axiom)) {
                Integer count = this.referenceCounts.get(entity);
                if (count == 1) {
                    this.referenceCounts.remove(entity);
                    continue;
                }
                this.referenceCounts.put(entity, count - 1);
            }
        }
    }

    public void setOntology(OWLOntology ontology) {
        this.setOntologies(Collections.singleton(ontology));
    }

    public void setOntologies(Set<OWLOntology> ontologies) {
        this.clear();
        for (OWLOntology ont : ontologies) {
            for (OWLOntology importOnt : this.manager.getImportsClosure(ont)) {
                if (!this.ontologies.add(importOnt)) continue;
                for (OWLAxiom axiom : importOnt.getAxioms()) {
                    this.addAxiom(axiom);
                }
            }
        }
    }

    public Set<OWLOntology> getOntologies() {
        return this.ontologies;
    }

    public boolean isDefined(OWLEntity entity) {
        return entity.isBuiltIn() || this.referenceCounts.containsKey(entity);
    }

    public boolean isDefined(OWLDescription description) {
        for (OWLEntity entity : this.getEntities(description)) {
            if (this.isDefined(entity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !this.ontologies.contains(oWLOntologyChange.getOntology())) continue;
            OWLAxiom axiom = oWLOntologyChange.getAxiom();
            if (oWLOntologyChange instanceof AddAxiom) {
                this.addAxiom(axiom);
                continue;
            }
            if (oWLOntologyChange instanceof RemoveAxiom) {
                this.removeAxiom(axiom);
                continue;
            }
            throw new UnsupportedOperationException("Unrecognized axiom change: " + oWLOntologyChange);
        }
    }
}

