/*
 * Decompiled with CFR 0.152.
 */
package de.uulm.ecs.ai.owl.krssrenderer;

import de.uulm.ecs.ai.owl.krssrenderer.KRSS2Vocabulary;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLPropertyExpression;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KRSS2OWLObjectRenderer
implements OWLObjectVisitor {
    private final OWLOntology ontology;
    private final Writer writer;

    public KRSS2OWLObjectRenderer(OWLOntology ontology, Writer writer) {
        this.ontology = ontology;
        this.writer = writer;
    }

    private void writeOpenBracket() {
        try {
            this.writer.write("(");
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void writeCloseBracket() {
        try {
            this.writer.write(")");
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void write(int i) {
        try {
            this.writer.write(" " + i);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void write(URI uri) {
        try {
            this.writer.write(uri.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeAttribute(KRSS2Vocabulary v) {
        try {
            this.writeSpace();
            this.writer.write(":");
            this.writer.write(v.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void write(KRSS2Vocabulary v) {
        try {
            this.writer.write(v.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeSpace() {
        try {
            this.writer.write(" ");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeln() {
        try {
            this.writer.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void write(OWLDescription obj) {
        this.writeSpace();
        obj.accept(this);
    }

    public final void write(OWLIndividual ind) {
        this.writeSpace();
        ind.accept(this);
    }

    public final void write(OWLPropertyExpression obj) {
        this.writeSpace();
        obj.accept(this);
    }

    public final void write(OWLDataRange obj) {
        this.writeSpace();
        obj.accept(this);
    }

    private final void flatten(Set<OWLDescription> descriptions) {
        if (descriptions.isEmpty()) {
            return;
        }
        OWLDescription desc = descriptions.iterator().next();
        if (descriptions.size() == 1) {
            this.write(desc);
            return;
        }
        descriptions.remove(desc);
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AND);
        this.write(desc);
        this.flatten(descriptions);
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLOntology ontology) {
        for (OWLClass eachClass : ontology.getReferencedClasses()) {
            boolean primitive;
            boolean bl = primitive = !eachClass.isDefined(ontology);
            if (primitive) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_CONCEPT);
                this.write(eachClass);
                this.writeSpace();
                Set<OWLDescription> superClasses = eachClass.getSuperClasses(ontology);
                if (superClasses.size() == 1) {
                    this.write(superClasses.iterator().next());
                } else {
                    this.flatten(superClasses);
                }
                this.writeCloseBracket();
                this.writeln();
                for (OWLDescription description : eachClass.getEquivalentClasses(ontology)) {
                    this.writeOpenBracket();
                    this.write(eachClass);
                    this.write(KRSS2Vocabulary.EQUIVALENT);
                    this.writeSpace();
                    description.accept(this);
                    this.writeCloseBracket();
                    this.writeln();
                }
                continue;
            }
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_CONCEPT);
            this.write(eachClass);
            Set<OWLDescription> equivalentClasses = eachClass.getEquivalentClasses(ontology);
            if (equivalentClasses.isEmpty()) {
                this.writeCloseBracket();
                this.writeln();
                continue;
            }
            if (equivalentClasses.size() == 1) {
                this.write(equivalentClasses.iterator().next());
                this.writeCloseBracket();
                this.writeln();
                continue;
            }
            Iterator<OWLDescription> iter = equivalentClasses.iterator();
            this.write(iter.next());
            this.writeCloseBracket();
            this.writeln();
            while (iter.hasNext()) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.EQUIVALENT);
                this.write(eachClass);
                this.writeSpace();
                iter.next().accept(this);
                this.writeCloseBracket();
                this.writeln();
            }
        }
        for (OWLClassAxiom axiom : ontology.getGeneralClassAxioms()) {
            axiom.accept(this);
        }
        for (OWLObjectProperty property : ontology.getReferencedObjectProperties()) {
            Set superProperties;
            Set<OWLDescription> ranges;
            Set<OWLDescription> domains;
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_ROLE);
            this.write(property);
            if (property.isTransitive(ontology)) {
                this.writeAttribute(KRSS2Vocabulary.TRANSITIVE);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (property.isSymmetric(ontology)) {
                this.writeAttribute(KRSS2Vocabulary.SYMMETRIC);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (!(domains = property.getDomains(ontology)).isEmpty()) {
                this.writeAttribute(KRSS2Vocabulary.DOMAIN);
                this.flatten(domains);
            }
            if (!(ranges = property.getDomains(ontology)).isEmpty()) {
                this.writeAttribute(KRSS2Vocabulary.RANGE);
                this.flatten(ranges);
            }
            if (!(superProperties = property.getSuperProperties(ontology)).isEmpty()) {
                this.writeAttribute(KRSS2Vocabulary.PARENTS);
                this.writeOpenBracket();
                for (OWLObjectPropertyExpression express : superProperties) {
                    this.write(express);
                }
                this.writeCloseBracket();
            }
            this.writeCloseBracket();
        }
        try {
            this.writer.flush();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    @Override
    public final void visit(OWLSubClassAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.IMPLIES);
        this.write(axiom.getSubClass());
        this.write(axiom.getSuperClass());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
    }

    @Override
    public final void visit(OWLDisjointClassesAxiom axiom) {
        this.writeOpenBracket();
        for (OWLDescription desc : axiom.getDescriptions()) {
            this.write(desc);
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
    }

    @Override
    public void visit(OWLImportsDeclaration axiom) {
    }

    @Override
    public void visit(OWLAxiomAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
    }

    @Override
    public final void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.write(KRSS2Vocabulary.RELATED);
        this.write(axiom.getSubject());
        this.write((OWLIndividual)axiom.getObject());
        this.write((OWLPropertyExpression)axiom.getProperty());
        this.writeln();
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLObjectSubPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
    }

    @Override
    public void visit(OWLEntityAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLOntologyAnnotationAxiom axiom) {
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
    }

    @Override
    public final void visit(OWLClassAssertionAxiom axiom) {
        this.write(KRSS2Vocabulary.INSTANCE);
        this.write(axiom.getIndividual());
        this.write(axiom.getDescription());
        this.writeln();
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLDataSubPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLSameIndividualsAxiom axiom) {
    }

    @Override
    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
    }

    @Override
    public void visit(SWRLRule rule) {
    }

    @Override
    public void visit(SWRLClassAtom node) {
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
    }

    @Override
    public void visit(SWRLDataValuedPropertyAtom node) {
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
    }

    @Override
    public void visit(SWRLAtomDVariable node) {
    }

    @Override
    public void visit(SWRLAtomIVariable node) {
    }

    @Override
    public void visit(SWRLAtomIndividualObject node) {
    }

    @Override
    public void visit(SWRLAtomConstantObject node) {
    }

    @Override
    public void visit(SWRLSameAsAtom node) {
    }

    @Override
    public void visit(SWRLDifferentFromAtom node) {
    }

    @Override
    public final void visit(OWLClass desc) {
        this.write(desc.getURI());
    }

    @Override
    public final void visit(OWLObjectIntersectionOf desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AND);
        for (OWLDescription des : desc.getOperands()) {
            this.write(des);
        }
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLObjectUnionOf desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.OR);
        for (OWLDescription des : desc.getOperands()) {
            this.write(des);
        }
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLObjectComplementOf desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.NOT);
        this.write(desc.getOperand());
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLObjectSomeRestriction desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.SOME);
        this.write((OWLPropertyExpression)desc.getProperty());
        this.write((OWLDescription)desc.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLObjectAllRestriction desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.ALL);
        this.write((OWLPropertyExpression)desc.getProperty());
        this.write((OWLDescription)desc.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectValueRestriction desc) {
    }

    @Override
    public final void visit(OWLObjectMinCardinalityRestriction desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_LEAST);
        this.write(desc.getCardinality());
        this.write((OWLPropertyExpression)desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLDescription)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLObjectExactCardinalityRestriction desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.EXACTLY);
        this.write(desc.getCardinality());
        this.write((OWLPropertyExpression)desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLDescription)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLObjectMaxCardinalityRestriction desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_MOST);
        this.write(desc.getCardinality());
        this.write((OWLPropertyExpression)desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLDescription)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectSelfRestriction desc) {
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
    }

    @Override
    public final void visit(OWLDataSomeRestriction desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.SOME);
        this.write((OWLPropertyExpression)desc.getProperty());
        this.write((OWLDataRange)desc.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLDataAllRestriction desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.ALL);
        this.write((OWLPropertyExpression)desc.getProperty());
        this.write((OWLDataRange)desc.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataValueRestriction desc) {
    }

    @Override
    public final void visit(OWLDataMinCardinalityRestriction desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_LEAST);
        this.write(desc.getCardinality());
        this.write((OWLPropertyExpression)desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLDataRange)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLDataExactCardinalityRestriction desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.EXACTLY);
        this.write(desc.getCardinality());
        this.write((OWLPropertyExpression)desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLDataRange)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLDataMaxCardinalityRestriction desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_MOST);
        this.write(desc.getCardinality());
        this.write((OWLPropertyExpression)desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLDataRange)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataType node) {
    }

    @Override
    public void visit(OWLDataComplementOf node) {
    }

    @Override
    public void visit(OWLDataOneOf node) {
    }

    @Override
    public void visit(OWLDataRangeRestriction node) {
    }

    @Override
    public void visit(OWLTypedConstant node) {
    }

    @Override
    public void visit(OWLUntypedConstant node) {
    }

    @Override
    public void visit(OWLDataRangeFacetRestriction node) {
    }

    @Override
    public final void visit(OWLObjectProperty property) {
        this.write(property.getURI());
    }

    @Override
    public final void visit(OWLObjectPropertyInverse property) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.INVERSE);
        this.writeSpace();
        property.getInverse().accept(this);
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLDataProperty property) {
        this.write(property.getURI());
    }

    @Override
    public final void visit(OWLIndividual individual) {
        this.write(individual.getURI());
    }

    @Override
    public void visit(OWLObjectAnnotation annotation) {
    }

    @Override
    public void visit(OWLConstantAnnotation annotation) {
    }
}

