/*
 * Decompiled with CFR 0.152.
 */
package org.coode.obo.renderer;

import java.util.HashSet;
import java.util.Set;
import org.coode.obo.renderer.OBOExceptionHandler;
import org.coode.obo.renderer.OBORelationship;
import org.coode.obo.renderer.OBOStorageException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLQuantifiedRestriction;
import org.semanticweb.owl.util.OWLDescriptionVisitorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBORelationshipGenerator
extends OWLDescriptionVisitorAdapter {
    private Set<OBORelationship> relationships = new HashSet<OBORelationship>();
    private OBOExceptionHandler eHandler;
    private OWLClass cls;

    public OBORelationshipGenerator(OBOExceptionHandler eHandler) {
        this.eHandler = eHandler;
    }

    public void setClass(OWLClass cls) {
        this.cls = cls;
        this.clear();
    }

    public void clear() {
        this.relationships.clear();
    }

    public Set<OBORelationship> getOBORelationships() {
        return new HashSet<OBORelationship>(this.relationships);
    }

    @Override
    public void visit(OWLObjectSomeRestriction desc) {
        this.getRelationship(desc);
    }

    @Override
    public void visit(OWLObjectMinCardinalityRestriction desc) {
        OBORelationship rel = this.getRelationship(desc);
        if (rel != null) {
            rel.setMinCardinality(desc.getCardinality());
        }
    }

    @Override
    public void visit(OWLObjectExactCardinalityRestriction desc) {
        OBORelationship rel = this.getRelationship(desc);
        if (rel != null) {
            rel.setCardinality(desc.getCardinality());
        }
    }

    @Override
    public void visit(OWLObjectMaxCardinalityRestriction desc) {
        OBORelationship rel = this.getRelationship(desc);
        if (rel != null) {
            rel.setMaxCardinality(desc.getCardinality());
        }
    }

    private OBORelationship getRelationship(OWLQuantifiedRestriction<OWLObjectPropertyExpression, OWLDescription> desc) {
        if (desc.isAnonymous() && !desc.getFiller().isAnonymous()) {
            OWLObjectProperty p = ((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty();
            OWLClass f = desc.getFiller().asOWLClass();
            for (OBORelationship rel : this.relationships) {
                if (!rel.getProperty().equals(p) || !rel.getFiller().equals(f)) continue;
                return rel;
            }
            OBORelationship newRel = new OBORelationship(p, f);
            this.relationships.add(newRel);
            return newRel;
        }
        this.eHandler.addException(new OBOStorageException(this.cls, desc, "Anonymous filler of some restriction cannot be converted to OBO"));
        return null;
    }
}

