/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.owlxmlparser;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.coode.owl.owlxmlparser.AbstractOWLAxiomElementHandler;
import org.coode.owl.owlxmlparser.AbstractOWLDescriptionElementHandler;
import org.coode.owl.owlxmlparser.AbstractOWLObjectPropertyElementHandler;
import org.coode.owl.owlxmlparser.OWLAnnotationElementHandler;
import org.coode.owl.owlxmlparser.OWLDataPropertyElementHandler;
import org.coode.owl.owlxmlparser.OWLIndividualElementHandler;
import org.coode.owl.owlxmlparser.OWLXMLParserException;
import org.coode.owl.owlxmlparser.OWLXMLParserHandler;
import org.coode.owl.owlxmlparser.OWLXMLParserUnexpectedElementException;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLDeclarationAxiomElementHandler
extends AbstractOWLAxiomElementHandler {
    private OWLEntity entity;
    private Set<OWLAnnotation> entityAnnotations;

    public OWLDeclarationAxiomElementHandler(OWLXMLParserHandler handler) {
        super(handler);
    }

    @Override
    public void startElement(String name) throws OWLXMLParserException {
        super.startElement(name);
        this.entity = null;
        if (this.entityAnnotations != null) {
            this.entityAnnotations.clear();
        }
    }

    @Override
    public void handleChild(AbstractOWLDescriptionElementHandler handler) throws OWLXMLParserException {
        this.checkForEntity(handler.getOWLObject());
        this.entity = (OWLClass)handler.getOWLObject();
    }

    @Override
    public void handleChild(AbstractOWLObjectPropertyElementHandler handler) throws OWLXMLParserException {
        this.checkForEntity(handler.getOWLObject());
        this.entity = (OWLEntity)((Object)handler.getOWLObject());
    }

    @Override
    public void handleChild(OWLDataPropertyElementHandler handler) throws OWLXMLParserException {
        this.checkForEntity(handler.getOWLObject());
        this.entity = (OWLEntity)((Object)handler.getOWLObject());
    }

    @Override
    public void handleChild(OWLIndividualElementHandler handler) {
        this.entity = handler.getOWLObject();
    }

    @Override
    protected OWLAxiom createAxiom() throws OWLXMLParserException {
        return this.getOWLDataFactory().getOWLDeclarationAxiom(this.entity);
    }

    @Override
    public void handleChild(OWLAnnotationElementHandler handler) {
        if (this.entity == null) {
            super.handleChild(handler);
        } else {
            if (this.entityAnnotations == null) {
                this.entityAnnotations = new HashSet<OWLAnnotation>();
            }
            this.entityAnnotations.add(handler.getOWLObject());
        }
    }

    public Set<OWLAnnotation> getEntityAnnotations() {
        if (this.entityAnnotations == null) {
            return Collections.emptySet();
        }
        return this.entityAnnotations;
    }

    private void checkForEntity(OWLObject obj) throws OWLXMLParserException {
        if (!(obj instanceof OWLEntity)) {
            throw new OWLXMLParserUnexpectedElementException(this.getLineNumber(), "Only OWL entities may declared with declaration axioms");
        }
    }
}

