/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdf.renderer;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.coode.owl.rdf.model.RDFGraph;
import org.coode.owl.rdf.model.RDFLiteralNode;
import org.coode.owl.rdf.model.RDFNode;
import org.coode.owl.rdf.model.RDFResourceNode;
import org.coode.owl.rdf.model.RDFTranslator;
import org.coode.owl.rdf.model.RDFTriple;
import org.semanticweb.owl.io.RDFXMLOntologyFormat;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLLogicalAxiom;
import org.semanticweb.owl.model.OWLNamedObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyFormat;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.util.SWRLVariableExtractor;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RDFRendererBase {
    public static final String RENDER_DECLARATION_AXIOMS_KEY = "RENDER_DECLARATION_AXIOMS_KEY";
    protected OWLOntologyManager manager;
    protected OWLOntology ontology;
    private RDFGraph graph;
    protected Set<URI> annotationURIs;
    protected Set<URI> prettyPrintedTypes;
    private boolean renderDeclarationAxioms;
    private OWLOntologyFormat format;

    public RDFRendererBase(OWLOntology ontology, OWLOntologyManager manager) {
        this(ontology, manager, manager.getOntologyFormat(ontology));
    }

    protected RDFRendererBase(OWLOntology ontology, OWLOntologyManager manager, OWLOntologyFormat format) {
        this.ontology = ontology;
        this.annotationURIs = ontology.getAnnotationURIs();
        this.manager = manager;
        this.format = format;
        this.renderDeclarationAxioms = (Boolean)format.getParameter(RENDER_DECLARATION_AXIOMS_KEY, false);
    }

    public RDFGraph getGraph() {
        return this.graph;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    protected abstract void beginDocument();

    public void render() {
        Set<OWLIndividual> individuals;
        Set<OWLClass> clses;
        Set<OWLDataProperty> dataProperties;
        Set<OWLObjectProperty> objectProperties;
        this.beginDocument();
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.ontology.getImportsDeclarations());
        axioms.addAll(this.ontology.getOntologyAnnotationAxioms());
        this.createGraph(axioms);
        this.graph.addTriple(new RDFTriple(new RDFResourceNode(this.ontology.getURI()), new RDFResourceNode(OWLRDFVocabulary.RDF_TYPE.getURI()), new RDFResourceNode(OWLRDFVocabulary.OWL_ONTOLOGY.getURI())));
        this.render(new RDFResourceNode(this.ontology.getURI()));
        for (OWLOntologyAnnotationAxiom ax : this.ontology.getOntologyAnnotationAxioms()) {
            if (((OWLOntology)ax.getSubject()).equals(this.ontology)) continue;
            this.render(new RDFResourceNode(((OWLOntology)ax.getSubject()).getURI()));
        }
        HashSet<URI> annotationURIs = new HashSet<URI>(this.ontology.getAnnotationURIs());
        annotationURIs.removeAll(OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTIES);
        Map<URI, Set<OWLAnnotation>> annoURIAnnotations = Collections.emptyMap();
        OWLOntologyFormat format = this.getOntologyFormat();
        if (format instanceof RDFXMLOntologyFormat) {
            RDFXMLOntologyFormat rdfXMLFormat = (RDFXMLOntologyFormat)format;
            annotationURIs.addAll(rdfXMLFormat.getAnnotationURIs());
            annoURIAnnotations = rdfXMLFormat.getAnnotationURIAnnotations();
        }
        if (!annotationURIs.isEmpty()) {
            this.writeBanner("Annotation properties");
            this.graph = new RDFGraph();
            for (URI uri : annotationURIs) {
                this.graph.addTriple(new RDFTriple(new RDFResourceNode(uri), new RDFResourceNode(OWLRDFVocabulary.RDF_TYPE.getURI()), new RDFResourceNode(OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getURI())));
                for (OWLAnnotation anno : this.getAnnotationsForURIViaHack(annoURIAnnotations, uri)) {
                    if (anno.isAnnotationByConstant()) {
                        OWLConstant con = anno.getAnnotationValueAsConstant();
                        RDFLiteralNode obj = con.isTyped() ? new RDFLiteralNode(con.getLiteral(), con.asOWLTypedConstant().getDataType().getURI()) : (con.asOWLUntypedConstant().hasLang() ? new RDFLiteralNode(con.getLiteral(), con.asOWLUntypedConstant().getLang()) : new RDFLiteralNode(con.getLiteral()));
                        this.graph.addTriple(new RDFTriple(new RDFResourceNode(uri), new RDFResourceNode(anno.getAnnotationURI()), obj));
                        continue;
                    }
                    if (!(anno.getAnnotationValue() instanceof OWLNamedObject)) continue;
                    OWLNamedObject obj = (OWLNamedObject)anno.getAnnotationValue();
                    this.graph.addTriple(new RDFTriple(new RDFResourceNode(uri), new RDFResourceNode(anno.getAnnotationURI()), new RDFResourceNode(obj.getURI())));
                }
                this.render(new RDFResourceNode(uri));
            }
        }
        if (!(objectProperties = this.ontology.getReferencedObjectProperties()).isEmpty()) {
            this.writeBanner("Object Properties");
            for (OWLObjectProperty prop : RDFRendererBase.toSortedSet(objectProperties)) {
                if (!this.createGraph(prop)) continue;
                this.beginObject();
                this.writeObjectPropertyComment(prop);
                this.render(new RDFResourceNode(prop.getURI()));
                this.renderAnonRoots();
                this.endObject();
            }
        }
        if (!(dataProperties = this.ontology.getReferencedDataProperties()).isEmpty()) {
            this.writeBanner("Data properties");
            for (OWLDataProperty prop : RDFRendererBase.toSortedSet(this.ontology.getReferencedDataProperties())) {
                if (!this.createGraph(prop)) continue;
                this.beginObject();
                this.writeDataPropertyComment(prop);
                this.render(new RDFResourceNode(prop.getURI()));
                this.renderAnonRoots();
                this.endObject();
            }
        }
        if (!(clses = this.ontology.getReferencedClasses()).isEmpty()) {
            this.writeBanner("Classes");
            for (OWLClass cls : RDFRendererBase.toSortedSet(clses)) {
                if (!this.createGraph(cls)) continue;
                this.beginObject();
                this.writeClassComment(cls);
                this.render(new RDFResourceNode(cls.getURI()));
                this.renderAnonRoots();
                this.endObject();
            }
        }
        if (!(individuals = this.ontology.getReferencedIndividuals()).isEmpty()) {
            this.writeBanner("Individuals");
            for (OWLIndividual ind : RDFRendererBase.toSortedSet(this.ontology.getReferencedIndividuals())) {
                if (!this.createGraph(ind)) continue;
                this.beginObject();
                this.writeIndividualComments(ind);
                if (!ind.isAnonymous()) {
                    this.render(new RDFResourceNode(ind.getURI()));
                    this.renderAnonRoots();
                } else {
                    this.render(new RDFResourceNode(System.identityHashCode(ind)));
                }
                this.endObject();
            }
        }
        HashSet<OWLLogicalAxiom> generalAxioms = new HashSet<OWLLogicalAxiom>();
        generalAxioms.addAll(this.ontology.getGeneralClassAxioms());
        generalAxioms.addAll(this.ontology.getAxioms(AxiomType.DIFFERENT_INDIVIDUALS));
        for (OWLDisjointClassesAxiom oWLDisjointClassesAxiom : this.ontology.getAxioms(AxiomType.DISJOINT_CLASSES)) {
            if (oWLDisjointClassesAxiom.getDescriptions().size() <= 2) continue;
            generalAxioms.add(oWLDisjointClassesAxiom);
        }
        for (OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom : this.ontology.getAxioms(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            if (oWLDisjointObjectPropertiesAxiom.getProperties().size() <= 2) continue;
            generalAxioms.add(oWLDisjointObjectPropertiesAxiom);
        }
        for (OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom : this.ontology.getAxioms(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            if (oWLDisjointDataPropertiesAxiom.getProperties().size() <= 2) continue;
            generalAxioms.add(oWLDisjointDataPropertiesAxiom);
        }
        this.createGraph(generalAxioms);
        Set<RDFResourceNode> rootNodes = this.graph.getRootAnonymousNodes();
        if (!rootNodes.isEmpty()) {
            this.writeBanner("General axioms");
            this.beginObject();
            this.renderAnonRoots();
            this.endObject();
        }
        Set<SWRLRule> set = this.ontology.getRules();
        this.createGraph(set);
        if (!set.isEmpty()) {
            this.writeBanner("Rules");
            SWRLVariableExtractor variableExtractor = new SWRLVariableExtractor();
            for (SWRLRule sWRLRule : set) {
                this.beginObject();
                if (!sWRLRule.isAnonymous()) {
                    this.render(new RDFResourceNode(sWRLRule.getURI()));
                }
                sWRLRule.accept(variableExtractor);
                this.endObject();
            }
            for (SWRLAtomIVariable sWRLAtomIVariable : variableExtractor.getIVariables()) {
                this.render(new RDFResourceNode(sWRLAtomIVariable.getURI()));
            }
            for (SWRLAtomDVariable sWRLAtomDVariable : variableExtractor.getDVariables()) {
                this.render(new RDFResourceNode(sWRLAtomDVariable.getURI()));
            }
            this.renderAnonRoots();
        }
        this.endDocument();
    }

    private OWLOntologyFormat getOntologyFormat() {
        return this.format;
    }

    protected abstract void endDocument();

    protected abstract void writeIndividualComments(OWLIndividual var1);

    protected abstract void writeClassComment(OWLClass var1);

    protected abstract void writeDataPropertyComment(OWLDataProperty var1);

    protected abstract void writeObjectPropertyComment(OWLObjectProperty var1);

    protected void beginObject() {
    }

    protected void endObject() {
    }

    private Set<OWLAnnotation> getAnnotationsForURIViaHack(Map<URI, Set<OWLAnnotation>> annoURIAnnotations, URI uri) {
        Set<OWLAnnotation> annos = annoURIAnnotations.get(uri);
        if (annos != null) {
            return annos;
        }
        return Collections.emptySet();
    }

    private boolean createGraph(OWLEntity entity) {
        final HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(entity.getAnnotationAxioms(this.ontology));
        if (this.renderDeclarationAxioms) {
            axioms.addAll(this.ontology.getDeclarationAxioms());
        }
        entity.accept(new OWLEntityVisitor(){

            public void visit(OWLClass cls) {
                for (OWLClassAxiom ax : RDFRendererBase.this.ontology.getAxioms(cls)) {
                    OWLDisjointClassesAxiom disjAx;
                    if (ax instanceof OWLDisjointClassesAxiom && (disjAx = (OWLDisjointClassesAxiom)ax).getDescriptions().size() > 2) continue;
                    axioms.add(ax);
                }
                RDFRendererBase.this.createGraph(axioms);
            }

            public void visit(OWLDataType dataType) {
            }

            public void visit(OWLIndividual individual) {
                for (OWLIndividualAxiom ax : RDFRendererBase.this.ontology.getAxioms(individual)) {
                    if (ax instanceof OWLDifferentIndividualsAxiom) continue;
                    axioms.add(ax);
                }
                RDFRendererBase.this.createGraph(axioms);
            }

            public void visit(OWLDataProperty property) {
                for (OWLDataPropertyAxiom ax : RDFRendererBase.this.ontology.getAxioms(property)) {
                    if (ax instanceof OWLDisjointDataPropertiesAxiom && ((OWLDisjointDataPropertiesAxiom)ax).getProperties().size() > 2) continue;
                    axioms.add(ax);
                }
                RDFRendererBase.this.createGraph(axioms);
            }

            public void visit(OWLObjectProperty property) {
                for (OWLObjectPropertyAxiom ax : RDFRendererBase.this.ontology.getAxioms(property)) {
                    if (ax instanceof OWLDisjointObjectPropertiesAxiom && ((OWLDisjointObjectPropertiesAxiom)ax).getProperties().size() > 2) continue;
                    axioms.add(ax);
                }
                OWLObjectPropertyInverse inverse = RDFRendererBase.this.manager.getOWLDataFactory().getOWLObjectPropertyInverse(property);
                axioms.addAll(RDFRendererBase.this.ontology.getAxioms(inverse));
                for (OWLObjectPropertyChainSubPropertyAxiom ax : RDFRendererBase.this.ontology.getAxioms(AxiomType.PROPERTY_CHAIN_SUB_PROPERTY)) {
                    if (!ax.getSuperProperty().equals(property) && !ax.getSuperProperty().equals(inverse)) continue;
                    axioms.add(ax);
                }
                RDFRendererBase.this.createGraph(axioms);
            }
        });
        this.addTypeTriple(entity);
        return true;
    }

    private void createGraph(Set<? extends OWLAxiom> axioms) {
        RDFTranslator translator = new RDFTranslator(this.manager, this.ontology);
        for (OWLAxiom oWLAxiom : axioms) {
            oWLAxiom.accept(translator);
        }
        this.graph = translator.getGraph();
    }

    private void addTypeTriple(OWLEntity entity) {
        entity.accept(new OWLEntityVisitor(){

            public void visit(OWLClass cls) {
                RDFRendererBase.this.graph.addTriple(new RDFTriple(new RDFResourceNode(cls.getURI()), new RDFResourceNode(OWLRDFVocabulary.RDF_TYPE.getURI()), new RDFResourceNode(OWLRDFVocabulary.OWL_CLASS.getURI())));
            }

            public void visit(OWLDataType dataType) {
                RDFRendererBase.this.graph.addTriple(new RDFTriple(new RDFResourceNode(dataType.getURI()), new RDFResourceNode(OWLRDFVocabulary.RDF_TYPE.getURI()), new RDFResourceNode(OWLRDFVocabulary.RDFS_DATATYPE.getURI())));
            }

            public void visit(OWLIndividual individual) {
                if (!individual.isAnonymous()) {
                    RDFRendererBase.this.graph.addTriple(new RDFTriple(new RDFResourceNode(individual.getURI()), new RDFResourceNode(OWLRDFVocabulary.RDF_TYPE.getURI()), new RDFResourceNode(OWLRDFVocabulary.OWL_THING.getURI())));
                }
            }

            public void visit(OWLDataProperty property) {
                RDFRendererBase.this.graph.addTriple(new RDFTriple(new RDFResourceNode(property.getURI()), new RDFResourceNode(OWLRDFVocabulary.RDF_TYPE.getURI()), new RDFResourceNode(OWLRDFVocabulary.OWL_DATA_PROPERTY.getURI())));
                if (RDFRendererBase.this.annotationURIs.contains(property.getURI())) {
                    RDFRendererBase.this.graph.addTriple(new RDFTriple(new RDFResourceNode(property.getURI()), new RDFResourceNode(OWLRDFVocabulary.RDF_TYPE.getURI()), new RDFResourceNode(OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getURI())));
                }
            }

            public void visit(OWLObjectProperty property) {
                RDFRendererBase.this.graph.addTriple(new RDFTriple(new RDFResourceNode(property.getURI()), new RDFResourceNode(OWLRDFVocabulary.RDF_TYPE.getURI()), new RDFResourceNode(OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getURI())));
                if (RDFRendererBase.this.annotationURIs.contains(property.getURI())) {
                    RDFRendererBase.this.graph.addTriple(new RDFTriple(new RDFResourceNode(property.getURI()), new RDFResourceNode(OWLRDFVocabulary.RDF_TYPE.getURI()), new RDFResourceNode(OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getURI())));
                }
            }
        });
    }

    protected abstract void writeBanner(String var1);

    private static <N extends OWLEntity> Set<N> toSortedSet(Set<N> entities) {
        TreeSet<OWLEntity> results = new TreeSet<OWLEntity>(new Comparator<OWLEntity>(){

            @Override
            public int compare(OWLEntity o1, OWLEntity o2) {
                return o1.getURI().compareTo(o2.getURI());
            }
        });
        results.addAll(entities);
        return results;
    }

    public void renderAnonRoots() {
        for (RDFResourceNode node : this.graph.getRootAnonymousNodes()) {
            this.render(node);
        }
    }

    public abstract void render(RDFResourceNode var1);

    protected boolean isObjectList(RDFResourceNode node) {
        for (RDFTriple triple : this.graph.getTriplesForSubject(node)) {
            if (!triple.getProperty().getURI().equals(OWLRDFVocabulary.RDF_TYPE.getURI()) || triple.getObject().isAnonymous() || !triple.getObject().getURI().equals(OWLRDFVocabulary.RDF_LIST.getURI())) continue;
            ArrayList<RDFNode> items = new ArrayList<RDFNode>();
            this.toJavaList(node, items);
            for (RDFNode n : items) {
                if (!n.isLiteral()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void toJavaList(RDFNode node, List<RDFNode> list) {
        for (RDFTriple triple : this.graph.getTriplesForSubject(node)) {
            if (!triple.getProperty().getURI().equals(OWLRDFVocabulary.RDF_FIRST.getURI())) continue;
            list.add(triple.getObject());
            break;
        }
        for (RDFTriple triple : this.graph.getTriplesForSubject(node)) {
            if (!triple.getProperty().getURI().equals(OWLRDFVocabulary.RDF_REST.getURI())) continue;
            if (!triple.getObject().isAnonymous()) {
                if (!triple.getObject().getURI().equals(OWLRDFVocabulary.RDF_NIL.getURI())) continue;
                continue;
            }
            this.toJavaList(triple.getObject(), list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TripleComparator
    implements Comparator<RDFTriple> {
        private List<URI> orderedURIs = new ArrayList<URI>();

        public TripleComparator() {
            this.orderedURIs.add(OWLRDFVocabulary.RDF_TYPE.getURI());
            this.orderedURIs.add(OWLRDFVocabulary.RDFS_LABEL.getURI());
            this.orderedURIs.add(OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getURI());
            this.orderedURIs.add(OWLRDFVocabulary.RDFS_SUBCLASS_OF.getURI());
            this.orderedURIs.add(OWLRDFVocabulary.OWL_DISJOINT_WITH.getURI());
            this.orderedURIs.add(OWLRDFVocabulary.OWL_ON_PROPERTY.getURI());
            this.orderedURIs.add(OWLRDFVocabulary.OWL_DATA_RANGE.getURI());
            this.orderedURIs.add(OWLRDFVocabulary.OWL_ON_CLASS.getURI());
            this.orderedURIs.add(OWLRDFVocabulary.RDF_SUBJECT.getURI());
            this.orderedURIs.add(OWLRDFVocabulary.RDF_PREDICATE.getURI());
            this.orderedURIs.add(OWLRDFVocabulary.RDF_OBJECT.getURI());
        }

        private int getIndex(URI uri) {
            int index = this.orderedURIs.indexOf(uri);
            if (index == -1) {
                index = this.orderedURIs.size();
            }
            return index;
        }

        @Override
        public int compare(RDFTriple o1, RDFTriple o2) {
            int diff = this.getIndex(o1.getProperty().getURI()) - this.getIndex(o2.getProperty().getURI());
            if (diff == 0) {
                diff = !o1.getSubject().isAnonymous() ? (!o2.getSubject().isAnonymous() ? o1.getSubject().getURI().compareTo(o2.getSubject().getURI()) : -1) : (!o2.getSubject().isAnonymous() ? 1 : 0);
                if (diff == 0 && (diff = o2.getProperty().getURI().compareTo(o2.getProperty().getURI())) == 0) {
                    if (!o1.getObject().isLiteral()) {
                        diff = !o2.getObject().isLiteral() ? (!o1.getObject().isAnonymous() ? (!o2.getObject().isAnonymous() ? o1.getObject().getURI().compareTo(o2.getObject().getURI()) : -1) : (!o2.getObject().isAnonymous() ? 1 : -1)) : 1;
                    } else if (!o2.getObject().isLiteral()) {
                        diff = -1;
                    } else {
                        RDFLiteralNode lit1 = (RDFLiteralNode)o1.getObject();
                        RDFLiteralNode lit2 = (RDFLiteralNode)o2.getObject();
                        if (lit1.isTyped()) {
                            if (lit2.isTyped()) {
                                diff = lit1.getLiteral().compareTo(lit2.getLiteral());
                                if (diff == 0) {
                                    diff = lit1.getDatatype().compareTo(lit2.getDatatype());
                                }
                            } else {
                                diff = -1;
                            }
                        } else if (lit2.isTyped()) {
                            diff = 1;
                        } else {
                            if (lit1.getLang() != null) {
                                if (lit2.getLang() != null) {
                                    diff = lit1.getLang().compareTo(lit2.getLang());
                                }
                            } else {
                                diff = -1;
                            }
                            if (diff == 0) {
                                diff = lit1.getLiteral().compareTo(lit2.getLiteral());
                            }
                        }
                    }
                }
            }
            if (diff == 0) {
                diff = 1;
            }
            return diff;
        }
    }
}

