/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import org.coode.owl.rdfxml.parser.BuiltInTypeHandler;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.coode.owl.rdfxml.parser.OWLRDFXMLParserMalformedNodeException;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public abstract class AbstractTypeAxiomHandler
extends BuiltInTypeHandler {
    public AbstractTypeAxiomHandler(OWLRDFConsumer consumer, URI typeURI) {
        super(consumer, typeURI);
    }

    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        return false;
    }

    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        this.consumeTriple(subject, predicate, object);
        URI subjectTripleObject = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_SUBJECT.getURI(), true);
        if (subjectTripleObject == null) {
            subjectTripleObject = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.RDF_SUBJECT.getURI(), true);
        }
        if (subjectTripleObject == null) {
            throw new OWLRDFXMLParserMalformedNodeException("missing owl:subject triple.");
        }
        URI predicateTripleObject = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_PREDICATE.getURI(), true);
        if (predicateTripleObject == null) {
            predicateTripleObject = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.RDF_PREDICATE.getURI(), true);
        }
        if (predicateTripleObject == null) {
            throw new OWLRDFXMLParserMalformedNodeException("missing owl:predicate triple.");
        }
        URI objectTripleObject = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_OBJECT.getURI(), true);
        if (objectTripleObject == null) {
            objectTripleObject = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.RDF_OBJECT.getURI(), true);
        }
        OWLAxiom ax = null;
        if (objectTripleObject != null) {
            ax = this.handleAxiomTriples(subjectTripleObject, predicateTripleObject, objectTripleObject);
        } else {
            OWLConstant con = this.getConsumer().getLiteralObject(subject, OWLRDFVocabulary.RDF_OBJECT.getURI(), true);
            if (con == null) {
                throw new OWLRDFXMLParserMalformedNodeException("missing owl:object triple.");
            }
            ax = this.handleAxiomTriples(subjectTripleObject, predicateTripleObject, con);
        }
        this.addAxiom(ax);
        this.getConsumer().addReifiedAxiom(subject, ax);
    }

    protected abstract OWLAxiom handleAxiomTriples(URI var1, URI var2, URI var3) throws OWLException;

    protected abstract OWLAxiom handleAxiomTriples(URI var1, URI var2, OWLConstant var3) throws OWLException;
}

