/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owl.rdfxml.parser;

import java.net.URI;
import org.coode.owl.rdfxml.parser.OWLRDFConsumer;
import org.coode.owl.rdfxml.parser.OWLRDFParserException;
import org.coode.owl.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class TPPropertyDisjointWithHandler
extends TriplePredicateHandler {
    public TPPropertyDisjointWithHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getURI());
    }

    public boolean canHandleStreaming(URI subject, URI predicate, URI object) throws OWLException {
        OWLRDFConsumer consumer = this.getConsumer();
        return consumer.isObjectPropertyOnly(subject) && consumer.isObjectPropertyOnly(object) || consumer.isDataPropertyOnly(subject) && consumer.isDataPropertyOnly(object);
    }

    public void handleTriple(URI subject, URI predicate, URI object) throws OWLException {
        OWLRDFConsumer consumer = this.getConsumer();
        if (consumer.isObjectPropertyOnly(subject)) {
            if (consumer.isDataPropertyOnly(object)) {
                throw new OWLRDFParserException("owl:disjointPropertyWith triple with object property subject and data property object");
            }
            this.translateDisjointObjectProperties(subject, predicate, object);
        } else if (consumer.isDataPropertyOnly(subject)) {
            if (consumer.isObjectPropertyOnly(object)) {
                throw new OWLRDFParserException("owl:disjointPropertyWith triple with data property subject and object property object");
            }
            this.translateDisjointDataProperties(subject, predicate, object);
        } else if (consumer.isObjectPropertyOnly(object)) {
            this.translateDisjointObjectProperties(subject, predicate, object);
        } else if (consumer.isDataPropertyOnly(object)) {
            this.translateDisjointDataProperties(subject, predicate, object);
        } else {
            this.translateDisjointDataProperties(subject, predicate, object);
            this.translateDisjointObjectProperties(subject, predicate, object);
        }
    }

    private void translateDisjointDataProperties(URI subject, URI predicate, URI object) throws OWLException {
        this.addAxiom(this.getDataFactory().getOWLDisjointDataPropertiesAxiom(this.translateDataProperty(subject), this.translateDataProperty(object)));
        this.consumeTriple(subject, predicate, object);
    }

    private void translateDisjointObjectProperties(URI subject, URI predicate, URI object) throws OWLException {
        this.addAxiom(this.getDataFactory().getOWLDisjointObjectPropertiesAxiom(this.translateObjectProperty(subject), this.translateObjectProperty(object)));
        this.consumeTriple(subject, predicate, object);
    }
}

