/*
 * Decompiled with CFR 0.152.
 */
package org.coode.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.coode.string.EscapeUtils;
import org.coode.xml.XMLWriter;
import org.coode.xml.XMLWriterNamespaceManager;
import org.coode.xml.XMLWriterPreferences;

public class XMLWriterImpl
implements XMLWriter {
    private Stack<XMLElement> elementStack;
    private Writer writer;
    private String encoding;
    private String xmlBase;
    private XMLWriterNamespaceManager xmlWriterNamespaceManager;
    private Map<String, String> entities;
    private static final int TEXT_CONTENT_WRAP_LIMIT = 15;
    private boolean preambleWritten;
    private static final String PERCENT_ENTITY = "&#37;";

    public XMLWriterImpl(Writer writer, XMLWriterNamespaceManager xmlWriterNamespaceManager) {
        this(writer, xmlWriterNamespaceManager, "");
    }

    public XMLWriterImpl(Writer writer, XMLWriterNamespaceManager xmlWriterNamespaceManager, String xmlBase) {
        this.writer = writer;
        this.xmlWriterNamespaceManager = xmlWriterNamespaceManager;
        this.xmlBase = xmlBase;
        this.encoding = "";
        this.elementStack = new Stack();
        this.setupEntities();
    }

    private void setupEntities() {
        ArrayList<String> namespaces = new ArrayList<String>(this.xmlWriterNamespaceManager.getNamespaces());
        Collections.sort(namespaces, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.length() - o2.length();
            }
        });
        this.entities = new LinkedHashMap<String, String>();
        for (String curNamespace : namespaces) {
            String curPrefix = "";
            curPrefix = this.xmlWriterNamespaceManager.getDefaultNamespace().equals(curNamespace) ? this.xmlWriterNamespaceManager.getDefaultPrefix() : this.xmlWriterNamespaceManager.getPrefixForNamespace(curNamespace);
            if (curPrefix.length() <= 0) continue;
            this.entities.put(curNamespace, "&" + curPrefix + ";");
        }
    }

    private String swapForEntity(String value) {
        for (String curEntity : this.entities.keySet()) {
            String repVal;
            String entityVal = this.entities.get(curEntity);
            if (value.length() <= curEntity.length() || (repVal = value.replace(curEntity, entityVal)).length() >= value.length()) continue;
            return repVal;
        }
        return value;
    }

    public String getDefaultNamespace() {
        return this.xmlWriterNamespaceManager.getDefaultNamespace();
    }

    public String getXMLBase() {
        return this.xmlBase;
    }

    public XMLWriterNamespaceManager getNamespacePrefixes() {
        return this.xmlWriterNamespaceManager;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setWrapAttributes(boolean b) {
        if (this.elementStack.size() > 0) {
            XMLElement element = this.elementStack.peek();
            element.setWrapAttributes(b);
        }
    }

    public void writeStartElement(String name) throws IOException {
        XMLElement topElement;
        String qName = this.xmlWriterNamespaceManager.getQName(name);
        if (qName == null) {
            throw new RuntimeException("Could not generate legal element name (qname) for " + name);
        }
        XMLElement element = new XMLElement(qName, this.elementStack.size());
        if (this.elementStack.size() > 0 && (topElement = this.elementStack.peek()) != null) {
            topElement.writeElementStart(false);
        }
        this.elementStack.push(element);
    }

    public void writeEndElement() throws IOException {
        if (this.elementStack.size() > 0) {
            XMLElement element = this.elementStack.pop();
            element.writeElementEnd();
        }
    }

    public void writeAttribute(String attr, String val) {
        XMLElement element = this.elementStack.peek();
        element.setAttribute(this.xmlWriterNamespaceManager.getQName(attr), val);
    }

    public void writeTextContent(String text) {
        XMLElement element = this.elementStack.peek();
        element.setText(text);
    }

    public void writeComment(String commentText) throws IOException {
        XMLElement topElement;
        XMLElement element = new XMLElement(null, this.elementStack.size());
        element.setText("<!-- " + commentText + " -->");
        if (!this.elementStack.isEmpty() && (topElement = this.elementStack.peek()) != null) {
            topElement.writeElementStart(false);
        }
        if (this.preambleWritten) {
            element.writeElementStart(true);
        } else {
            this.elementStack.push(element);
        }
    }

    private void writeEntities(String rootName) throws IOException {
        this.writer.write("\n\n<!DOCTYPE " + this.xmlWriterNamespaceManager.getQName(rootName) + " [\n");
        for (String entityVal : this.entities.keySet()) {
            String entity = this.entities.get(entityVal);
            entity = entity.substring(1, entity.length() - 1);
            this.writer.write("    <!ENTITY ");
            this.writer.write(entity);
            this.writer.write(" \"");
            entityVal = EscapeUtils.escapeXML(entityVal);
            entityVal = entityVal.replace("%", PERCENT_ENTITY);
            this.writer.write(entityVal);
            this.writer.write("\" >\n");
        }
        this.writer.write("]>\n\n\n");
    }

    public void startDocument(String rootElementName) throws IOException {
        String encodingString = "";
        if (this.encoding.length() > 0) {
            encodingString = " encoding=\"" + this.encoding + "\"";
        }
        this.writer.write("<?xml version=\"1.0\"" + encodingString + "?>\n");
        if (XMLWriterPreferences.getInstance().isUseNamespaceEntities()) {
            this.writeEntities(rootElementName);
        }
        this.preambleWritten = true;
        while (!this.elementStack.isEmpty()) {
            this.elementStack.pop().writeElementStart(true);
        }
        this.writeStartElement(rootElementName);
        this.setWrapAttributes(true);
        this.writeAttribute("xmlns", this.xmlWriterNamespaceManager.getDefaultNamespace());
        if (this.xmlBase.length() != 0) {
            this.writeAttribute("xml:base", this.xmlBase);
        }
        for (String curPrefix : this.xmlWriterNamespaceManager.getPrefixes()) {
            if (curPrefix.length() <= 0) continue;
            this.writeAttribute("xmlns:" + curPrefix, this.xmlWriterNamespaceManager.getNamespaceForPrefix(curPrefix));
        }
    }

    public void endDocument() throws IOException {
        while (!this.elementStack.isEmpty()) {
            this.writeEndElement();
        }
        this.writer.flush();
    }

    public class XMLElement {
        private String name;
        private Map<String, String> attributes;
        String textContent;
        private boolean startWritten;
        private int indentation;
        private boolean wrapAttributes;

        public XMLElement(String name) {
            this(name, 0);
            this.wrapAttributes = false;
        }

        public XMLElement(String name, int indentation) {
            this.name = name;
            this.attributes = new LinkedHashMap<String, String>();
            this.indentation = indentation;
            this.textContent = null;
            this.startWritten = false;
        }

        public void setWrapAttributes(boolean b) {
            this.wrapAttributes = true;
        }

        public void setAttribute(String attribute, String value) {
            this.attributes.put(attribute, value);
        }

        public void setText(String content) {
            this.textContent = content;
        }

        public void writeElementStart(boolean close) throws IOException {
            if (!this.startWritten) {
                this.startWritten = true;
                this.insertIndentation();
                if (this.name != null) {
                    XMLWriterImpl.this.writer.write(60);
                    XMLWriterImpl.this.writer.write(this.name);
                    this.writeAttributes();
                    if (this.textContent != null) {
                        boolean wrap;
                        boolean bl = wrap = this.textContent.length() > 15;
                        if (wrap) {
                            this.writeNewLine();
                            ++this.indentation;
                            this.insertIndentation();
                        }
                        XMLWriterImpl.this.writer.write(62);
                        this.writeTextContent();
                        if (wrap) {
                            --this.indentation;
                        }
                    }
                    if (close) {
                        if (this.textContent != null) {
                            this.writeElementEnd();
                        } else {
                            XMLWriterImpl.this.writer.write("/>");
                            this.writeNewLine();
                        }
                    } else if (this.textContent == null) {
                        XMLWriterImpl.this.writer.write(62);
                        this.writeNewLine();
                    }
                } else if (this.textContent != null) {
                    XMLWriterImpl.this.writer.write("\n\n\n");
                    StringTokenizer tokenizer = new StringTokenizer(this.textContent, "\n", true);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (!token.equals("\n")) {
                            this.insertIndentation();
                        }
                        XMLWriterImpl.this.writer.write(token);
                    }
                    XMLWriterImpl.this.writer.write("\n\n");
                }
            }
        }

        public void writeElementEnd() throws IOException {
            if (this.name != null) {
                if (!this.startWritten) {
                    this.writeElementStart(true);
                } else {
                    if (this.textContent == null) {
                        this.insertIndentation();
                    }
                    XMLWriterImpl.this.writer.write("</");
                    XMLWriterImpl.this.writer.write(this.name);
                    XMLWriterImpl.this.writer.write(">");
                    this.writeNewLine();
                }
            }
        }

        private void writeAttribute(String attr, String val) throws IOException {
            XMLWriterImpl.this.writer.write(attr);
            XMLWriterImpl.this.writer.write(61);
            XMLWriterImpl.this.writer.write(34);
            if (XMLWriterPreferences.getInstance().isUseNamespaceEntities()) {
                XMLWriterImpl.this.writer.write(XMLWriterImpl.this.swapForEntity(EscapeUtils.escapeXML(val)));
            } else {
                XMLWriterImpl.this.writer.write(EscapeUtils.escapeXML(val));
            }
            XMLWriterImpl.this.writer.write(34);
        }

        private void writeAttributes() throws IOException {
            Iterator<String> it = this.attributes.keySet().iterator();
            while (it.hasNext()) {
                String attr = it.next();
                String val = this.attributes.get(attr);
                XMLWriterImpl.this.writer.write(32);
                this.writeAttribute(attr, val);
                if (!it.hasNext() || !this.wrapAttributes) continue;
                XMLWriterImpl.this.writer.write("\n");
                ++this.indentation;
                this.insertIndentation();
                --this.indentation;
            }
        }

        private void writeTextContent() throws IOException {
            if (this.textContent != null) {
                XMLWriterImpl.this.writer.write(EscapeUtils.escapeXML(this.textContent));
            }
        }

        private void insertIndentation() throws IOException {
            if (XMLWriterPreferences.getInstance().isIndenting()) {
                for (int i = 0; i < this.indentation * XMLWriterPreferences.getInstance().getIndentSize(); ++i) {
                    XMLWriterImpl.this.writer.write(32);
                }
            }
        }

        private void writeNewLine() throws IOException {
            XMLWriterImpl.this.writer.write(10);
        }
    }
}

