/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.expression;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserException
extends Exception {
    private String currentToken;
    private int lineNumber;
    private int columnNumber;
    private boolean classNameExpected;
    private boolean objectPropertyNameExpected;
    private boolean dataPropertyNameExpected;
    private boolean individualNameExpected;
    private boolean datatypeNameExpected;
    private boolean integerExpected;
    private Set<String> expectedKeywords;
    private int startPos;

    public ParserException(String currentToken, int startPos, int lineNumber, int columnNumber, boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected, boolean datatypeNameExpected, Set<String> expectedKeywords) {
        this.currentToken = currentToken;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.classNameExpected = classNameExpected;
        this.objectPropertyNameExpected = objectPropertyNameExpected;
        this.dataPropertyNameExpected = dataPropertyNameExpected;
        this.individualNameExpected = individualNameExpected;
        this.datatypeNameExpected = datatypeNameExpected;
        this.expectedKeywords = expectedKeywords;
        this.startPos = startPos;
    }

    public ParserException(String currentToken, int startPos, int lineNumber, int columnNumber, boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected, boolean datatypeNameExpected, String ... keywords) {
        this.currentToken = currentToken;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.classNameExpected = classNameExpected;
        this.objectPropertyNameExpected = objectPropertyNameExpected;
        this.dataPropertyNameExpected = dataPropertyNameExpected;
        this.individualNameExpected = individualNameExpected;
        this.datatypeNameExpected = datatypeNameExpected;
        this.expectedKeywords = new HashSet<String>(Arrays.asList(keywords));
        this.startPos = startPos;
    }

    public ParserException(String currentToken, int lineNumber, int columnNumber, boolean integerExpected, int startPos) {
        this.currentToken = currentToken;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.integerExpected = integerExpected;
        this.startPos = startPos;
        this.expectedKeywords = new HashSet<String>();
    }

    public ParserException(String currentToken, int startPos, int lineNumber, int columnNumber, String ... keywords) {
        this(currentToken, startPos, lineNumber, columnNumber, false, false, false, false, false, keywords);
    }

    public int getStartPos() {
        return this.startPos;
    }

    public boolean isClassNameExpected() {
        return this.classNameExpected;
    }

    public boolean isObjectPropertyNameExpected() {
        return this.objectPropertyNameExpected;
    }

    public boolean isDataPropertyNameExpected() {
        return this.dataPropertyNameExpected;
    }

    public boolean isIndividualNameExpected() {
        return this.individualNameExpected;
    }

    public boolean isDatatypeNameExpected() {
        return this.datatypeNameExpected;
    }

    public Set<String> getExpectedKeywords() {
        return this.expectedKeywords;
    }

    public String getCurrentToken() {
        return this.currentToken;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Encountered ");
        sb.append(this.currentToken);
        sb.append(" at line ");
        sb.append(this.lineNumber);
        sb.append(" column ");
        sb.append(this.columnNumber);
        sb.append(". Expected one of:\n");
        if (this.classNameExpected) {
            sb.append("\tClass name\n");
        }
        if (this.objectPropertyNameExpected) {
            sb.append("\tObject property name\n");
        }
        if (this.dataPropertyNameExpected) {
            sb.append("\tData property name\n");
        }
        if (this.individualNameExpected) {
            sb.append("\tIndividual name\n");
        }
        if (this.datatypeNameExpected) {
            sb.append("\tDatatype name\n");
        }
        if (this.integerExpected) {
            sb.append("\tInteger\n");
        }
        for (String kw : this.expectedKeywords) {
            sb.append("\t");
            sb.append(kw);
            sb.append("\n");
        }
        return sb.toString();
    }
}

