/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.inference;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owl.inference.NullReasonerFactory;
import org.semanticweb.owl.inference.OWLReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.inference.OWLReasonerFactory;
import org.semanticweb.owl.inference.OWLReasonerManager;
import org.semanticweb.owl.inference.OWLReasonerManagerEvent;
import org.semanticweb.owl.inference.OWLReasonerManagerListener;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLReasonerManagerImpl
implements OWLReasonerManager {
    private List<OWLReasonerManagerListener> listeners;
    private List<OWLReasonerFactory> reasonerFactories;
    private OWLReasonerFactory currentReasonerFactory;
    private OWLReasoner reasoner;
    private OWLOntologyManager man;

    public OWLReasonerManagerImpl(OWLOntologyManager man) {
        this.man = man;
        this.listeners = new ArrayList<OWLReasonerManagerListener>();
        this.reasonerFactories = new ArrayList<OWLReasonerFactory>();
        this.currentReasonerFactory = new NullReasonerFactory();
    }

    @Override
    public void addListener(OWLReasonerManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(OWLReasonerManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public List<OWLReasonerFactory> getRegisteredReasonerFactories() {
        return new ArrayList<OWLReasonerFactory>(this.reasonerFactories);
    }

    @Override
    public void registerReasonerFactory(OWLReasonerFactory factory) {
        this.reasonerFactories.add(factory);
        this.fireReasonerFactoryAdded();
    }

    @Override
    public void unregisterReasonerFactory(OWLReasonerFactory factory) {
        this.reasonerFactories.remove(factory);
        this.fireReasonerFactoryRemoved();
    }

    @Override
    public void setReasonerFactory(OWLReasonerFactory factory) throws OWLReasonerException {
        if (!this.reasonerFactories.contains(factory)) {
            throw new OWLRuntimeException("Reasoner factory not registered: " + factory.getReasonerName());
        }
        this.currentReasonerFactory = factory;
        this.reasoner.dispose();
        this.fireReasonerFactoryChanged();
    }

    @Override
    public OWLReasonerFactory getReasonerFactory() {
        return this.currentReasonerFactory;
    }

    @Override
    public OWLReasoner getReasoner() {
        if (this.reasoner == null) {
            this.reasoner = this.currentReasonerFactory.createReasoner(this.man);
        }
        return this.reasoner;
    }

    @Override
    public OWLReasoner createReasoner() {
        return this.currentReasonerFactory.createReasoner(this.man);
    }

    protected void fireReasonerFactoryAdded() {
        for (OWLReasonerManagerListener listener : new ArrayList<OWLReasonerManagerListener>(this.listeners)) {
            listener.reasonerFactoryRegistered(new OWLReasonerManagerEvent(this));
        }
    }

    protected void fireReasonerFactoryRemoved() {
        for (OWLReasonerManagerListener listener : new ArrayList<OWLReasonerManagerListener>(this.listeners)) {
            listener.reasonerFactoryUnregistered(new OWLReasonerManagerEvent(this));
        }
    }

    protected void fireReasonerFactoryChanged() {
        for (OWLReasonerManagerListener listener : new ArrayList<OWLReasonerManagerListener>(this.listeners)) {
            listener.reasonerFactoryChanged(new OWLReasonerManagerEvent(this));
        }
    }
}

