/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.profiles;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.profiles.ConstructNotAllowed;
import org.semanticweb.owl.profiles.OWLProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLProfileReport {
    private OWLProfile profile;
    private URI ontologyURI;
    private Set<ConstructNotAllowed> disallowedConstructs;

    public OWLProfileReport(OWLProfile profile, URI ontologyURI, Set<ConstructNotAllowed> disallowedConstructs) {
        this.profile = profile;
        this.ontologyURI = ontologyURI;
        this.disallowedConstructs = new HashSet<ConstructNotAllowed>(disallowedConstructs);
    }

    public OWLProfile getProfile() {
        return this.profile;
    }

    public URI getOntologyURI() {
        return this.ontologyURI;
    }

    public boolean isInProfile() {
        return this.disallowedConstructs.isEmpty();
    }

    public Set<ConstructNotAllowed> getDisallowedConstructs() {
        return this.disallowedConstructs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.profile.getName());
        sb.append(" Profile Report: ");
        sb.append(this.ontologyURI);
        sb.append("\n");
        if (this.isInProfile()) {
            sb.append("[Ontology and imports closure in profile]\n");
        } else {
            sb.append("Ontology and imports closure NOT in profile. ");
            sb.append("The following are not allowed in ");
            sb.append(this.getProfile().getName());
            sb.append(":\n");
        }
        for (ConstructNotAllowed na : this.disallowedConstructs) {
            sb.append(na);
            sb.append("\n");
        }
        return sb.toString();
    }
}

