/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.util.OWLDescriptionVisitorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedConjunctChecker {
    private OWLClass conjunct;
    private boolean found;
    private boolean collect;
    private Set<OWLClass> conjuncts;
    private NamedConjunctCheckerVisitor visitor = new NamedConjunctCheckerVisitor();

    public NamedConjunctChecker() {
        this.conjuncts = new HashSet<OWLClass>();
    }

    public boolean isNamedConjunct(OWLClass conjunct, OWLDescription description) {
        this.reset();
        this.conjunct = conjunct;
        description.accept(this.visitor);
        return this.found;
    }

    public boolean hasNamedConjunct(OWLDescription description) {
        this.reset();
        this.conjunct = null;
        description.accept(this.visitor);
        return this.found;
    }

    private void reset() {
        this.found = false;
        this.collect = false;
    }

    public Set<OWLClass> getNamedConjuncts(OWLDescription description) {
        this.conjuncts.clear();
        this.reset();
        this.collect = true;
        description.accept(this.visitor);
        return this.conjuncts;
    }

    private class NamedConjunctCheckerVisitor
    extends OWLDescriptionVisitorAdapter {
        private NamedConjunctCheckerVisitor() {
        }

        public void visit(OWLClass desc) {
            if (NamedConjunctChecker.this.conjunct == null) {
                NamedConjunctChecker.this.found = true;
                if (NamedConjunctChecker.this.collect) {
                    NamedConjunctChecker.this.conjuncts.add(desc);
                }
            } else if (desc.equals(NamedConjunctChecker.this.conjunct)) {
                NamedConjunctChecker.this.found = true;
                if (NamedConjunctChecker.this.collect) {
                    NamedConjunctChecker.this.conjuncts.add(desc);
                }
            }
        }

        public void visit(OWLObjectIntersectionOf desc) {
            for (OWLDescription op : desc.getOperands()) {
                op.accept(this);
                if (!NamedConjunctChecker.this.found || NamedConjunctChecker.this.collect) continue;
                break;
            }
        }
    }
}

