/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.util.OWLObjectDuplicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLEntityRenamer {
    private OWLOntologyManager owlOntologyManager;
    private Set<OWLOntology> ontologies;

    public OWLEntityRenamer(OWLOntologyManager owlOntologyManager, Set<OWLOntology> ontologies) {
        this.owlOntologyManager = owlOntologyManager;
        this.ontologies = ontologies;
    }

    public List<OWLOntologyChange> changeURI(URI uri, URI newURI) {
        HashMap<URI, URI> uriMap = new HashMap<URI, URI>();
        uriMap.put(uri, newURI);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLOntology ont : this.ontologies) {
            OWLObjectDuplicator dup = new OWLObjectDuplicator(this.owlOntologyManager.getOWLDataFactory(), uriMap);
            OWLEntityRenamer.fillListWithTransformChanges(changes, this.getAxioms(ont, uri), ont, dup);
        }
        return changes;
    }

    public List<OWLOntologyChange> changeURI(OWLEntity entity, URI newURI) {
        HashMap<OWLEntity, URI> uriMap = new HashMap<OWLEntity, URI>();
        uriMap.put(entity, newURI);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLOntology ont : this.ontologies) {
            OWLObjectDuplicator duplicator = new OWLObjectDuplicator(uriMap, this.owlOntologyManager.getOWLDataFactory());
            OWLEntityRenamer.fillListWithTransformChanges(changes, OWLEntityRenamer.getAxioms(ont, entity), ont, duplicator);
        }
        return changes;
    }

    public List<OWLOntologyChange> changeURI(Map<OWLEntity, URI> entity2URIMap) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLOntology ont : this.ontologies) {
            for (OWLEntity ent : entity2URIMap.keySet()) {
                OWLObjectDuplicator duplicator = new OWLObjectDuplicator(entity2URIMap, this.owlOntologyManager.getOWLDataFactory());
                OWLEntityRenamer.fillListWithTransformChanges(changes, OWLEntityRenamer.getAxioms(ont, ent), ont, duplicator);
            }
        }
        return changes;
    }

    private static Set<OWLAxiom> getAxioms(OWLOntology ont, OWLEntity entity) {
        return ont.getReferencingAxioms(entity);
    }

    private Set<OWLAxiom> getAxioms(OWLOntology ont, URI uri) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(ont.getReferencingAxioms(this.owlOntologyManager.getOWLDataFactory().getOWLClass(uri)));
        axioms.addAll(ont.getReferencingAxioms(this.owlOntologyManager.getOWLDataFactory().getOWLObjectProperty(uri)));
        axioms.addAll(ont.getReferencingAxioms(this.owlOntologyManager.getOWLDataFactory().getOWLDataProperty(uri)));
        axioms.addAll(ont.getReferencingAxioms(this.owlOntologyManager.getOWLDataFactory().getOWLIndividual(uri)));
        axioms.addAll(ont.getReferencingAxioms(this.owlOntologyManager.getOWLDataFactory().getOWLDataType(uri)));
        return axioms;
    }

    private static void fillListWithTransformChanges(List<OWLOntologyChange> changes, Set<OWLAxiom> axioms, OWLOntology ont, OWLObjectDuplicator duplicator) {
        for (OWLAxiom ax : axioms) {
            changes.add(new RemoveAxiom(ont, ax));
            OWLAxiom dupAx = (OWLAxiom)duplicator.duplicateObject(ax);
            changes.add(new AddAxiom(ont, dupAx));
        }
    }
}

