/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.util.OWLEntityURIConverterStrategy;

public class OWLEntityTinyURIConversionStrategy
implements OWLEntityURIConverterStrategy {
    public static final String DEFAULT_BASE = "http://tinyname.org#";
    private String base;
    private Map<OWLEntity, URI> entityNameMap;
    private OWLEntityFragmentProvider fragmentProvider;

    public OWLEntityTinyURIConversionStrategy() {
        this(DEFAULT_BASE);
    }

    public OWLEntityTinyURIConversionStrategy(String base) {
        this.base = base;
        this.entityNameMap = new HashMap<OWLEntity, URI>();
        this.fragmentProvider = new OWLEntityFragmentProvider();
    }

    public URI getConvertedURI(OWLEntity entity) {
        URI uri = this.entityNameMap.get(entity);
        if (uri != null) {
            return uri;
        }
        if (entity instanceof OWLDataType) {
            return entity.getURI();
        }
        String name = this.fragmentProvider.getName(entity);
        uri = URI.create(this.base + name);
        this.entityNameMap.put(entity, uri);
        return uri;
    }

    private class OWLEntityFragmentProvider
    implements OWLEntityVisitor {
        private String name;
        private int classCount = 0;
        private int objectPropertyCount = 0;
        private int dataPropertyCount = 0;
        private int individualCount = 0;

        private OWLEntityFragmentProvider() {
        }

        public String getName(OWLEntity entity) {
            entity.accept(this);
            return this.name;
        }

        public void visit(OWLClass cls) {
            ++this.classCount;
            this.name = "C" + this.classCount;
        }

        public void visit(OWLDataType dataType) {
        }

        public void visit(OWLIndividual individual) {
            ++this.individualCount;
            this.name = "i" + this.individualCount;
        }

        public void visit(OWLDataProperty property) {
            ++this.dataPropertyCount;
            this.name = "dp" + this.dataPropertyCount;
        }

        public void visit(OWLObjectProperty property) {
            ++this.objectPropertyCount;
            this.name = "op" + this.objectPropertyCount;
        }
    }
}

