/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLCompositeOntologyChange;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.util.ImportsStructureEntitySorter;
import org.semanticweb.owl.util.ShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortForm2AnnotationGenerator
implements OWLCompositeOntologyChange {
    private URI annotationURI;
    private String languageTag;
    private OWLOntologyManager ontologyManager;
    private ShortFormProvider shortFormProvider;
    private OWLOntology ontology;

    public ShortForm2AnnotationGenerator(OWLOntologyManager ontologyManager, OWLOntology ontology, ShortFormProvider shortFormProvider, URI annotationURI, String languageTag) {
        this.ontologyManager = ontologyManager;
        this.shortFormProvider = shortFormProvider;
        this.annotationURI = annotationURI;
        this.languageTag = languageTag;
        this.ontology = ontology;
    }

    public ShortForm2AnnotationGenerator(OWLOntologyManager ontologyManager, OWLOntology ontology, ShortFormProvider shortFormProvider, URI annotationURI) {
        this(ontologyManager, ontology, shortFormProvider, annotationURI, null);
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        ImportsStructureEntitySorter sorter = new ImportsStructureEntitySorter(this.ontology, this.ontologyManager);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        Map ontology2EntityMap = sorter.getObjects();
        for (OWLOntology ont : ontology2EntityMap.keySet()) {
            for (OWLEntity ent : ontology2EntityMap.get(ont)) {
                String shortForm = this.shortFormProvider.getShortForm(ent);
                OWLUntypedConstant con = this.languageTag != null ? this.ontologyManager.getOWLDataFactory().getOWLUntypedConstant(shortForm, this.languageTag) : this.ontologyManager.getOWLDataFactory().getOWLUntypedConstant(shortForm);
                if (!this.ontology.containsEntityReference(ent)) continue;
                AddAxiom chg = new AddAxiom(ont, this.ontologyManager.getOWLDataFactory().getOWLEntityAnnotationAxiom(ent, this.annotationURI, con));
                changes.add(chg);
            }
        }
        return changes;
    }
}

