/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owl.io.OWLObjectRenderer;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.util.ShortFormProvider;
import org.semanticweb.owl.util.SimpleShortFormProvider;
import org.semanticweb.owl.util.SimpleURIShortFormProvider;
import org.semanticweb.owl.util.URIShortFormProvider;
import org.semanticweb.owl.vocab.SWRLBuiltInsVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRenderer
implements OWLObjectVisitor,
OWLObjectRenderer {
    private StringBuilder sb = new StringBuilder();
    private ShortFormProvider shortFormProvider = new SimpleShortFormProvider();
    private URIShortFormProvider uriShortFormProvider = new SimpleURIShortFormProvider();

    public void reset() {
        this.sb = new StringBuilder();
    }

    @Override
    public void setShortFormProvider(ShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }

    protected void append(String s) {
        this.sb.append(s);
    }

    @Override
    public String render(OWLObject object) {
        this.reset();
        object.accept(this);
        return this.sb.toString();
    }

    protected void render(Set<? extends OWLObject> objects) {
        Iterator<? extends OWLObject> it = this.toSortedSet(objects).iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.sb.append(" ");
        }
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.sb.append("Ontology(" + ontology.getURI() + " [Axioms: " + ontology.getAxiomCount() + "] [Logical axioms: " + ontology.getLogicalAxiomCount() + "])");
    }

    @Override
    public void visit(OWLOntologyAnnotationAxiom axiom) {
        this.sb.append("OntologyAnnotation(");
        ((OWLOntology)axiom.getSubject()).accept(this);
        this.sb.append(" ");
        axiom.getAnnotation().accept(this);
        this.sb.append(")");
    }

    private void insertSpace() {
        this.sb.append(" ");
    }

    private <N extends OWLObject> Set<N> toSortedSet(Set<N> set) {
        return new TreeSet<N>(set);
    }

    @Override
    public void visit(OWLSubClassAxiom axiom) {
        this.sb.append("SubClassOf(");
        axiom.getSubClass().accept(this);
        this.insertSpace();
        axiom.getSuperClass().accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.sb.append("NegativeObjectPropertyAssertion(");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getSubject().accept(this);
        this.insertSpace();
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        this.sb.append("AntiSymmetricObjectProperty(");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.sb.append("ReflexiveObjectProperty(");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.sb.append("DisjointClasses(");
        this.render(axiom.getDescriptions());
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.sb.append("DataPropertyDomain(");
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getDomain().accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLImportsDeclaration axiom) {
        this.sb.append("Imports(");
        this.sb.append(axiom.getSubject().getURI());
        this.sb.append(" -> ");
        this.sb.append(axiom.getImportedOntologyURI());
        this.sb.append(")");
    }

    @Override
    public void visit(OWLAxiomAnnotationAxiom axiom) {
        this.sb.append("AxiomAnnotation(");
        axiom.getAnnotation().accept(this);
        this.sb.append(", ");
        ((OWLAxiom)axiom.getSubject()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.sb.append("ObjectPropertyDomain(");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getDomain().accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.sb.append("EquivalentObjectProperties(");
        this.render(axiom.getProperties());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.sb.append("NegativeDataPropertyAssertion(");
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getSubject().accept(this);
        this.insertSpace();
        ((OWLConstant)axiom.getObject()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.sb.append("DifferentIndividuals(");
        this.render(axiom.getIndividuals());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.sb.append("DisjointDataProperties(");
        this.render(axiom.getProperties());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.sb.append("DisjointObjectProperties(");
        this.render(axiom.getProperties());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.sb.append("ObjectPropertyRange(");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        ((OWLDescription)axiom.getRange()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.sb.append("ObjectPropertyAssertion(");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getSubject().accept(this);
        this.insertSpace();
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.sb.append("FunctionalObjectProperty(");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLObjectSubPropertyAxiom axiom) {
        this.sb.append("SubObjectPropertyOf(");
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        this.insertSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.sb.append("DisjointUnion(");
        axiom.getOWLClass().accept(this);
        this.insertSpace();
        this.render(axiom.getDescriptions());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.sb.append("Declaration(");
        OWLEntity entity = axiom.getEntity();
        if (entity.isOWLClass()) {
            this.sb.append("OWLClass(");
        } else if (entity.isOWLObjectProperty()) {
            this.sb.append("ObjectProperty(");
        } else if (entity.isOWLDataProperty()) {
            this.sb.append("DataProperty(");
        } else if (entity.isOWLIndividual()) {
            this.sb.append("Individual(");
        } else if (entity.isOWLDataType()) {
            this.sb.append("Datatype(");
        }
        axiom.getEntity().accept(this);
        this.sb.append("))");
    }

    @Override
    public void visit(OWLEntityAnnotationAxiom axiom) {
        this.sb.append("EntityAnnotationAxiom(");
        ((OWLEntity)axiom.getSubject()).accept(this);
        this.insertSpace();
        axiom.getAnnotation().accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.sb.append("SymmetricObjectProperty(");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.sb.append("DataPropertyRange(");
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        ((OWLDataRange)axiom.getRange()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.sb.append("FunctionalDataProperty(");
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.sb.append("EquivalentDataProperties(");
        this.render(axiom.getProperties());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.sb.append("ClassAssertion(");
        axiom.getDescription().accept(this);
        this.insertSpace();
        axiom.getIndividual().accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.sb.append("EquivalentClasses(");
        this.render(axiom.getDescriptions());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.sb.append("DataPropertyAssertion(");
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getSubject().accept(this);
        this.insertSpace();
        ((OWLConstant)axiom.getObject()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.sb.append("TransitiveObjectProperty(");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.sb.append("IrreflexiveObjectProperty(");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDataSubPropertyAxiom axiom) {
        this.sb.append("SubDataProperty(");
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        this.insertSpace();
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.sb.append("InverseFunctionalObjectProperty(");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLSameIndividualsAxiom axiom) {
        this.sb.append("SameIndividual(");
        this.render(axiom.getIndividuals());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        this.sb.append("ObjectPropertyChainSubProperty(");
        this.sb.append("(");
        for (OWLObjectPropertyExpression prop : axiom.getPropertyChain()) {
            this.insertSpace();
            prop.accept(this);
        }
        this.sb.append(" )");
        this.insertSpace();
        axiom.getSuperProperty().accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLClass desc) {
        this.sb.append(this.shortFormProvider.getShortForm(desc));
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        this.sb.append("ObjectIntersectionOf(");
        this.render(desc.getOperands());
        this.sb.append(")");
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        this.sb.append("ObjectUnionOf(");
        this.render(desc.getOperands());
        this.sb.append(")");
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        this.sb.append("ObjectComplementOf(");
        desc.getOperand().accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLObjectSomeRestriction desc) {
        this.sb.append("ObjectSomeValuesFrom(");
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.insertSpace();
        ((OWLDescription)desc.getFiller()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLObjectAllRestriction desc) {
        this.sb.append("ObjectAllValuesFrom(");
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.insertSpace();
        ((OWLDescription)desc.getFiller()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLObjectValueRestriction desc) {
        this.sb.append("ObjectHasValue(");
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.insertSpace();
        ((OWLIndividual)desc.getValue()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLObjectMinCardinalityRestriction desc) {
        this.sb.append("ObjectMinCardinality(");
        this.sb.append(desc.getCardinality());
        this.insertSpace();
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.insertSpace();
        ((OWLDescription)desc.getFiller()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLObjectExactCardinalityRestriction desc) {
        this.sb.append("ObjectExactCardinality(");
        this.sb.append(desc.getCardinality());
        this.insertSpace();
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.insertSpace();
        ((OWLDescription)desc.getFiller()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLObjectMaxCardinalityRestriction desc) {
        this.sb.append("ObjectMaxCardinality(");
        this.sb.append(desc.getCardinality());
        this.insertSpace();
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.insertSpace();
        ((OWLDescription)desc.getFiller()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLObjectSelfRestriction desc) {
        this.sb.append("ObjectExistsSelf(");
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        this.sb.append("ObjectOneOf(");
        this.render(desc.getIndividuals());
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDataSomeRestriction desc) {
        this.sb.append("DataSomeValuesFrom(");
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        this.insertSpace();
        ((OWLDataRange)desc.getFiller()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDataAllRestriction desc) {
        this.sb.append("DataAllValuesFrom(");
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        this.insertSpace();
        ((OWLDataRange)desc.getFiller()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDataValueRestriction desc) {
        this.sb.append("DataValue(");
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        this.insertSpace();
        ((OWLConstant)desc.getValue()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDataMinCardinalityRestriction desc) {
        this.sb.append("DataMinCardinality(");
        this.sb.append(desc.getCardinality());
        this.insertSpace();
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        this.insertSpace();
        ((OWLDataRange)desc.getFiller()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDataExactCardinalityRestriction desc) {
        this.sb.append("DataExactCardinality(");
        this.sb.append(desc.getCardinality());
        this.insertSpace();
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        this.insertSpace();
        ((OWLDataRange)desc.getFiller()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDataMaxCardinalityRestriction desc) {
        this.sb.append("DataMaxCardinality(");
        this.sb.append(desc.getCardinality());
        this.insertSpace();
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
        this.insertSpace();
        ((OWLDataRange)desc.getFiller()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDataType node) {
        this.sb.append(node.getURI().getFragment());
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.sb.append("DataComplementOf(");
        node.getDataRange().accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.sb.append("DataOneOf(");
        this.render(node.getValues());
        this.sb.append(" )");
    }

    @Override
    public void visit(OWLDataRangeRestriction node) {
        this.sb.append("DataRangeRestriction(");
        node.getDataRange().accept(this);
        for (OWLDataRangeFacetRestriction restriction : node.getFacetRestrictions()) {
            this.insertSpace();
            restriction.accept(this);
        }
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDataRangeFacetRestriction node) {
        this.sb.append("facetRestriction(");
        this.sb.append((Object)node.getFacet());
        this.insertSpace();
        node.getFacetValue().accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLTypedConstant node) {
        this.sb.append("\"");
        this.sb.append(node.getLiteral());
        this.sb.append("\"^^");
        node.getDataType().accept(this);
    }

    @Override
    public void visit(OWLUntypedConstant node) {
        this.sb.append("\"");
        this.sb.append(node.getLiteral());
        this.sb.append("\"");
        if (node.hasLang()) {
            this.sb.append("@");
            this.sb.append(node.getLang());
        }
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.sb.append(this.shortFormProvider.getShortForm(property));
    }

    @Override
    public void visit(OWLObjectPropertyInverse property) {
        this.sb.append("InverseOf(");
        property.getInverse().accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.sb.append(this.shortFormProvider.getShortForm(property));
    }

    @Override
    public void visit(OWLIndividual individual) {
        this.sb.append(this.shortFormProvider.getShortForm(individual));
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.sb.append("InverseObjectProperties(");
        axiom.getFirstProperty().accept(this);
        this.sb.append(" ");
        axiom.getSecondProperty().accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLConstantAnnotation annotation) {
        if (annotation.isLabel()) {
            this.sb.append("Label(");
        } else if (annotation.isComment()) {
            this.sb.append("Comment(");
        } else {
            this.sb.append("Annotation(");
            this.sb.append(this.getShortForm(annotation.getAnnotationURI()));
        }
        this.sb.append(" ");
        ((OWLConstant)annotation.getAnnotationValue()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(OWLObjectAnnotation annotation) {
        this.sb.append("Annotation(");
        this.sb.append(this.getShortForm(annotation.getAnnotationURI()));
        this.sb.append(" ");
        ((OWLIndividual)annotation.getAnnotationValue()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(SWRLRule rule) {
        this.sb.append("Rule(");
        if (!rule.isAnonymous()) {
            this.sb.append(this.getShortForm(rule.getURI()));
            this.sb.append(" ");
        }
        this.sb.append(" antecedent(");
        this.render(rule.getBody());
        this.sb.append(")");
        this.sb.append(" consequent(");
        this.render(rule.getHead());
        this.sb.append(")");
        this.sb.append(" )");
    }

    @Override
    public void visit(SWRLClassAtom node) {
        ((OWLDescription)node.getPredicate()).accept(this);
        this.sb.append("(");
        ((SWRLAtomIObject)node.getArgument()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        ((OWLDataRange)node.getPredicate()).accept(this);
        this.sb.append("(");
        ((SWRLAtomDObject)node.getArgument()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(SWRLDifferentFromAtom node) {
        this.sb.append("differentFromAtom(");
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        this.sb.append(" ");
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(SWRLSameAsAtom node) {
        this.sb.append("sameAsAtom(");
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        this.sb.append(" ");
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        ((OWLObjectPropertyExpression)node.getPredicate()).accept(this);
        this.sb.append("(");
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        this.sb.append(" ");
        ((SWRLAtomIObject)node.getSecondArgument()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(SWRLDataValuedPropertyAtom node) {
        ((OWLDataPropertyExpression)node.getPredicate()).accept(this);
        this.sb.append("(");
        ((SWRLAtomIObject)node.getFirstArgument()).accept(this);
        this.sb.append(" ");
        ((SWRLAtomDObject)node.getSecondArgument()).accept(this);
        this.sb.append(")");
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        this.sb.append(this.getShortForm(((SWRLBuiltInsVocabulary)((Object)node.getPredicate())).getURI()));
        this.sb.append("(");
        for (SWRLAtomDObject arg : node.getArguments()) {
            arg.accept(this);
            this.sb.append(" ");
        }
        this.sb.append(")");
    }

    @Override
    public void visit(SWRLAtomDVariable node) {
        this.sb.append("?");
        this.sb.append(this.getShortForm(node.getURI()));
    }

    @Override
    public void visit(SWRLAtomIVariable node) {
        this.sb.append("?");
        this.sb.append(this.getShortForm(node.getURI()));
    }

    private String getShortForm(URI uri) {
        return this.uriShortFormProvider.getShortForm(uri);
    }

    @Override
    public void visit(SWRLAtomIndividualObject node) {
        node.getIndividual().accept(this);
    }

    @Override
    public void visit(SWRLAtomConstantObject node) {
        node.getConstant().accept(this);
    }

    public String toString() {
        return this.sb.toString();
    }
}

