/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitorEx;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitorEx;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.SWRLRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuralTransformation {
    private OWLDataFactory df;
    private int nameCounter = 0;
    private Set<OWLEntity> signature;

    public StructuralTransformation(OWLDataFactory dataFactory) {
        this.df = dataFactory;
        this.signature = new HashSet<OWLEntity>();
    }

    private OWLClass createNewName() {
        OWLClass cls = this.df.getOWLClass(URI.create("http://www.semanticweb.org/ontology#X" + this.nameCounter));
        ++this.nameCounter;
        return cls;
    }

    public Set<OWLAxiom> getTransformedAxioms(Set<OWLAxiom> axioms) {
        this.signature.clear();
        for (OWLAxiom ax : axioms) {
            this.signature.addAll(ax.getSignature());
        }
        AxiomRewriter rewriter = new AxiomRewriter();
        HashSet<OWLAxiom> transformedAxioms = new HashSet<OWLAxiom>();
        for (OWLAxiom ax : axioms) {
            for (OWLAxiom transAx : ax.accept(rewriter)) {
                if (transAx instanceof OWLSubClassAxiom) {
                    AxiomFlattener flattener = new AxiomFlattener(this.df, ((OWLSubClassAxiom)transAx).getSuperClass());
                    Set<OWLAxiom> flattenedAxioms = flattener.getAxioms();
                    if (!flattenedAxioms.isEmpty()) {
                        transformedAxioms.addAll(flattenedAxioms);
                        continue;
                    }
                    transformedAxioms.add(transAx);
                    continue;
                }
                transformedAxioms.add(transAx);
            }
        }
        return transformedAxioms;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AxiomRewriter
    implements OWLAxiomVisitorEx<Set<OWLAxiom>> {
        private AxiomRewriter() {
        }

        private Set<OWLAxiom> subClassOf(OWLDescription sub, OWLDescription sup) {
            return Collections.singleton(StructuralTransformation.this.df.getOWLSubClassAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLObjectUnionOf(StructuralTransformation.this.df.getOWLObjectComplementOf(sub), sup).getNNF()));
        }

        private Set<OWLAxiom> toSet(OWLAxiom ax) {
            return Collections.singleton(ax);
        }

        @Override
        public Set<OWLAxiom> visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLAxiomAnnotationAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLClassAssertionAxiom axiom) {
            return this.subClassOf(StructuralTransformation.this.df.getOWLObjectOneOf(axiom.getIndividual()), axiom.getDescription());
        }

        @Override
        public Set<OWLAxiom> visit(OWLDataPropertyAssertionAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLDataPropertyDomainAxiom axiom) {
            return this.subClassOf(StructuralTransformation.this.df.getOWLDataSomeRestriction((OWLDataPropertyExpression)axiom.getProperty(), StructuralTransformation.this.df.getTopDataType()), axiom.getDomain());
        }

        @Override
        public Set<OWLAxiom> visit(OWLDataPropertyRangeAxiom axiom) {
            return this.toSet(StructuralTransformation.this.df.getOWLSubClassAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLDataAllRestriction((OWLDataPropertyExpression)axiom.getProperty(), (OWLDataRange)axiom.getRange())));
        }

        @Override
        public Set<OWLAxiom> visit(OWLDataSubPropertyAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLDeclarationAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLDifferentIndividualsAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            ArrayList<OWLIndividual> individuals = new ArrayList<OWLIndividual>(axiom.getIndividuals());
            for (int i = 0; i < individuals.size(); ++i) {
                for (int j = i + 1; j < individuals.size(); ++j) {
                    axioms.addAll(this.subClassOf(StructuralTransformation.this.df.getOWLObjectOneOf((OWLIndividual)individuals.get(i)), StructuralTransformation.this.df.getOWLObjectOneOf((OWLIndividual)individuals.get(j))));
                }
            }
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLDisjointClassesAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            ArrayList<OWLDescription> descriptions = new ArrayList<OWLDescription>(axiom.getDescriptions());
            for (int i = 0; i < descriptions.size(); ++i) {
                for (int j = i + 1; j < descriptions.size(); ++j) {
                    axioms.addAll(this.subClassOf((OWLDescription)descriptions.get(i), (OWLDescription)descriptions.get(j)));
                }
            }
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLDisjointDataPropertiesAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            ArrayList props = new ArrayList(axiom.getProperties());
            for (int i = 0; i < props.size(); ++i) {
                for (int j = i + 1; j < props.size(); ++j) {
                    axioms.add(StructuralTransformation.this.df.getOWLDisjointDataPropertiesAxiom((OWLDataPropertyExpression)props.get(i), (OWLDataPropertyExpression)props.get(j)));
                }
            }
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLDisjointObjectPropertiesAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            ArrayList props = new ArrayList(axiom.getProperties());
            for (int i = 0; i < props.size(); ++i) {
                for (int j = i + 1; j < props.size(); ++j) {
                    axioms.add(StructuralTransformation.this.df.getOWLDisjointObjectPropertiesAxiom((OWLObjectPropertyExpression)props.get(i), (OWLObjectPropertyExpression)props.get(j)));
                }
            }
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLDisjointUnionAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            axioms.addAll((Collection)StructuralTransformation.this.df.getOWLEquivalentClassesAxiom(axiom.getOWLClass(), StructuralTransformation.this.df.getOWLObjectUnionOf(axiom.getDescriptions())).accept(this));
            axioms.addAll((Collection)StructuralTransformation.this.df.getOWLDisjointClassesAxiom(axiom.getDescriptions()).accept(this));
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLEntityAnnotationAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLEquivalentClassesAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            ArrayList<OWLDescription> descriptions = new ArrayList<OWLDescription>(axiom.getDescriptions());
            for (int i = 0; i < descriptions.size(); ++i) {
                for (int j = i + 1; j < descriptions.size(); ++j) {
                    axioms.addAll(this.subClassOf((OWLDescription)descriptions.get(i), (OWLDescription)descriptions.get(j)));
                    axioms.addAll(this.subClassOf((OWLDescription)descriptions.get(j), (OWLDescription)descriptions.get(i)));
                }
            }
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLEquivalentDataPropertiesAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            ArrayList props = new ArrayList(axiom.getProperties());
            for (int i = 0; i < props.size(); ++i) {
                for (int j = i + 1; j < props.size(); ++j) {
                    axioms.add(StructuralTransformation.this.df.getOWLDisjointDataPropertiesAxiom((OWLDataPropertyExpression)props.get(i), (OWLDataPropertyExpression)props.get(j)));
                    axioms.add(StructuralTransformation.this.df.getOWLDisjointDataPropertiesAxiom((OWLDataPropertyExpression)props.get(j), (OWLDataPropertyExpression)props.get(i)));
                }
            }
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            ArrayList props = new ArrayList(axiom.getProperties());
            for (int i = 0; i < props.size(); ++i) {
                for (int j = i + 1; j < props.size(); ++j) {
                    axioms.add(StructuralTransformation.this.df.getOWLDisjointObjectPropertiesAxiom((OWLObjectPropertyExpression)props.get(i), (OWLObjectPropertyExpression)props.get(j)));
                    axioms.add(StructuralTransformation.this.df.getOWLDisjointObjectPropertiesAxiom((OWLObjectPropertyExpression)props.get(j), (OWLObjectPropertyExpression)props.get(i)));
                }
            }
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLFunctionalDataPropertyAxiom axiom) {
            return this.toSet(StructuralTransformation.this.df.getOWLSubClassAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLDataMaxCardinalityRestriction((OWLDataPropertyExpression)axiom.getProperty(), 1)));
        }

        @Override
        public Set<OWLAxiom> visit(OWLFunctionalObjectPropertyAxiom axiom) {
            return this.toSet(StructuralTransformation.this.df.getOWLSubClassAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLObjectMaxCardinalityRestriction((OWLObjectPropertyExpression)axiom.getProperty(), 1)));
        }

        @Override
        public Set<OWLAxiom> visit(OWLImportsDeclaration axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            return this.toSet(StructuralTransformation.this.df.getOWLSubClassAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLObjectMaxCardinalityRestriction(((OWLObjectPropertyExpression)axiom.getProperty()).getInverseProperty(), 1)));
        }

        @Override
        public Set<OWLAxiom> visit(OWLInverseObjectPropertiesAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            axioms.add(StructuralTransformation.this.df.getOWLSubObjectPropertyAxiom(axiom.getFirstProperty(), axiom.getSecondProperty().getInverseProperty()));
            axioms.add(StructuralTransformation.this.df.getOWLSubObjectPropertyAxiom(axiom.getSecondProperty(), axiom.getFirstProperty().getInverseProperty()));
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            return this.subClassOf(StructuralTransformation.this.df.getOWLObjectOneOf(axiom.getSubject()), StructuralTransformation.this.df.getOWLDataAllRestriction((OWLDataPropertyExpression)axiom.getProperty(), StructuralTransformation.this.df.getOWLDataComplementOf(StructuralTransformation.this.df.getOWLDataOneOf((OWLConstant)axiom.getObject()))));
        }

        @Override
        public Set<OWLAxiom> visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            return this.subClassOf(StructuralTransformation.this.df.getOWLObjectOneOf(axiom.getSubject()), StructuralTransformation.this.df.getOWLObjectAllRestriction((OWLObjectPropertyExpression)axiom.getProperty(), StructuralTransformation.this.df.getOWLObjectComplementOf(StructuralTransformation.this.df.getOWLObjectOneOf((OWLIndividual)axiom.getObject()))));
        }

        @Override
        public Set<OWLAxiom> visit(OWLObjectPropertyAssertionAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLObjectPropertyDomainAxiom axiom) {
            return this.subClassOf(StructuralTransformation.this.df.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)axiom.getProperty(), StructuralTransformation.this.df.getOWLThing()), axiom.getDomain());
        }

        @Override
        public Set<OWLAxiom> visit(OWLObjectPropertyRangeAxiom axiom) {
            return this.toSet(StructuralTransformation.this.df.getOWLSubClassAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLObjectAllRestriction((OWLObjectPropertyExpression)axiom.getProperty(), (OWLDescription)axiom.getRange())));
        }

        @Override
        public Set<OWLAxiom> visit(OWLObjectSubPropertyAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLOntologyAnnotationAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLReflexiveObjectPropertyAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLSameIndividualsAxiom axiom) {
            return null;
        }

        @Override
        public Set<OWLAxiom> visit(OWLSubClassAxiom axiom) {
            return this.subClassOf(axiom.getSubClass(), axiom.getSuperClass());
        }

        @Override
        public Set<OWLAxiom> visit(OWLSymmetricObjectPropertyAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLTransitiveObjectPropertyAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(SWRLRule rule) {
            return this.toSet(rule);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AxiomFlattener
    implements OWLDescriptionVisitorEx<OWLDescription> {
        private OWLDataFactory df;
        private Set<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        private OWLDescription rhs;

        public AxiomFlattener(OWLDataFactory df, OWLDescription rhs) {
            this.df = df;
            this.rhs = rhs;
        }

        private OWLSubClassAxiom getSCA(OWLClass lhs, OWLDescription rhs) {
            return this.df.getOWLSubClassAxiom(lhs, rhs);
        }

        public Set<OWLAxiom> getAxioms() {
            this.axioms.clear();
            OWLClass lhs = this.df.getOWLThing();
            OWLDescription rhs2 = this.rhs.accept(this);
            this.axioms.add(this.getSCA(lhs, rhs2));
            return this.axioms;
        }

        @Override
        public OWLDescription visit(OWLClass desc) {
            return desc;
        }

        @Override
        public OWLDescription visit(OWLDataAllRestriction desc) {
            return desc;
        }

        @Override
        public OWLDescription visit(OWLDataExactCardinalityRestriction desc) {
            return desc;
        }

        @Override
        public OWLDescription visit(OWLDataMaxCardinalityRestriction desc) {
            return desc;
        }

        @Override
        public OWLDescription visit(OWLDataMinCardinalityRestriction desc) {
            return desc;
        }

        @Override
        public OWLDescription visit(OWLDataSomeRestriction desc) {
            return desc;
        }

        @Override
        public OWLDescription visit(OWLDataValueRestriction desc) {
            return desc;
        }

        @Override
        public OWLDescription visit(OWLObjectAllRestriction desc) {
            if (StructuralTransformation.this.signature.containsAll(((OWLDescription)desc.getFiller()).getSignature())) {
                OWLClass name = StructuralTransformation.this.createNewName();
                OWLDescription rhs = ((OWLDescription)desc.getFiller()).accept(this);
                this.axioms.add(this.getSCA(name, rhs));
                return this.df.getOWLObjectAllRestriction((OWLObjectPropertyExpression)desc.getProperty(), name);
            }
            return desc;
        }

        @Override
        public OWLDescription visit(OWLObjectComplementOf desc) {
            if (desc.getOperand().isAnonymous() && !(desc.getOperand() instanceof OWLObjectOneOf)) {
                throw new IllegalStateException("Negation of arbitrary descriptions not allowed: " + desc);
            }
            return desc;
        }

        @Override
        public OWLDescription visit(OWLObjectExactCardinalityRestriction desc) {
            if (StructuralTransformation.this.signature.containsAll(((OWLDescription)desc.getFiller()).getSignature())) {
                OWLClass name = StructuralTransformation.this.createNewName();
                OWLDescription rhs = ((OWLDescription)desc.getFiller()).accept(this);
                this.axioms.add(this.getSCA(name, rhs));
                return this.df.getOWLObjectExactCardinalityRestriction((OWLObjectPropertyExpression)desc.getProperty(), desc.getCardinality(), name);
            }
            return desc;
        }

        @Override
        public OWLDescription visit(OWLObjectIntersectionOf desc) {
            OWLClass name = StructuralTransformation.this.createNewName();
            for (OWLDescription op : desc.getOperands()) {
                OWLDescription flatOp = op.accept(this);
                this.axioms.add(this.getSCA(name, flatOp));
            }
            return name;
        }

        @Override
        public OWLDescription visit(OWLObjectMaxCardinalityRestriction desc) {
            if (StructuralTransformation.this.signature.containsAll(((OWLDescription)desc.getFiller()).getSignature())) {
                OWLClass name = StructuralTransformation.this.createNewName();
                OWLDescription rhs = ((OWLDescription)desc.getFiller()).accept(this);
                this.axioms.add(this.getSCA(name, rhs));
                return this.df.getOWLObjectMaxCardinalityRestriction((OWLObjectPropertyExpression)desc.getProperty(), desc.getCardinality(), name);
            }
            return desc;
        }

        @Override
        public OWLDescription visit(OWLObjectMinCardinalityRestriction desc) {
            if (StructuralTransformation.this.signature.containsAll(((OWLDescription)desc.getFiller()).getSignature())) {
                OWLClass name = StructuralTransformation.this.createNewName();
                OWLDescription rhs = ((OWLDescription)desc.getFiller()).accept(this);
                this.axioms.add(this.getSCA(name, rhs));
                return this.df.getOWLObjectMinCardinalityRestriction((OWLObjectPropertyExpression)desc.getProperty(), desc.getCardinality(), name);
            }
            return desc;
        }

        @Override
        public OWLDescription visit(OWLObjectOneOf desc) {
            if (desc.getIndividuals().size() == 1) {
                return desc;
            }
            OWLClass name = StructuralTransformation.this.createNewName();
            OWLDescription rhs = desc.asObjectUnionOf().accept(this);
            this.axioms.add(this.getSCA(name, rhs));
            return name;
        }

        @Override
        public OWLDescription visit(OWLObjectSelfRestriction desc) {
            return desc;
        }

        @Override
        public OWLDescription visit(OWLObjectSomeRestriction desc) {
            if (((OWLDescription)desc.getFiller()).isAnonymous()) {
                OWLClass name = StructuralTransformation.this.createNewName();
                OWLDescription rhs = ((OWLDescription)desc.getFiller()).accept(this);
                this.axioms.add(this.getSCA(name, rhs));
                return this.df.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)desc.getProperty(), name);
            }
            return desc;
        }

        @Override
        public OWLDescription visit(OWLObjectUnionOf desc) {
            HashSet<OWLDescription> descs = new HashSet<OWLDescription>();
            for (OWLDescription op : desc.getOperands()) {
                OWLDescription flatOp = op.accept(this);
                if (flatOp.isAnonymous() || StructuralTransformation.this.signature.contains(flatOp.asOWLClass())) {
                    OWLClass name = StructuralTransformation.this.createNewName();
                    descs.add(name);
                    this.axioms.add(this.df.getOWLSubClassAxiom(name, flatOp));
                    continue;
                }
                descs.add(flatOp);
            }
            return this.df.getOWLObjectUnionOf(descs);
        }

        @Override
        public OWLDescription visit(OWLObjectValueRestriction desc) {
            return desc;
        }
    }
}

