/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.vocab;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.vocab.Namespaces;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OWLDatatypeVocabulary {
    OWL_REAL_PLUS(Namespaces.OWL, "realPlus", Category.NUMBER, false),
    OWL_REAL(Namespaces.OWL, "real", Category.NUMBER, false),
    OWL_RATIONAL(Namespaces.OWL, "rational", Category.NUMBER, false),
    XSD_DOUBLE(XSDVocabulary.DOUBLE, Category.NUMBER, true),
    XSD_FLOAT(XSDVocabulary.FLOAT, Category.NUMBER, true),
    XSD_DECIMAL(XSDVocabulary.DECIMAL, Category.NUMBER, false),
    XSD_INTEGER(XSDVocabulary.INTEGER, Category.NUMBER, false),
    XSD_NON_NEGATIVE_INTEGER(XSDVocabulary.NON_NEGATIVE_INTEGER, Category.NUMBER, false),
    XSD_NON_POSITIVE_INTEGER(XSDVocabulary.NON_POSITIVE_INTEGER, Category.NUMBER, false),
    XSD_POSITIVE_INTEGER(XSDVocabulary.POSITIVE_INTEGER, Category.NUMBER, false),
    XSD_NEGATIVE_INTEGER(XSDVocabulary.NEGATIVE_INTEGER, Category.NUMBER, false),
    XSD_LONG(XSDVocabulary.LONG, Category.NUMBER, true),
    XSD_INT(XSDVocabulary.INT, Category.NUMBER, true),
    XSD_SHORT(XSDVocabulary.SHORT, Category.NUMBER, true),
    XSD_BYTE(XSDVocabulary.BYTE, Category.NUMBER, true),
    XSD_UNSIGNED_LONG(XSDVocabulary.UNSIGNED_LONG, Category.NUMBER, true),
    XSD_UNSIGNED_INT(XSDVocabulary.UNSIGNED_INT, Category.NUMBER, true),
    XSD_UNSIGNED_SHORT(XSDVocabulary.UNSIGNED_SHORT, Category.NUMBER, true),
    XSD_UNSIGNED_BYTE(XSDVocabulary.UNSIGNED_BYTE, Category.NUMBER, true),
    XSD_STRING(XSDVocabulary.STRING, Category.STRING_WITHOUT_LANGUAGE_TAG, false),
    XSD_NORMALIZED_STRING(XSDVocabulary.NORMALIZED_STRING, Category.STRING_WITHOUT_LANGUAGE_TAG, false),
    XSD_TOKEN(XSDVocabulary.TOKEN, Category.STRING_WITHOUT_LANGUAGE_TAG, false),
    XSD_LANGUAGE(XSDVocabulary.LANGUAGE, Category.STRING_WITHOUT_LANGUAGE_TAG, true),
    XSD_NAME(XSDVocabulary.NAME, Category.STRING_WITHOUT_LANGUAGE_TAG, false),
    XSD_NCNAME(XSDVocabulary.NCNAME, Category.STRING_WITHOUT_LANGUAGE_TAG, false),
    XSD_NMTOKEN(XSDVocabulary.NMTOKEN, Category.STRING_WITHOUT_LANGUAGE_TAG, false),
    XSD_BOOLEAN(XSDVocabulary.BOOLEAN, Category.BOOLEAN, true),
    XSD_HEX_BINARY(XSDVocabulary.HEX_BINARY, Category.BINARY, false),
    XSD_BASE_64_BINARY(XSDVocabulary.BASE_64_BINARY, Category.BINARY, false),
    XSD_ANY_URI(XSDVocabulary.ANY_URI, Category.URI, false),
    OWL_DATE_TIME(Namespaces.OWL, "dateTime", Category.TIME, false),
    RDF_TEXT(Namespaces.RDF, "text", Category.STRING_WITH_LANGUAGE_TAG, false);

    private static final Set<URI> ALL_URIS;
    private String shortName;
    private URI uri;
    private Category category;
    private boolean finite;

    public static Set<URI> getDatatypeURIs() {
        return ALL_URIS;
    }

    public static boolean isBuiltIn(URI datatypeURI) {
        return ALL_URIS.contains(datatypeURI);
    }

    public static OWLDatatypeVocabulary getDatatype(URI datatype) {
        if (!OWLDatatypeVocabulary.isBuiltIn(datatype)) {
            throw new OWLRuntimeException(datatype + " is not a built in datatype!");
        }
        for (OWLDatatypeVocabulary v : OWLDatatypeVocabulary.values()) {
            if (!v.getURI().equals(datatype)) continue;
            return v;
        }
        throw new OWLRuntimeException(datatype + " is not a built in datatype!");
    }

    private OWLDatatypeVocabulary(Namespaces namespace, String shortName, Category category, boolean finite) {
        this.uri = URI.create((Object)((Object)namespace) + shortName);
        this.shortName = shortName;
        this.category = category;
        this.finite = finite;
    }

    private OWLDatatypeVocabulary(XSDVocabulary xsd, Category category, boolean finite) {
        this.uri = xsd.getURI();
        this.shortName = xsd.getShortName();
        this.category = category;
        this.finite = finite;
    }

    public String getShortName() {
        return this.shortName;
    }

    public URI getURI() {
        return this.uri;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean isFinite() {
        return this.finite;
    }

    public Collection<OWLRestrictedDataRangeFacetVocabulary> getFacets() {
        return this.category.getFacets();
    }

    static {
        HashSet<URI> uris = new HashSet<URI>();
        for (OWLDatatypeVocabulary v : OWLDatatypeVocabulary.values()) {
            uris.add(v.getURI());
        }
        ALL_URIS = Collections.unmodifiableSet(new TreeSet(uris));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Category {
        NUMBER("Number", OWLRestrictedDataRangeFacetVocabulary.MAX_INCLUSIVE, OWLRestrictedDataRangeFacetVocabulary.MAX_INCLUSIVE, OWLRestrictedDataRangeFacetVocabulary.MIN_EXCLUSIVE, OWLRestrictedDataRangeFacetVocabulary.MAX_EXCLUSIVE),
        STRING_WITH_LANGUAGE_TAG("String with a language tag", OWLRestrictedDataRangeFacetVocabulary.MIN_LENGTH, OWLRestrictedDataRangeFacetVocabulary.MAX_LENGTH, OWLRestrictedDataRangeFacetVocabulary.LENGTH, OWLRestrictedDataRangeFacetVocabulary.PATTERN, OWLRestrictedDataRangeFacetVocabulary.LANG_PATTERN),
        STRING_WITHOUT_LANGUAGE_TAG("String without a language tag", OWLRestrictedDataRangeFacetVocabulary.MIN_LENGTH, OWLRestrictedDataRangeFacetVocabulary.MAX_LENGTH, OWLRestrictedDataRangeFacetVocabulary.LENGTH, OWLRestrictedDataRangeFacetVocabulary.PATTERN),
        BOOLEAN("Boolean value", new OWLRestrictedDataRangeFacetVocabulary[0]),
        BINARY("Binary data", OWLRestrictedDataRangeFacetVocabulary.MIN_LENGTH, OWLRestrictedDataRangeFacetVocabulary.MAX_LENGTH, OWLRestrictedDataRangeFacetVocabulary.LENGTH),
        URI("URI", OWLRestrictedDataRangeFacetVocabulary.MIN_LENGTH, OWLRestrictedDataRangeFacetVocabulary.MAX_LENGTH, OWLRestrictedDataRangeFacetVocabulary.PATTERN),
        TIME("Time instant", OWLRestrictedDataRangeFacetVocabulary.MIN_INCLUSIVE, OWLRestrictedDataRangeFacetVocabulary.MAX_INCLUSIVE, OWLRestrictedDataRangeFacetVocabulary.MIN_EXCLUSIVE, OWLRestrictedDataRangeFacetVocabulary.MAX_EXCLUSIVE);

        private String name;
        private List<OWLRestrictedDataRangeFacetVocabulary> facets;

        private Category(String name, OWLRestrictedDataRangeFacetVocabulary ... facets) {
            this.name = name;
            ArrayList<OWLRestrictedDataRangeFacetVocabulary> f = new ArrayList<OWLRestrictedDataRangeFacetVocabulary>(facets.length);
            for (OWLRestrictedDataRangeFacetVocabulary facet : facets) {
                f.add(facet);
            }
            this.facets = Collections.unmodifiableList(new ArrayList(f));
        }

        public String getName() {
            return this.name;
        }

        public List<OWLRestrictedDataRangeFacetVocabulary> getFacets() {
            return this.facets;
        }
    }
}

