/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.semanticweb.owl.io.ToStringRenderer;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.util.AxiomSubjectProvider;
import org.semanticweb.owl.util.HashCode;
import org.semanticweb.owl.util.OWLEntityCollector;
import org.semanticweb.owl.util.OWLObjectTypeIndexProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLObjectImpl
implements OWLObject {
    private OWLDataFactory dataFactory;
    private int hashCode = 0;
    private static OWLObjectTypeIndexProvider typeIndexProvider = new OWLObjectTypeIndexProvider();
    private static AxiomSubjectProvider subjectProvider = new AxiomSubjectProvider();
    private Set<OWLEntity> signature;

    public OWLObjectImpl(OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    public OWLDataFactory getOWLDataFactory() {
        return this.dataFactory;
    }

    @Override
    public Set<OWLEntity> getSignature() {
        if (this.signature == null) {
            HashSet<OWLEntity> sig = new HashSet<OWLEntity>();
            OWLEntityCollector collector = new OWLEntityCollector();
            this.accept(collector);
            sig.addAll(collector.getObjects());
            this.signature = new HashSet<OWLEntity>(sig);
        }
        return Collections.unmodifiableSet(this.signature);
    }

    @Override
    public Set<OWLClass> getClassesInSignature() {
        HashSet<OWLClass> result = new HashSet<OWLClass>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLClass()) continue;
            result.add(ent.asOWLClass());
        }
        return result;
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        HashSet<OWLDataProperty> result = new HashSet<OWLDataProperty>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLDataProperty()) continue;
            result.add(ent.asOWLDataProperty());
        }
        return result;
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        HashSet<OWLObjectProperty> result = new HashSet<OWLObjectProperty>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLObjectProperty()) continue;
            result.add(ent.asOWLObjectProperty());
        }
        return result;
    }

    @Override
    public Set<OWLIndividual> getIndividualsInSignature() {
        HashSet<OWLIndividual> result = new HashSet<OWLIndividual>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLIndividual()) continue;
            result.add(ent.asOWLIndividual());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof OWLObject;
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = HashCode.hashCode(this);
        }
        return this.hashCode;
    }

    @Override
    public final int compareTo(OWLObject o) {
        int otherTypeIndex;
        OWLObject otherSubj;
        OWLObject thisSubj;
        int axDiff;
        if (o instanceof OWLAxiom && this instanceof OWLAxiom && (axDiff = (thisSubj = subjectProvider.getSubject((OWLAxiom)((Object)this))).compareTo(otherSubj = subjectProvider.getSubject((OWLAxiom)o))) != 0) {
            return axDiff;
        }
        int thisTypeIndex = typeIndexProvider.getTypeIndex(this);
        int diff = thisTypeIndex - (otherTypeIndex = typeIndexProvider.getTypeIndex(o));
        if (diff == 0) {
            return this.compareObjectOfSameType(o);
        }
        return diff;
    }

    protected abstract int compareObjectOfSameType(OWLObject var1);

    public String toString() {
        return ToStringRenderer.getInstance().getRendering(this);
    }

    protected static int compareSets(Set<? extends OWLObject> set1, Set<? extends OWLObject> set2) {
        TreeSet<? extends OWLObject> ss1 = set1 instanceof SortedSet ? (TreeSet<? extends OWLObject>)set1 : new TreeSet<OWLObject>(set1);
        TreeSet<? extends OWLObject> ss2 = set2 instanceof SortedSet ? (TreeSet<? extends OWLObject>)set2 : new TreeSet<OWLObject>(set2);
        Iterator thisIt = ss1.iterator();
        Iterator otherIt = ss2.iterator();
        for (int i = 0; i < ss1.size() && i < ss2.size(); ++i) {
            OWLObject o2;
            OWLObject o1 = (OWLObject)thisIt.next();
            int diff = o1.compareTo(o2 = (OWLObject)otherIt.next());
            if (diff == 0) continue;
            return diff;
        }
        return ss1.size() - ss2.size();
    }
}

