/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLAxiomVisitorEx;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLObjectVisitorEx;
import uk.ac.manchester.cs.owl.OWLPropertyAxiomImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectPropertyChainSubPropertyAxiomImpl
extends OWLPropertyAxiomImpl
implements OWLObjectPropertyChainSubPropertyAxiom {
    private List<OWLObjectPropertyExpression> propertyChain;
    private OWLObjectPropertyExpression superProperty;

    public OWLObjectPropertyChainSubPropertyAxiomImpl(OWLDataFactory dataFactory, List<? extends OWLObjectPropertyExpression> propertyChain, OWLObjectPropertyExpression superProperty) {
        super(dataFactory);
        this.propertyChain = new ArrayList<OWLObjectPropertyExpression>(propertyChain);
        this.superProperty = superProperty;
    }

    @Override
    public List<OWLObjectPropertyExpression> getPropertyChain() {
        return Collections.unmodifiableList(this.propertyChain);
    }

    @Override
    public OWLObjectPropertyExpression getSuperProperty() {
        return this.superProperty;
    }

    @Override
    public boolean isEncodingOfTransitiveProperty() {
        if (this.propertyChain.size() == 2) {
            return this.superProperty.equals(this.propertyChain.get(0)) && this.superProperty.equals(this.propertyChain.get(1));
        }
        return false;
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLObjectPropertyChainSubPropertyAxiom)) {
            return false;
        }
        OWLObjectPropertyChainSubPropertyAxiom other = (OWLObjectPropertyChainSubPropertyAxiom)obj;
        return ((Object)other.getPropertyChain()).equals(this.getPropertyChain()) && other.getSuperProperty().equals(this.superProperty);
    }

    @Override
    public AxiomType getAxiomType() {
        return AxiomType.PROPERTY_CHAIN_SUB_PROPERTY;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        int diff;
        OWLObjectPropertyChainSubPropertyAxiom other = (OWLObjectPropertyChainSubPropertyAxiom)object;
        for (int i = 0; i < this.propertyChain.size() && i < other.getPropertyChain().size(); ++i) {
            diff = this.propertyChain.get(i).compareTo(other.getPropertyChain().get(i));
            if (diff == 0) continue;
            return diff;
        }
        diff = this.propertyChain.size() - other.getPropertyChain().size();
        if (diff != 0) {
            return diff;
        }
        return this.superProperty.compareTo(other.getSuperProperty());
    }
}

