/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owl.io.OWLOntologyCreationIOException;
import org.semanticweb.owl.io.OWLOntologyInputSource;
import org.semanticweb.owl.io.OWLParser;
import org.semanticweb.owl.io.OWLParserFactory;
import org.semanticweb.owl.io.OWLParserFactoryRegistry;
import org.semanticweb.owl.io.UnparsableOntologyException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyFactory;
import org.semanticweb.owl.model.OWLOntologyFormat;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLRuntimeException;
import uk.ac.manchester.cs.owl.AbstractInMemOWLOntologyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsableOWLOntologyFactory
extends AbstractInMemOWLOntologyFactory {
    private static final Logger logger = Logger.getLogger(ParsableOWLOntologyFactory.class.getName());
    private Set<String> parsableSchemes = new HashSet<String>();

    public ParsableOWLOntologyFactory() {
        this.parsableSchemes.add("http");
        this.parsableSchemes.add("https");
        this.parsableSchemes.add("file");
        this.parsableSchemes.add("ftp");
    }

    @Override
    public void setOWLOntologyManager(OWLOntologyManager owlOntologyManager) {
        super.setOWLOntologyManager(owlOntologyManager);
    }

    public List<OWLParser> getParsers() {
        ArrayList<OWLParser> parsers = new ArrayList<OWLParser>();
        List<OWLParserFactory> factories = OWLParserFactoryRegistry.getInstance().getParserFactories();
        for (OWLParserFactory factory : factories) {
            OWLParser parser = factory.createParser(this.getOWLOntologyManager());
            parser.setOWLOntologyManager(this.getOWLOntologyManager());
            parsers.add(parser);
        }
        return new ArrayList<OWLParser>(parsers);
    }

    @Override
    public boolean canCreateFromPhysicalURI(URI physicalURI) {
        return false;
    }

    public OWLOntology createOWLOntology(URI ontologyURI, URI physicalURI) {
        throw new OWLRuntimeException(new UnsupportedOperationException("Cannot create new empty ontologes!"));
    }

    @Override
    public boolean canLoad(OWLOntologyInputSource inputSource) {
        if (inputSource.isReaderAvailable()) {
            return true;
        }
        if (inputSource.isInputStreamAvailable()) {
            return true;
        }
        if (this.parsableSchemes.contains(inputSource.getPhysicalURI().getScheme())) {
            return true;
        }
        try {
            InputStream is = inputSource.getPhysicalURI().toURL().openStream();
            is.close();
            return true;
        }
        catch (UnknownHostException e) {
            logger.info("Unknown host: " + e.getMessage());
        }
        catch (MalformedURLException e) {
            logger.info("Malformed URL: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            logger.info("File not found: " + e.getMessage());
        }
        catch (IOException e) {
            logger.info("IO Exception: " + e.getMessage());
        }
        return false;
    }

    @Override
    public OWLOntology loadOWLOntology(OWLOntologyInputSource inputSource, OWLOntologyFactory.OWLOntologyCreationHandler mediator) throws OWLOntologyCreationException {
        LinkedHashMap<OWLParser, Throwable> exceptions = new LinkedHashMap<OWLParser, Throwable>();
        OWLOntology existingOntology = this.getOWLOntologyManager().getOntology(inputSource.getPhysicalURI());
        OWLOntology ont = super.createOWLOntology(inputSource.getPhysicalURI(), inputSource.getPhysicalURI(), mediator);
        for (OWLParser parser : this.getParsers()) {
            try {
                if (existingOntology == null && !ont.isEmpty()) {
                    this.getOWLOntologyManager().removeOntology(ont.getURI());
                    ont = super.createOWLOntology(inputSource.getPhysicalURI(), inputSource.getPhysicalURI(), mediator);
                }
                OWLOntologyFormat format = parser.parse(inputSource, ont);
                mediator.setOntologyFormat(ont, format);
                return ont;
            }
            catch (UnparsableOntologyException e) {
                throw e;
            }
            catch (Throwable e) {
                Throwable t = e;
                while (t != null) {
                    if (t instanceof IOException) {
                        this.getOWLOntologyManager().removeOntology(ont.getURI());
                        throw new OWLOntologyCreationIOException((IOException)t);
                    }
                    Throwable tt = e.getCause();
                    if (tt == t) break;
                    t = tt;
                }
                exceptions.put(parser, e);
            }
        }
        if (existingOntology == null) {
            this.getOWLOntologyManager().removeOntology(ont.getURI());
        }
        throw new UnparsableOntologyException(inputSource.getPhysicalURI(), exceptions);
    }
}

