/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.modularity;

import java.net.URI;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.modularity.OntologySegment;
import uk.ac.manchester.cs.owl.modularity.ModuleType;
import uk.ac.manchester.cs.owl.modularity.SyntacticLocalityModuleExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntacticLocalityModule
implements OntologySegment {
    protected OWLOntology baseOntology;
    protected OWLOntologyManager baseOntologyManager;
    protected SyntacticLocalityModuleExtractor associatedExtractor;
    protected boolean[] axiomArray;
    protected Set<OWLAxiom> logicalAxioms;
    protected Set<OWLAxiom> nonLogicalAxioms;
    protected Set<OWLAxiom> axioms;
    protected ModuleType moduleType;
    protected Set<OWLEntity> seedSignature;
    protected Set<OWLEntity> moduleSignature;

    public SyntacticLocalityModule(SyntacticLocalityModuleExtractor extractor, Set<OWLAxiom> logicalAxioms, Set<OWLAxiom> nonLogicalAxioms, boolean[] modArray, Set<OWLEntity> seedSignature, Set<OWLEntity> moduleSignature) {
        this.associatedExtractor = extractor;
        this.baseOntology = extractor.getAssociatedOntology();
        this.baseOntologyManager = extractor.getAssociatedOntologyManager();
        this.logicalAxioms = new HashSet<OWLAxiom>(logicalAxioms);
        this.nonLogicalAxioms = new HashSet<OWLAxiom>(nonLogicalAxioms);
        this.axioms = new HashSet<OWLAxiom>(logicalAxioms);
        this.axioms.addAll(nonLogicalAxioms);
        this.axiomArray = modArray;
        this.moduleType = extractor.getModuleType();
        this.seedSignature = seedSignature;
        this.moduleSignature = moduleSignature;
    }

    @Override
    public Set<OWLAxiom> getAxioms() {
        return this.axioms;
    }

    @Override
    public Set<OWLAxiom> getLogicalAxioms() {
        return this.logicalAxioms;
    }

    @Override
    public Set<OWLAxiom> getNonLogicalAxioms() {
        return this.nonLogicalAxioms;
    }

    @Override
    public Set<OWLEntity> getSeedSignature() {
        return this.seedSignature;
    }

    @Override
    public Set<OWLEntity> getSignature() {
        return this.moduleSignature;
    }

    public Set<OWLEntity> getModuleSignature() {
        return this.getSignature();
    }

    @Override
    public OWLOntology asOWLOntology(URI uri) throws OWLOntologyCreationException, OWLOntologyChangeException {
        OWLOntology newOnt = this.baseOntologyManager.createOntology(uri);
        LinkedList<AddAxiom> addaxs = new LinkedList<AddAxiom>();
        for (OWLAxiom ax : this.axioms) {
            addaxs.add(new AddAxiom(newOnt, ax));
        }
        this.baseOntologyManager.applyChanges(addaxs);
        return newOnt;
    }
}

