/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.axiom;

import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.format.SimpleLintFormat;
import com.clarkparsia.pellint.lintpattern.axiom.AxiomLintPattern;
import com.clarkparsia.pellint.lintpattern.axiom.DisjunctionSizeCollector;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.Severity;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLNaryClassAxiom;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLSubClassAxiom;

public class LargeDisjunctionPattern
extends AxiomLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new SimpleLintFormat();
    private int m_MaxAllowed = 10;
    private DisjunctionSizeCollector m_Visitor = new DisjunctionSizeCollector();

    public String getName() {
        return this.getClass().getSimpleName() + " (MaxAllowed = " + this.m_MaxAllowed + ")";
    }

    public String getDescription() {
        return "Too many disjuncts in a disjunction - maximum recommended is " + this.m_MaxAllowed;
    }

    public boolean isFixable() {
        return false;
    }

    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    public void setMaxAllowed(int value) {
        this.m_MaxAllowed = value;
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        this.visitNaryClassAxiom((OWLNaryClassAxiom)axiom);
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        this.visitNaryClassAxiom((OWLNaryClassAxiom)axiom);
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.visitNaryClassAxiom((OWLNaryClassAxiom)axiom);
    }

    public void visit(OWLSubClassAxiom axiom) {
        this.visitNaryClassAxiom((OWLNaryClassAxiom)axiom);
    }

    private void visitNaryClassAxiom(OWLNaryClassAxiom axiom) {
        this.m_Visitor.reset();
        axiom.accept((OWLObjectVisitor)this.m_Visitor);
        int disjunctionSize = this.m_Visitor.getDisjunctionSize();
        if (disjunctionSize > this.m_MaxAllowed) {
            Lint lint = this.makeLint();
            lint.addParticipatingAxiom((OWLClassAxiom)axiom);
            lint.setSeverity(new Severity(disjunctionSize));
            this.setLint(lint);
        }
    }
}

