/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.ontology;

import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.pellint.format.CompactClassLintFormat;
import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.lintpattern.ontology.OntologyLintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFixer;
import com.clarkparsia.pellint.util.OWLUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquivalentAndSubclassAxiomPattern
implements OntologyLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new CompactClassLintFormat();

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getDescription() {
        return "A named concept appears in equivalent axiom(s) and on the left-hand side of a subclass axiom";
    }

    @Override
    public boolean isFixable() {
        return true;
    }

    @Override
    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    @Override
    public List<Lint> match(OWLOntology ontology) {
        ArrayList<Lint> allLints = new ArrayList<Lint>();
        for (OWLClass owlClass : ontology.getReferencedClasses()) {
            Set equivalents = ontology.getEquivalentClassesAxioms(owlClass);
            Set subclasses = ontology.getSubClassAxiomsForLHS(owlClass);
            HashSet<OWLEquivalentClassesAxiom> badEquivalents = new HashSet<OWLEquivalentClassesAxiom>();
            block1: for (OWLEquivalentClassesAxiom equivalent : equivalents) {
                for (OWLDescription desc : equivalent.getDescriptions()) {
                    if (!OWLUtil.isComplex(desc)) continue;
                    badEquivalents.add(equivalent);
                    continue block1;
                }
            }
            if (badEquivalents.isEmpty() || badEquivalents.size() == 1 && subclasses.isEmpty()) continue;
            Lint lint = new Lint(this, ontology);
            lint.addParticipatingClass(owlClass);
            lint.addAllParticipatingAxioms(badEquivalents);
            lint.addAllParticipatingAxioms(subclasses);
            Set<OWLClassAxiom> fixedAxioms = EquivalentAndSubclassAxiomPattern.fixEquivalentAxioms(owlClass, badEquivalents);
            LintFixer fixer = new LintFixer(badEquivalents, fixedAxioms);
            lint.setLintFixer(fixer);
            allLints.add(lint);
        }
        return allLints;
    }

    private static Set<OWLClassAxiom> fixEquivalentAxioms(OWLClass classToFix, Set<OWLEquivalentClassesAxiom> axioms) {
        HashSet<OWLClassAxiom> fixes = new HashSet<OWLClassAxiom>();
        for (OWLEquivalentClassesAxiom axiom : axioms) {
            HashSet descs = new HashSet(axiom.getDescriptions());
            descs.remove(classToFix);
            if (descs.size() == 1) {
                fixes.add((OWLClassAxiom)OWL.subClassOf((OWLDescription)classToFix, (OWLDescription)((OWLDescription)descs.iterator().next())));
                continue;
            }
            fixes.add((OWLClassAxiom)OWL.equivalentClasses(descs));
            fixes.add((OWLClassAxiom)OWL.subClassOf((OWLDescription)classToFix, (OWLDescription)OWL.and(descs)));
        }
        return fixes;
    }
}

