/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.model;

import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.lintpattern.LintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyLints {
    private OWLOntology m_Ontology;
    private OWLOntology m_RootOntology;
    private Map<LintPattern, List<Lint>> m_Lints;

    public OntologyLints(OWLOntology ontology) {
        this.m_Ontology = ontology;
        this.m_Lints = new TreeMap<LintPattern, List<Lint>>(new Comparator<LintPattern>(){

            @Override
            public int compare(LintPattern p0, LintPattern p1) {
                return p0.getName().compareTo(p1.getName());
            }
        });
    }

    public OWLOntology getOntology() {
        return this.m_Ontology;
    }

    public void setRootOntology(OWLOntology rootOntology) {
        this.m_RootOntology = rootOntology;
    }

    public OWLOntology getRootOntology() {
        return this.m_RootOntology;
    }

    public void addLint(LintPattern pattern, Lint newLint) {
        List<Lint> lints = this.m_Lints.get(pattern);
        if (lints == null) {
            lints = CollectionUtil.makeList();
            this.m_Lints.put(pattern, lints);
        }
        lints.add(newLint);
    }

    public void addLints(LintPattern pattern, List<Lint> newLints) {
        List<Lint> lints = this.m_Lints.get(pattern);
        if (lints == null) {
            lints = CollectionUtil.makeList();
            this.m_Lints.put(pattern, lints);
        }
        lints.addAll(newLints);
    }

    public void sort(Comparator<? super Lint> comparator) {
        for (List<Lint> lints : this.m_Lints.values()) {
            Collections.sort(lints, comparator);
        }
    }

    public boolean isEmpty() {
        return this.m_Lints.isEmpty();
    }

    public int size() {
        int total = 0;
        for (List<Lint> lints : this.m_Lints.values()) {
            total += lints.size();
        }
        return total;
    }

    public Set<Lint> applyFix(OWLOntologyManager manager) throws OWLOntologyChangeException {
        HashSet<Lint> unfixable = new HashSet<Lint>();
        for (Map.Entry<LintPattern, List<Lint>> entry : this.m_Lints.entrySet()) {
            if (entry.getKey().isFixable()) {
                for (Lint lint : entry.getValue()) {
                    if (lint.applyFix(manager)) continue;
                    unfixable.add(lint);
                }
                continue;
            }
            unfixable.addAll((Collection<Lint>)entry.getValue());
        }
        return unfixable;
    }

    public String toString() {
        String ONTOLOGY_NAME = this.m_RootOntology == null ? this.m_Ontology.getURI().toString() : this.m_RootOntology.getURI().toString() + " and its import closure";
        if (this.m_Lints.isEmpty()) {
            return "\nNo OWL lints found for ontology " + ONTOLOGY_NAME + ".";
        }
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("\n==================================================================\n");
        strBuilder.append("OWL Lints found for ontology ").append(ONTOLOGY_NAME).append(":");
        for (LintPattern pattern : this.m_Lints.keySet()) {
            strBuilder.append("\n[").append(pattern.getName()).append(": ").append(pattern.getDescription()).append("]\n");
            LintFormat lintFormat = pattern.getDefaultLintFormat();
            for (Lint lint : this.m_Lints.get(pattern)) {
                strBuilder.append(lintFormat.format(lint));
            }
            strBuilder.append('\n');
        }
        return strBuilder.toString();
    }
}

