/*
 * Decompiled with CFR 0.152.
 */
package org.buaa.cse.act.ontology;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.buaa.cse.act.ontology.DownloadData;
import org.buaa.cse.act.toolkit.ConfigFileProvider;

public class DownloadOntology {
    private String localpath;
    private HashMap<String, String> history = new HashMap();
    private Queue<String> todoList = new LinkedList<String>();
    public static HashMap<String, OntModel> modelList = new HashMap();
    public ArrayList<DownloadData> dataList = new ArrayList();

    public DownloadOntology() {
        ConfigFileProvider cfp = new ConfigFileProvider();
        this.localpath = cfp.getOntologyDownPath();
    }

    public String filenameMapping(String fileurl) {
        String filename = fileurl.replace(":", "@");
        filename = filename.replace("/", "$");
        String localfile = String.valueOf(this.localpath) + filename.replace("*", "$");
        return localfile;
    }

    public String downOntology(String fileurl) throws IOException {
        DownloadData data = new DownloadData();
        data.setUsable(true);
        byte[] buf = new byte[8096];
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        String file = "";
        int size = 0;
        URL url = null;
        URLConnection con = null;
        try {
            url = new URL(fileurl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw e;
        }
        try {
            file = this.filenameMapping(fileurl);
            con = url.openConnection();
            con.connect();
            InputStream inputStream = con.getInputStream();
            bis = new BufferedInputStream(inputStream);
            fos = new FileOutputStream(file);
            while ((size = bis.read(buf)) != -1) {
                fos.write(buf, 0, size);
            }
            fos.close();
            bis.close();
        }
        catch (FileNotFoundException e) {
            data.setUsable(false);
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        data.setLocalpath(file);
        data.setDownDate(new Date());
        data.setURL(fileurl);
        this.dataList.add(data);
        return file;
    }

    public int downloads(String fileurl) {
        this.todoList.add(fileurl);
        String temp = null;
        String url = null;
        String import_url2 = null;
        while (!this.todoList.isEmpty()) {
            temp = this.todoList.remove();
            if (temp.endsWith("#")) {
                temp = temp.replace("#", "");
            }
            try {
                url = this.downOntology(temp);
            }
            catch (MalformedURLException e) {
                System.out.println("fail to download  " + temp);
                return -1;
            }
            catch (FileNotFoundException e) {
                System.out.println("fail to download  " + temp);
                return -1;
            }
            catch (IOException e) {
                System.out.println("fail to download  " + temp);
                return -1;
            }
            this.history.put(temp, temp);
            try {
                OntModel ontModel = this.createOntModel(url);
                modelList.put(url, ontModel);
                Set imports = ontModel.listImportedOntologyURIs();
                for (String import_url2 : imports) {
                    if (this.history.containsKey(import_url2)) continue;
                    this.todoList.add(import_url2);
                }
            }
            catch (NullPointerException e) {
                System.out.println("fail to parse ");
                return -2;
            }
            catch (Exception e1) {
                System.out.println("fail to parse");
                return -2;
            }
        }
        return 0;
    }

    public OntModel createOntModel(String localfile) throws Exception {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        try {
            String t = "file:///" + localfile.replace("\\", "/");
            ontModel.read(t);
        }
        catch (NullPointerException e) {
            System.out.println("the ontology file: " + localfile + " doesn't exist");
            throw e;
        }
        catch (Exception e1) {
            System.out.println("fail to parse \uff1a" + localfile);
            throw e1;
        }
        return ontModel;
    }
}

