/*
 * Decompiled with CFR 0.152.
 */
package org.buaa.cse.act.ontology;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.impl.DatatypePropertyImpl;
import com.hp.hpl.jena.ontology.impl.IndividualImpl;
import com.hp.hpl.jena.ontology.impl.ObjectPropertyImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.act.xservices.rt.metaset.MetasetParser;
import org.act.xservices.rt.metaset.MetasetParserFactory;
import org.act.xservices.rt.metaset.exception.MetasetParsingException;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.Metaset;
import org.buaa.cse.act.ontology.ClassNode;
import org.buaa.cse.act.ontology.DownloadOntology;
import org.buaa.cse.act.ontology.OntologyData;
import org.buaa.cse.act.toolkit.FileOperator;

public class OntologyParser {
    public String file_name;
    public OntologyData ontData = new OntologyData();

    public OntologyParser(String file) throws Exception {
        this.setFile_name(file);
        this.scan();
    }

    private void setFile_name(String file_name) {
        this.file_name = file_name;
    }

    public boolean isExist(String concept_name) {
        return this.ontData.nodes.containsKey(concept_name);
    }

    public ClassNode setNode(OntClass ont) {
        OntClass sp;
        String str;
        ClassNode node = new ClassNode();
        node.name = str = ont.getURI();
        ExtendedIterator it = ont.listSuperClasses();
        while (it.hasNext()) {
            sp = (OntClass)it.next();
            if (sp.isAnon()) continue;
            try {
                node.parentList.put(sp.getURI(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        it = ont.listSubClasses();
        while (it.hasNext()) {
            sp = (OntClass)it.next();
            if (sp.isAnon()) continue;
            try {
                node.childrenList.put(sp.getURI(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        it = ont.listEquivalentClasses();
        while (it.hasNext()) {
            sp = (OntClass)it.next();
            if (sp.isAnon()) continue;
            try {
                node.equivalentList.put(sp.getURI(), sp.getURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return node;
    }

    private void scan() throws Exception {
        IndividualImpl sp;
        int h;
        String url;
        OntModel ontModel = DownloadOntology.modelList.get(this.file_name);
        Metaset xml = this.xmlmodel(this.file_name);
        if (xml == null) {
            return;
        }
        String base = this.getBase(xml);
        this.ontData.setBase(base);
        Model model = ontModel.getBaseModel();
        String xmlns = model.getNsPrefixURI("");
        if (xmlns == null) {
            xmlns = "";
        }
        if (xmlns.endsWith("#")) {
            xmlns = xmlns.substring(0, xmlns.indexOf("#"));
        }
        this.ontData.setXMLNS(xmlns);
        ExtendedIterator i = ontModel.listClasses();
        while (i.hasNext()) {
            OntClass c = (OntClass)i.next();
            if (c.isAnon()) continue;
            if (base != null) {
                if (!c.getURI().contains(base)) continue;
                ClassNode node = this.setNode(c);
                this.ontData.nodes.put(node.name, node);
                continue;
            }
            if (xmlns.equals("")) continue;
            url = c.getURI();
            if (url.contains("$")) {
                h = url.lastIndexOf("http");
                url = url.substring(h, url.length());
                url = url.replace("$", "/");
                url = url.replace("@", ":");
            }
            if (!url.contains(xmlns)) continue;
            ClassNode node = this.setNode(c);
            node.name = url;
            this.ontData.nodes.put(url, node);
        }
        i = ontModel.listIndividuals();
        while (i.hasNext()) {
            sp = (IndividualImpl)i.next();
            if (sp.isAnon()) continue;
            if (base != null) {
                if (!sp.getURI().contains(base)) continue;
                this.ontData.individuals.add(sp.getURI());
                continue;
            }
            if (xmlns.equals("")) continue;
            url = sp.getURI();
            if (url.contains("$")) {
                h = url.lastIndexOf("http");
                url = url.substring(h, url.length());
                url = url.replace("$", "/");
                url = url.replace("@", ":");
            }
            if (!url.contains(xmlns)) continue;
            this.ontData.individuals.add(url);
        }
        i = ontModel.listObjectProperties();
        while (i.hasNext()) {
            sp = (ObjectPropertyImpl)i.next();
            if (sp.isAnon()) continue;
            if (base != null) {
                if (!sp.getURI().contains(base)) continue;
                this.ontData.individuals.add(sp.getURI());
                continue;
            }
            if (xmlns.equals("")) continue;
            url = sp.getURI();
            if (url.contains("$")) {
                h = url.lastIndexOf("http");
                url = url.substring(h, url.length());
                url = url.replace("$", "/");
                url = url.replace("@", ":");
            }
            if (!url.contains(xmlns)) continue;
            this.ontData.individuals.add(url);
        }
        i = ontModel.listDatatypeProperties();
        while (i.hasNext()) {
            sp = (DatatypePropertyImpl)i.next();
            if (sp.isAnon()) continue;
            if (base != null) {
                if (!sp.getURI().contains(base)) continue;
                this.ontData.individuals.add(sp.getURI());
                continue;
            }
            if (xmlns.equals("")) continue;
            url = sp.getURI();
            if (url.contains("$")) {
                h = url.lastIndexOf("http");
                url = url.substring(h, url.length());
                url = url.replace("$", "/");
                url = url.replace("@", ":");
            }
            if (!url.contains(xmlns)) continue;
            this.ontData.individuals.add(url);
        }
        String version = this.getVersionInfo(xml);
        if (version != null && version.length() > 31) {
            version = version.substring(0, 31);
        }
        this.ontData.setVersionInfo(version);
        Set imports = ontModel.listImportedOntologyURIs();
        for (String im : imports) {
            this.ontData.addImport(im);
        }
        this.ontData.setUUID(UUID.randomUUID().toString());
    }

    private Metaset xmlmodel(String fpath) {
        FileOperator fop = new FileOperator();
        String fContent = fop.fileReader(fpath);
        MetasetParser parser = MetasetParserFactory.getSAXParser();
        Metaset xml = null;
        if (fContent == null) {
            return null;
        }
        try {
            xml = parser.parse(fpath);
        }
        catch (MetasetParsingException e) {
            System.out.println("*****************" + fpath);
            e.printStackTrace();
        }
        return xml;
    }

    public String getBase(Metaset xml) {
        String base = null;
        if (xml != null) {
            List AttributeList = xml.attributes();
            int index = 0;
            while (index < AttributeList.size()) {
                if (((Attribute)AttributeList.get(index)).getName().equals("base")) {
                    base = ((Attribute)AttributeList.get(index)).getValue();
                    return base;
                }
                ++index;
            }
        }
        return null;
    }

    public String getVersionInfo(Metaset xml) {
        if (xml != null) {
            try {
                if (xml.filter("rdf:RDF\\Ontology") != null) {
                    List mmList = ((Metaset)xml.filter("rdf:RDF\\Ontology").elements().get(0)).elements();
                    int index = 0;
                    while (index < mmList.size()) {
                        if (((Metaset)mmList.get(index)).getName().equals("versionInfo")) {
                            return ((Metaset)mmList.get(index)).getText();
                        }
                        ++index;
                    }
                }
            }
            catch (NullPointerException e) {
                System.out.println("fail to get the version info ");
                throw e;
            }
        }
        return null;
    }
}

