/*
 * Decompiled with CFR 0.152.
 */
package org.buaa.cse.act.ontology;

import java.util.ArrayList;
import java.util.HashMap;
import org.buaa.cse.act.ontology.DownloadData;
import org.buaa.cse.act.ontology.DownloadOntology;
import org.buaa.cse.act.ontology.OntologyData;
import org.buaa.cse.act.ontology.OntologyParser;
import org.buaa.cse.act.ontology.SaveOntology;
import org.buaa.cse.act.toolkit.DataBaseTask;

public class OntologyProcessor {
    public ArrayList<DownloadData> downList = new ArrayList();
    public HashMap<DownloadData, OntologyData> ontInfo = new HashMap();

    public int downloadOnt(String url) {
        DownloadOntology down = new DownloadOntology();
        int result = down.downloads(url);
        this.downList = down.dataList;
        return result;
    }

    public int parseOnts() {
        if (!this.downList.isEmpty()) {
            int i = 0;
            while (i < this.downList.size()) {
                DownloadData downData = this.downList.get(i);
                try {
                    OntologyData ontData = this.parseOnt(downData);
                    this.ontInfo.put(downData, ontData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("fail to parse");
                    return -2;
                }
                ++i;
            }
        }
        return 0;
    }

    public OntologyData parseOnt(DownloadData downData) throws Exception {
        OntologyParser parser = new OntologyParser(downData.getLocalpath());
        return parser.ontData;
    }

    public void saveOntologiesInfo(DataBaseTask db) {
        for (DownloadData downData : this.ontInfo.keySet()) {
            OntologyData ontData = this.ontInfo.get(downData);
            SaveOntology saveOntology = new SaveOntology(downData, ontData, db);
            if (ontData.getBase() == null && ontData.getXMLNS().length() <= 0) continue;
            saveOntology.saveOntologyInfo();
        }
    }
}

