/*
 * Decompiled with CFR 0.152.
 */
package org.buaa.cse.act.request.publish;

import com.mysql.jdbc.ResultSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import org.act.xservices.rt.metaset.MetasetParser;
import org.act.xservices.rt.metaset.MetasetParserFactory;
import org.act.xservices.rt.metaset.exception.MetasetParsingException;
import org.act.xservices.rt.xom.Metaset;
import org.buaa.cse.act.request.publish.Owls2Srt;
import org.buaa.cse.act.request.publish.RequestInfo;
import org.buaa.cse.act.request.publish.RequestOperation;
import org.buaa.cse.act.request.publish.Sawsdl2Srt;
import org.buaa.cse.act.request.publish.ServiceRequestTemplate;
import org.buaa.cse.act.toolkit.DataBaseTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestPublish {
    private ServiceRequestTemplate mySRT;
    private RequestInfo myRequestInfo = new RequestInfo();

    public RequestInfo requestPublish(String SRTString, DataBaseTask db) {
        Metaset SRT2 = null;
        MetasetParser builder = MetasetParserFactory.getMetasetParser();
        Owls2Srt owls2srt = new Owls2Srt();
        Sawsdl2Srt sa2srt = new Sawsdl2Srt();
        String SRTStr = SRTString;
        if (SRTString.contains("<owl:Ontology")) {
            try {
                SRTStr = owls2srt.converse(SRTString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (SRTString.contains("<wsdl:definitions")) {
            try {
                SRTStr = sa2srt.converse(SRTString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            SRT2 = builder.parse(this.getStream(SRTStr));
        }
        catch (MetasetParsingException e1) {
            e1.printStackTrace();
        }
        try {
            this.mySRT = this.SRT_Transform(SRT2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mySRT.operation == null) {
            return null;
        }
        ArrayList<int[]> requestInfo = this.GetRequestInfo(this.mySRT.operation, db);
        boolean flag = this.GenerateVector(requestInfo, db);
        this.mySRT.operation = null;
        this.mySRT = null;
        if (!flag) {
            return null;
        }
        return this.myRequestInfo;
    }

    public ServiceRequestTemplate SRT_Transform(Metaset SRT2) throws Exception {
        ServiceRequestTemplate SRTClass = new ServiceRequestTemplate(SRT2);
        return SRTClass;
    }

    public boolean GenerateVector(ArrayList<int[]> requestInfo, DataBaseTask db) {
        String vectors = null;
        try {
            if (this.mySRT.operation != null) {
                if (this.mySRT.operation.Grade.endsWith("Exact")) {
                    vectors = this.ExactVector(requestInfo, db);
                    this.myRequestInfo.setVectors(vectors);
                } else {
                    vectors = this.FuzzyVector(requestInfo, db);
                    this.myRequestInfo.setVectors(vectors);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public ArrayList<int[]> GetRequestInfo(RequestOperation oper, DataBaseTask db) {
        int concept_id = 0;
        int ontology_id = 0;
        String sql = "";
        ResultSet rs = null;
        ArrayList<int[]> requestInfo = new ArrayList<int[]>();
        String oper_modelReference = null;
        StringBuffer oper_text_feature = new StringBuffer();
        ArrayList<Object> inputList = new ArrayList();
        ArrayList<Object> outputList = new ArrayList();
        oper_modelReference = oper.OperationReference;
        inputList = oper.inputList;
        outputList = oper.outputList;
        this.myRequestInfo.setMaxServiceNumber(this.mySRT.MaxServiceNumber);
        this.myRequestInfo.setQoSGrade(oper.QoSGrade);
        this.myRequestInfo.setGrade(oper.Grade);
        int input_num = inputList.size();
        this.myRequestInfo.setInput_num(input_num);
        int output_num = outputList.size();
        this.myRequestInfo.setOutput_num(output_num);
        oper_text_feature.append(oper.OperationName);
        int i = 0;
        while (i < input_num) {
            oper_text_feature.append(" " + ((String[])inputList.get(i))[0]);
            ++i;
        }
        i = 0;
        while (i < output_num) {
            oper_text_feature.append(" " + ((String[])outputList.get(i))[0]);
            ++i;
        }
        this.myRequestInfo.setOper_text_feature(oper_text_feature.toString());
        if (oper_modelReference.indexOf("#") > 0 && oper_modelReference != null) {
            sql = "select concept_id from ontologyconcept where concept_url='" + oper_modelReference + "'";
            rs = (ResultSet)db.selectData(sql);
            try {
                if (rs.next()) {
                    concept_id = rs.getInt("concept_id");
                    concept_id = this.GetMinEquivalentClassID(concept_id, db);
                    this.myRequestInfo.setCategory(concept_id);
                    requestInfo.add(new int[]{6, concept_id});
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        i = 0;
        while (i < input_num) {
            if (((String[])inputList.get(i))[1] != "") {
                sql = "select Ontology_ID, concept_id from ontologyconcept where concept_url='" + ((String[])inputList.get(i))[1] + "'";
                rs = (ResultSet)db.selectData(sql);
                try {
                    if (rs.next()) {
                        ontology_id = rs.getInt("Ontology_ID");
                        if (!this.myRequestInfo.getInOnto().contains(ontology_id)) {
                            this.myRequestInfo.getInOnto().add(ontology_id);
                        }
                        concept_id = rs.getInt("concept_id");
                        concept_id = this.GetMinEquivalentClassID(concept_id, db);
                        requestInfo.add(new int[]{1, concept_id});
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        i = 0;
        while (i < output_num) {
            if (((String[])outputList.get(i))[1] != "") {
                sql = "select Ontology_ID, concept_id from ontologyconcept where concept_url='" + ((String[])outputList.get(i))[1] + "'";
                rs = (ResultSet)db.selectData(sql);
                try {
                    if (rs.next()) {
                        ontology_id = rs.getInt("Ontology_ID");
                        if (!this.myRequestInfo.getOutOnto().contains(ontology_id)) {
                            this.myRequestInfo.getOutOnto().add(ontology_id);
                        }
                        concept_id = rs.getInt("concept_id");
                        concept_id = this.GetMinEquivalentClassID(concept_id, db);
                        requestInfo.add(new int[]{2, concept_id});
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return requestInfo;
    }

    public String FuzzyVector(ArrayList<int[]> requestInfo, DataBaseTask db) throws SQLException {
        String parameters = "";
        String parameters_String = "";
        ArrayList<String> paraList = new ArrayList<String>();
        for (int[] infoArray : requestInfo) {
            int type = infoArray[0];
            int concept_id = infoArray[1];
            String Select_Onto_ID = "select Ontology_ID, Direct_SubClasses, Direct_SuperClasses from ontologyconcept where Concept_ID= " + concept_id;
            ResultSet Onto_ID = (ResultSet)db.selectData(Select_Onto_ID);
            int ontology_id = 0;
            Onto_ID.next();
            ontology_id = Onto_ID.getInt("Ontology_ID");
            String subclassList = null;
            String superclassList = null;
            String Direct_SubClasses = Onto_ID.getString("Direct_SubClasses");
            ArrayList<Integer> SubClasses = new ArrayList<Integer>();
            if (Direct_SubClasses.length() > 0 && !Direct_SubClasses.equals("")) {
                String[] concept_ID_List = Direct_SubClasses.split(",");
                int i = concept_ID_List.length;
                int j = 0;
                while (j < i) {
                    if (Integer.parseInt(concept_ID_List[j]) > 0) {
                        SubClasses.add(Integer.parseInt(concept_ID_List[j]));
                    }
                    ++j;
                }
                subclassList = Direct_SubClasses.indexOf(",") > 0 ? Direct_SubClasses.replace(",", ".") : Direct_SubClasses;
            }
            String Direct_SuperClasses = Onto_ID.getString("Direct_SuperClasses");
            ArrayList<Integer> SuperClasses = new ArrayList<Integer>();
            if (Direct_SuperClasses.length() > 0 && !Direct_SuperClasses.equals("")) {
                String[] concept_ID_List = Direct_SuperClasses.split(",");
                int i = concept_ID_List.length;
                int j = 0;
                while (j < i) {
                    if (Integer.parseInt(concept_ID_List[j]) > 0) {
                        SuperClasses.add(Integer.parseInt(concept_ID_List[j]));
                    }
                    ++j;
                }
                superclassList = Direct_SuperClasses.indexOf(",") > 0 ? Direct_SuperClasses.replace(",", ".") : Direct_SuperClasses;
            }
            String concept_id_list = "";
            if (subclassList != null && superclassList != null) {
                concept_id_list = String.valueOf(concept_id) + ",[" + subclassList + "],[" + superclassList + "];";
            } else if (subclassList == null && superclassList != null) {
                concept_id_list = String.valueOf(concept_id) + ",[],[" + superclassList + "];";
            } else if (subclassList != null && superclassList == null) {
                concept_id_list = String.valueOf(concept_id) + ",[" + subclassList + "];";
            } else if (subclassList == null && superclassList == null) {
                concept_id_list = String.valueOf(String.valueOf(concept_id)) + ";";
            }
            switch (type) {
                case 1: {
                    parameters = "1:" + ontology_id + ":" + concept_id_list;
                    break;
                }
                case 2: {
                    parameters = "0:" + ontology_id + ":" + concept_id_list;
                    break;
                }
                case 3: {
                    parameters = "3:" + ontology_id + ":" + concept_id_list;
                    break;
                }
                case 4: {
                    parameters = "4:" + ontology_id + ":" + concept_id_list;
                    break;
                }
                case 6: {
                    parameters = "5:" + ontology_id + ":" + concept_id_list;
                }
            }
            paraList.add(parameters);
        }
        int jj = paraList.size();
        int kk = 0;
        while (kk < jj) {
            String temp = (String)paraList.get(kk);
            parameters_String = String.valueOf(parameters_String) + temp.substring(0, temp.length() - 1) + "#";
            ++kk;
        }
        return parameters_String;
    }

    public int GetMinEquivalentClassID(int ConceptID, DataBaseTask db) {
        String Select_Equivalent = "select Equivalent from ontologyconcept where Concept_ID = " + ConceptID;
        ResultSet Equivalent_List = (ResultSet)db.selectData(Select_Equivalent);
        try {
            String EquivalentClasses;
            if (Equivalent_List.next() && (EquivalentClasses = Equivalent_List.getString("Equivalent")).length() > 0) {
                String[] concept_ID_List = EquivalentClasses.split(",");
                int i = concept_ID_List.length;
                int j = 0;
                while (j < i) {
                    if (Integer.parseInt(concept_ID_List[j]) < ConceptID) {
                        ConceptID = Integer.parseInt(concept_ID_List[j]);
                    }
                    ++j;
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return ConceptID;
    }

    public String ExactVector(ArrayList<int[]> requestInfo, DataBaseTask db) throws SQLException {
        String parameters = "";
        String parameters_String = "";
        ArrayList<String> paraList = new ArrayList<String>();
        for (int[] infoArray : requestInfo) {
            int type = infoArray[0];
            int concept_id = infoArray[1];
            String Select_Onto_ID = "select Ontology_ID from ontologyconcept where Concept_ID= " + concept_id;
            ResultSet Onto_ID = (ResultSet)db.selectData(Select_Onto_ID);
            Onto_ID.next();
            int ontology_id = Onto_ID.getInt("Ontology_ID");
            switch (type) {
                case 1: {
                    parameters = "1:" + ontology_id + ":" + concept_id + "," + 1 + ";";
                    break;
                }
                case 2: {
                    parameters = "0:" + ontology_id + ":" + concept_id + "," + 1 + ";";
                    break;
                }
                case 3: {
                    parameters = "3:" + ontology_id + ":" + concept_id + "," + 1 + ";";
                    break;
                }
                case 4: {
                    parameters = "4:" + ontology_id + ":" + concept_id + "," + 1 + ";";
                    break;
                }
                case 6: {
                    parameters = "5:" + ontology_id + ":" + concept_id + "," + 1 + ";";
                }
            }
            int i = parameters.indexOf(":" + concept_id + ",");
            String part_para = parameters.substring(0, i + 1);
            int j = paraList.size();
            int k = 0;
            while (k < j) {
                if (((String)paraList.get(k)).indexOf(part_para) == 0) {
                    String temp = (String)paraList.get(k);
                    if (temp.indexOf(String.valueOf(concept_id) + ",") >= 0) {
                        int n = temp.indexOf(String.valueOf(concept_id) + ",");
                        String head = temp.substring(0, n);
                        String tail = temp.substring(n);
                        int m = tail.indexOf(",");
                        int l = tail.indexOf(";");
                        int num = Integer.parseInt(tail.substring(m + 1, l)) + 1;
                        temp = String.valueOf(head) + concept_id + "," + num + tail.substring(l);
                    } else {
                        temp = String.valueOf(temp) + concept_id + "," + 1 + ";";
                    }
                    paraList.remove(k);
                    paraList.add(temp);
                    parameters = "NULL";
                    break;
                }
                ++k;
            }
            if (parameters == "NULL") continue;
            paraList.add(parameters);
        }
        int jj = paraList.size();
        int kk = 0;
        while (kk < jj) {
            String temp = (String)paraList.get(kk);
            parameters_String = String.valueOf(parameters_String) + temp.substring(0, temp.length() - 1) + "#";
            ++kk;
        }
        return parameters_String;
    }

    public InputStream getStream(String content) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes());
            return bais;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

