/*
 * Decompiled with CFR 0.152.
 */
package org.buaa.cse.act.service.discover;

import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VSMSimilarity {
    private static HashMap<String, Double> gene = new HashMap();

    public void calculate_Gene(ArrayList<String> servTextFeatures) {
        HashMap<String, Integer> wordServNum = new HashMap<String, Integer>();
        int total = servTextFeatures.size();
        int i = 0;
        while (i < total) {
            String[] words;
            ArrayList<String> wordsNonRepeat = new ArrayList<String>();
            String[] stringArray = words = servTextFeatures.get(i).split(" ");
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String word = stringArray[n];
                if (!wordsNonRepeat.contains(word)) {
                    wordsNonRepeat.add(word);
                }
                ++n;
            }
            for (String word : wordsNonRepeat) {
                if (!wordServNum.containsKey(word)) {
                    wordServNum.put(word, 1);
                    continue;
                }
                wordServNum.put(word, (Integer)wordServNum.get(word) + 1);
            }
            ++i;
        }
        for (String word : wordServNum.keySet()) {
            double idf = Math.log((double)(total / (Integer)wordServNum.get(word)) + 0.01);
            gene.put(word, idf);
        }
    }

    public HashMap<String, Double> calculate_weight(String servTextFeature) {
        String[] words;
        HashMap<String, Double> weight = new HashMap<String, Double>();
        HashMap<String, Integer> tf = new HashMap<String, Integer>();
        String[] stringArray = words = servTextFeature.split(" ");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String word = stringArray[n];
            if (!word.equals("")) {
                if (!tf.containsKey(word)) {
                    tf.put(word, 1);
                } else {
                    tf.put(word, (Integer)tf.get(word) + 1);
                }
            }
            ++n;
        }
        for (String word : tf.keySet()) {
            weight.put(word, (double)((Integer)tf.get(word)).intValue() * gene.get(word));
        }
        return weight;
    }

    public float CalculateSimilar(String servTextFeature1, String servTextFeature2) {
        HashMap<String, Double> stf1 = this.calculate_weight(servTextFeature1);
        HashMap<String, Double> stf2 = this.calculate_weight(servTextFeature2);
        float sim = 0.0f;
        if (stf1.size() < stf2.size()) {
            for (String word : stf1.keySet()) {
                if (!stf2.keySet().contains(word)) continue;
                sim = (float)((double)sim + stf1.get(word) * stf2.get(word));
            }
        } else {
            for (String word : stf2.keySet()) {
                if (!stf1.keySet().contains(word)) continue;
                sim = (float)((double)sim + stf1.get(word) * stf2.get(word));
            }
        }
        if (sim == 0.0f) {
            return 0.0f;
        }
        float m1 = this.CalculateModel(stf1);
        if (m1 == 0.0f) {
            return 0.0f;
        }
        float m2 = this.CalculateModel(stf2);
        if (m2 == 0.0f) {
            return 0.0f;
        }
        return sim / (m1 * m2);
    }

    public float CalculateModel(HashMap<String, Double> hm) {
        float model = 0.0f;
        for (String word : hm.keySet()) {
            Double t = hm.get(word);
            model = (float)((double)model + t * t);
        }
        return (float)Math.sqrt(model);
    }

    public static void main(String[] args) {
        VSMSimilarity vsm = new VSMSimilarity();
        ArrayList<String> stfs = new ArrayList<String>();
        String servTextFeature1 = "Provide Non medical flight information      Provide Non medical flight information     Desired Arrival airport   Provide Non medical flight information     Desired Departure airport   Get Non medical flight account     Customer Desired account name    Provide Non medical flight information     Desired Departure date time    Provide Non medical flight information     Flight Category  Provide Non medical flight information     List Of flights ";
        String servTextFeature2 = "Lock Door atomic    Door";
        stfs.add(servTextFeature1);
        stfs.add(servTextFeature2);
        vsm.calculate_Gene(stfs);
        System.out.println(vsm.CalculateSimilar(servTextFeature1, servTextFeature2));
    }
}

