/*
 * Decompiled with CFR 0.152.
 */
package org.buaa.cse.act.service.publish;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import org.act.xservices.rt.metaset.MetasetParser;
import org.act.xservices.rt.metaset.MetasetParserFactory;
import org.act.xservices.rt.metaset.exception.MetasetParsingException;
import org.act.xservices.rt.xom.Metaset;
import org.buaa.cse.act.service.publish.SPT;
import org.buaa.cse.act.service.publish.WSDLConvertion;
import org.buaa.cse.act.toolkit.FileOperator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultAttribute;

public class XMLHandler {
    private MetasetParser builder = MetasetParserFactory.getMetasetParser();
    private FileOperator fop = new FileOperator();
    private SPT spt = new SPT();
    private int times = 0;
    private int servicetype = 0;

    public Metaset str2metaset(String fContent, String s) {
        Metaset xml = null;
        ByteArrayInputStream inputs = null;
        try {
            inputs = new ByteArrayInputStream(fContent.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        try {
            xml = this.builder.parse((InputStream)inputs);
        }
        catch (MetasetParsingException e) {
            e.printStackTrace();
        }
        return xml;
    }

    public Metaset str2metaset(String fPath) {
        Metaset xml = null;
        ByteArrayInputStream inputs = null;
        String fContent = this.fop.fileReader(fPath);
        try {
            inputs = new ByteArrayInputStream(fContent.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        try {
            xml = this.builder.parse((InputStream)inputs);
        }
        catch (MetasetParsingException e) {
            e.printStackTrace();
        }
        return xml;
    }

    public void owlsAbstract(Element element) {
        if (this.times == 0) {
            this.owls_RDFAttrandBase(element);
        }
        Iterator i = element.elementIterator();
        while (i.hasNext()) {
            Element element_Local = (Element)i.next();
            String name = element_Local.getNamespaceURI();
            if (!name.endsWith("#")) {
                name = String.valueOf(name) + "#";
            }
            String Qname = element_Local.getName();
            if (name.equals("http://www.w3.org/2002/07/owl#") && Qname.equals("imports")) {
                this.owls_import(element_Local);
            } else if (name.equals("http://www.daml.org/services/owl-s/1.1/Service.owl#") && Qname.equals("Service")) {
                this.owls_servicename(element_Local);
            } else if (name.equals("http://www.daml.org/services/owl-s/1.1/Grounding.owl#") && Qname.equals("wsdlDocument")) {
                this.owls_WSDLDoc(element_Local);
            } else if (name.equals("http://www.daml.org/services/owl-s/1.1/Process.owl#") && Qname.equals("AtomicProcess") || name.equals("http://www.daml.org/services/owl-s/1.1/Process.owl#") && Qname.equals("CompositeProcess")) {
                if (this.servicetype == 0) {
                    this.owls_operationName(element_Local);
                }
            } else if (name.equals("http://www.daml.org/services/owl-s/1.1/Profile.owl#") && Qname.equals("textDescription")) {
                this.owls_operationcomment(element_Local);
            } else if (name.equals("http://www.daml.org/services/owl-s/1.1/Process.owl#") && Qname.equals("Input")) {
                this.owls_input(element_Local);
            } else if (name.equals("http://www.daml.org/services/owl-s/1.1/Process.owl#") && Qname.equals("Output")) {
                this.owls_output(element_Local);
            } else if (name.equals("http://www.daml.org/services/owl-s/1.1/Profile.owl#") && Qname.equals("serviceParameter")) {
                this.owls_OperatopnCategoryandQoS(element_Local);
            } else if (name.equals("http://www.daml.org/services/owl-s/1.1/Process.owl") && Qname.equals("hasPrecondition")) {
                this.owls_precondition(element_Local);
            } else if (name.equals("http://www.daml.org/services/owl-s/1.1/Process.owl") && Qname.equals("hasResult")) {
                this.owls_effect(element_Local);
            }
            ++this.times;
            this.owlsAbstract(element_Local);
        }
    }

    public void owls_RDFAttrandBase(Element element) {
        List aList = element.declaredNamespaces();
        String regex = "rdf|rdfs|xsd|owl|service|profile|process|grounding";
        String base = null;
        if (element.attribute("base") != null) {
            base = element.attribute("base").getStringValue();
            if (!base.contains(".owl")) {
                if (base.contains("#")) {
                    base = base.replace("#", ".owl");
                }
                base = String.valueOf(base) + ".owl";
            }
            this.spt.setSemantic_description(base);
        } else {
            for (Namespace aa : aList) {
                if (base != null || !aa.getPrefix().equals("")) continue;
                base = aa.getStringValue();
                if (!base.contains(".owl")) {
                    if (base.contains("#")) {
                        base = base.replace("#", ".owl");
                    }
                    base = String.valueOf(base) + ".owl";
                }
                this.spt.setSemantic_description(base);
            }
        }
    }

    public void owls_import(Element element) {
        List aList = element.attributes();
        try {
            for (DefaultAttribute mm : aList) {
                String s = mm.getValue();
                if (s.contains("http://www.daml.org/services/owl-s/1.1/Service.owl") || s.contains("http://www.daml.org/services/owl-s/1.1/Profile.owl") || s.contains("http://www.daml.org/services/owl-s/1.1/Process.owl") || s.contains("http://www.daml.org/services/owl-s/1.1/Grounding.owl")) continue;
                if (s.endsWith("#")) {
                    s.replace("#", "");
                }
                if (SPT.modelReferenceList.contains(s)) continue;
                this.spt.setModelReferenceList(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void owls_servicename(Element element) {
        try {
            String sn = element.attributeValue("ID");
            if (sn == null || sn.length() <= 0) {
                sn = element.attributeValue("about");
            }
            this.spt.setServiceName(sn);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void owls_WSDLDoc(Element element) {
        try {
            String wsdl = element.getText();
            this.spt.setWsdl(wsdl);
            if (wsdl.contains("/")) {
                int index = wsdl.indexOf("//");
                int second_index = wsdl.indexOf("/", index + 2);
                if (second_index > 0) {
                    String businessInfo = wsdl.substring(0, second_index);
                    this.spt.setBusinessInfo(businessInfo);
                } else {
                    this.spt.setBusinessInfo(wsdl);
                }
            } else {
                this.spt.setBusinessInfo(wsdl);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void owls_operationName(Element element) {
        String oper = null;
        try {
            if (element.attributeValue("ID") != null) {
                oper = element.attributeValue("ID");
                if (oper.startsWith("#")) {
                    oper = oper.substring(1);
                }
                this.spt.setOperation(oper);
                ++this.servicetype;
            } else if (element.attributeValue("about") != null) {
                oper = element.attributeValue("about");
                if (oper.startsWith("#")) {
                    oper = oper.substring(1);
                }
                this.spt.setOperation(oper);
                ++this.servicetype;
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void owls_operationcomment(Element element) {
        String comment = "";
        try {
            comment = element.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.spt.setComment(comment);
    }

    public void owls_input(Element element) {
        try {
            String name = element.attributeValue("ID");
            if (element.element("parameterType") != null) {
                String mr = element.element("parameterType").getText();
                this.spt.setInputName(name);
                this.spt.setInputModelReference(mr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void owls_output(Element element) {
        try {
            String name = element.attributeValue("ID");
            if (element.element("parameterType") != null) {
                String mr = element.element("parameterType").getText();
                this.spt.setOutputName(name);
                this.spt.setOutputModelReference(mr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void owls_precondition(Element element) {
    }

    public void owls_effect(Element element) {
    }

    public void owls_OperatopnCategoryandQoS(Element element) {
        String parename = "null";
        if (element.element("ServiceParameter") != null) {
            Element element_new = element.element("ServiceParameter");
            if (element_new.element("serviceParameterName") != null) {
                parename = element_new.element("serviceParameterName").getText();
            }
            if (parename.equals("OperationCategory")) {
                String category;
                if (element_new.element("sParameter") != null && element_new.element("sParameter").attribute("resource") != null && (category = element_new.element("sParameter").attribute("resource").getValue()) != null) {
                    this.spt.setOperationModelReference(category);
                }
            } else if (parename.equals("QoS") && element_new.element("sParameter") != null && element_new.element("sParameter").elements() != null && element_new.element("sParameter").elements().get(0) != null) {
                Element QoS = (Element)element_new.element("sParameter").elements().get(0);
                int qos_number = QoS.elements().size();
                int i = 0;
                while (i < qos_number) {
                    Element qos = (Element)QoS.elements().get(i);
                    String URL2 = null;
                    if (qos.getNamespaceURI() != null && qos.getQName() != null) {
                        URL2 = String.valueOf(qos.getNamespaceURI()) + qos.getQName().getName();
                    }
                    this.spt.setQosModelReferenceList(URL2);
                    if (qos.attribute("HasUnit") != null) {
                        String Unit = qos.attribute("HasUnit").getValue();
                        this.spt.setUnit(Unit);
                    } else {
                        this.spt.setUnit(null);
                    }
                    if (qos.attribute("HasUpperLimit") != null) {
                        String UpperLimit = qos.attribute("HasUpperLimit").getValue();
                        this.spt.setUpper(UpperLimit);
                    } else {
                        this.spt.setUpper(null);
                    }
                    if (qos.attribute("HasLowerLimit") != null) {
                        String LowerLimit = qos.attribute("HasLowerLimit").getValue();
                        this.spt.setLower(LowerLimit);
                    } else {
                        this.spt.setLower(null);
                    }
                    ++i;
                }
            }
        }
    }

    public String saAbstract(String fpath) {
        WSDLConvertion wc = new WSDLConvertion();
        return wc.converse(fpath);
    }

    public static void main(String[] args) throws DocumentException {
        XMLHandler hh = new XMLHandler();
        SAXReader reader = new SAXReader();
        String dir = "c://book_pricereviewbook_service.owls";
        Document document = reader.read(new File(dir));
        Element root = document.getRootElement();
        hh.owlsAbstract(root);
        SPT spt = new SPT();
        System.out.println(spt.setSPT());
    }
}

