/*
 * Decompiled with CFR 0.152.
 */
package org.buaa.cse.act.toolkit;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ConfigFileProvider {
    private static final int MAX_SIZE = 30;
    private Hashtable<String, String> ht = new Hashtable(30);

    public ConfigFileProvider() {
        this.readConfigFile();
    }

    private void readConfigFile() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/buaa/cse/act/toolkit/config.properties");
        Properties p = new Properties();
        try {
            p.load(inputStream);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Enumeration<?> en = p.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String property = p.getProperty(key);
            this.ht.put(key, property);
        }
    }

    public String getowlsTemp() {
        return this.ht.get("owlsTemp");
    }

    public String getSAWSDL2SPT() {
        return this.ht.get("SAWSDL2SPT");
    }

    public float WeightForInput() {
        return Float.parseFloat(this.ht.get("WeightForInput"));
    }

    public float WeightForOutput() {
        return Float.parseFloat(this.ht.get("WeightForOutput"));
    }

    public float WeightForQoS() {
        return Float.parseFloat(this.ht.get("WeightForQoS"));
    }

    public float getWeightForSubclass_In() {
        return Float.parseFloat(this.ht.get("WeightForSubclass_In"));
    }

    public float getWeightForSuperclass_In() {
        return Float.parseFloat(this.ht.get("WeightForSuperclass_In"));
    }

    public float getWeightForSubclass_Out() {
        return Float.parseFloat(this.ht.get("WeightForSubclass_Out"));
    }

    public float getWeightForSuperclass_Out() {
        return Float.parseFloat(this.ht.get("WeightForSuperclass_Out"));
    }

    public float getWeightForSemantic() {
        return Float.parseFloat(this.ht.get("WeightForSemantic"));
    }

    public float getWeightForText() {
        return Float.parseFloat(this.ht.get("WeightForText"));
    }

    public String getHostname() {
        return this.ht.get("Hostname");
    }

    public String getUsername() {
        return this.ht.get("Username");
    }

    public String getPassword() {
        return this.ht.get("Password");
    }

    public String getdbDriver() {
        return this.ht.get("dbDriver");
    }

    public String getOntologyDownPath() {
        return String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator");
    }

    public String getOntologySavePath() {
        return String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator");
    }

    public static void main(String[] args) {
    }
}

