/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetNodeList;
import net.didion.jwnl.data.list.PointerTargetTreeNode;
import net.didion.jwnl.data.list.PointerTargetTreeNodeList;

public class PointerTargetTree {
    private PointerTargetTreeNode _rootNode;

    public PointerTargetTree(PointerTargetTreeNode rootNode) {
        this._rootNode = rootNode;
    }

    public PointerTargetTree(Synset synset, PointerTargetTreeNodeList list) {
        this._rootNode = new PointerTargetTreeNode(synset);
        this._rootNode.setChildTreeList(list);
    }

    public PointerTargetTreeNode getRootNode() {
        return this._rootNode;
    }

    public boolean equals(Object obj) {
        return obj instanceof PointerTargetTree && this._rootNode.equals(((PointerTargetTree)obj).getRootNode());
    }

    public Object getFirstMatch(PointerTargetTreeNodeList.Operation opr) {
        Object obj = opr.execute(this.getRootNode());
        if (obj == null && this.getRootNode().hasValidChildTreeList()) {
            obj = this.getRootNode().getChildTreeList().getFirstMatch(opr);
        }
        return obj;
    }

    public List getAllMatches(PointerTargetTreeNodeList.Operation opr) {
        ArrayList<PointerTargetTreeNode> list = new ArrayList<PointerTargetTreeNode>();
        if (opr.execute(this.getRootNode()) != null) {
            list.add(this.getRootNode());
        }
        if (this.getRootNode().hasValidChildTreeList()) {
            this.getRootNode().getChildTreeList().getAllMatches(opr, list);
        }
        return list;
    }

    public PointerTargetTreeNode findFirst(PointerTargetTreeNode node) {
        return (PointerTargetTreeNode)this.getFirstMatch(new PointerTargetTreeNodeList.FindNodeOperation(node));
    }

    public PointerTargetTreeNode findFirst(PointerTarget target) {
        return (PointerTargetTreeNode)this.getFirstMatch(new PointerTargetTreeNodeList.FindTargetOperation(target));
    }

    public PointerTargetTreeNode[] findAll(PointerTargetTreeNode node) {
        List list = this.getAllMatches(new PointerTargetTreeNodeList.FindNodeOperation(node));
        return list.toArray(new PointerTargetTreeNode[list.size()]);
    }

    public PointerTargetTreeNode[] findAll(PointerTarget target) {
        List list = this.getAllMatches(new PointerTargetTreeNodeList.FindTargetOperation(target));
        return list.toArray(new PointerTargetTreeNode[list.size()]);
    }

    public void print() {
        if (this.getRootNode() != null) {
            System.out.println(this.getRootNode());
            this.getRootNode().getChildTreeList().print();
        }
    }

    public PointerTargetNodeList[] reverse() {
        List list = this.toList();
        if (list != null) {
            PointerTargetNodeList[] reversedLists = new PointerTargetNodeList[list.size()];
            for (int i = 0; i < reversedLists.length; ++i) {
                reversedLists[i] = ((PointerTargetNodeList)list.get(i)).reverse();
            }
            return reversedLists;
        }
        return null;
    }

    public List toList() {
        List list = this.getRootNode().toList(new PointerTargetNodeList());
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            PointerTargetNodeList l = (PointerTargetNodeList)itr.next();
            if (l.size() < 2) continue;
            PointerTargetNode root = (PointerTargetNode)l.get(0);
            PointerTargetNode node = (PointerTargetNode)l.get(1);
            root.setType(node.getType());
        }
        return list;
    }
}

