/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.ModuleExtractorFactory;
import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.owlapi.OntologyUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.printer.ClassTreePrinter;
import org.mindswap.pellet.taxonomy.printer.TreeTaxonomyPrinter;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import org.semanticweb.owl.inference.OWLClassReasoner;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.inference.UnsupportedReasonerOperationException;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeListener;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.RemoveAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalClassifier
implements OWLClassReasoner,
OWLOntologyChangeListener {
    public static final Logger log = Logger.getLogger(IncrementalClassifier.class.getName());
    private MultiValueMap<OWLEntity, OWLEntity> modules = null;
    private Set<OWLOntology> ontologies = new HashSet<OWLOntology>();
    private Reasoner reasoner;
    private ModuleExtractor extractor = ModuleExtractorFactory.createModuleExtractor();
    private Taxonomy<OWLClass> taxonomy = null;
    private boolean multiThreaded = true;
    private final boolean classifyOnce = true;
    public Timers timers = this.extractor.getTimers();

    public IncrementalClassifier(OWLOntologyManager manager) {
        this.reasoner = new Reasoner(manager);
        this.extractor = ModuleExtractorFactory.createModuleExtractor();
        manager.addOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public IncrementalClassifier(OWLOntologyManager manager, Reasoner reasoner, ModuleExtractor extractor) {
        this.reasoner = reasoner;
        this.extractor = extractor;
        manager.addOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public static Taxonomy<OWLClass> buildClassHierarchy(Reasoner reasoner) {
        Set nothings;
        Taxonomy taxonomy = new Taxonomy(null, (Object)OWL.Thing, (Object)OWL.Nothing);
        Set things = reasoner.getEquivalentClasses((OWLDescription)OWL.Thing);
        if (!things.isEmpty()) {
            taxonomy.addEquivalents((Object)OWL.Thing, (Collection)things);
        }
        if (!(nothings = reasoner.getEquivalentClasses((OWLDescription)OWL.Nothing)).isEmpty()) {
            taxonomy.addEquivalents((Object)OWL.Nothing, (Collection)nothings);
        }
        for (Set subEq : reasoner.getSubClasses((OWLDescription)OWL.Thing)) {
            IncrementalClassifier.recursiveBuild((Taxonomy<OWLClass>)taxonomy, subEq, reasoner);
        }
        return taxonomy;
    }

    private static void recursiveBuild(Taxonomy<OWLClass> taxonomy, Set<OWLClass> eqClasses, Reasoner reasoner) {
        assert (!eqClasses.isEmpty()) : "Equivalents empty as passed";
        OWLClass cls = eqClasses.iterator().next();
        if (taxonomy.contains((Object)cls)) {
            return;
        }
        Set emptySet = Collections.emptySet();
        taxonomy.addNode(eqClasses, emptySet, emptySet, false);
        for (Set subEq : reasoner.getSubClasses((OWLDescription)cls)) {
            IncrementalClassifier.recursiveBuild(taxonomy, subEq, reasoner);
            taxonomy.addSuper(subEq.iterator().next(), (Object)cls);
        }
    }

    public void classify() throws OWLReasonerException {
        if (this.isClassified()) {
            return;
        }
        if (this.extractor.canUpdate()) {
            this.incrementalClassify();
        } else {
            this.regularClassify();
        }
    }

    public void clearOntologies() throws OWLReasonerException {
    }

    public void dispose() throws OWLReasonerException {
        this.reasoner.dispose();
        this.reasoner.getManager().removeOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public Set<Set<OWLClass>> getAncestorClasses(OWLDescription clsC) throws OWLReasonerException {
        if (clsC.isAnonymous()) {
            throw new IllegalArgumentException("This reasoner only supports named classes");
        }
        this.classify();
        return this.taxonomy.getSupers((Object)((OWLClass)clsC));
    }

    public Set<Set<OWLClass>> getDescendantClasses(OWLDescription clsC) throws OWLReasonerException {
        if (clsC.isAnonymous()) {
            throw new IllegalArgumentException("This reasoner only supports named classes");
        }
        this.classify();
        return this.taxonomy.getSubs((Object)((OWLClass)clsC));
    }

    public Set<OWLClass> getEquivalentClasses(OWLDescription clsC) throws OWLReasonerException {
        if (clsC.isAnonymous()) {
            throw new IllegalArgumentException("This reasoner only supports named classes");
        }
        this.classify();
        return this.taxonomy.getEquivalents((Object)((OWLClass)clsC));
    }

    public Set<OWLClass> getInconsistentClasses() throws OWLReasonerException {
        return this.getEquivalentClasses((OWLDescription)OWL.Nothing);
    }

    public Set<OWLOntology> getLoadedOntologies() {
        return Collections.unmodifiableSet(this.ontologies);
    }

    public MultiValueMap<OWLEntity, OWLEntity> getModules() {
        return this.modules;
    }

    public Reasoner getReasoner() {
        return this.reasoner;
    }

    public Set<Set<OWLClass>> getSubClasses(OWLDescription clsC) throws OWLReasonerException {
        if (clsC.isAnonymous()) {
            throw new UnsupportedReasonerOperationException("This reasoner only supports named classes");
        }
        this.classify();
        return this.taxonomy.getSubs((Object)((OWLClass)clsC), true);
    }

    public Set<Set<OWLClass>> getSuperClasses(OWLDescription clsC) throws OWLReasonerException {
        if (clsC.isAnonymous()) {
            throw new UnsupportedReasonerOperationException("This reasoner only supports named classes");
        }
        this.classify();
        return this.taxonomy.getSupers((Object)((OWLClass)clsC), true);
    }

    private void incClassifyAllModStrategy() {
        HashSet<OWLEntity> effects = new HashSet<OWLEntity>();
        effects.addAll(this.extractor.updateModules(this.taxonomy, true));
        effects.addAll(this.extractor.updateModules(this.taxonomy, false));
        if (log.isLoggable(Level.FINE)) {
            log.fine("Module entities " + effects);
        }
        OWLOntology owlModule = this.extractor.getModuleFromSignature(effects);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Module axioms " + owlModule.getLogicalAxioms());
        }
        Reasoner moduleReasoner = new Reasoner(this.reasoner.getManager());
        moduleReasoner.setOntology(owlModule);
        moduleReasoner.classify();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Classified module:");
            new ClassTreePrinter().print(moduleReasoner.getKB().getTaxonomy(), new PrintWriter(System.err));
        }
        Taxonomy<OWLClass> moduleTaxonomy = IncrementalClassifier.buildClassHierarchy(moduleReasoner);
        HashSet<OWLClass> affectedCls = new HashSet<OWLClass>();
        for (OWLEntity entity : effects) {
            if (!(entity instanceof OWLClass)) continue;
            affectedCls.add((OWLClass)entity);
        }
        this.taxonomy = this.updateClassHierarchy(this.taxonomy, moduleTaxonomy, affectedCls);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Updated taxonomy:");
            new TreeTaxonomyPrinter().print(this.taxonomy, new PrintWriter(System.err));
        }
        OntologyUtils.getOWLOntologyManager().removeOntology(owlModule.getURI());
    }

    private void incrementalClassify() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Incremental classification starting");
        }
        Timer timer = this.timers.startTimer("incrementalClassify");
        this.incClassifyAllModStrategy();
        timer.stop();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Incremental classification done");
        }
    }

    public boolean isClassified() throws OWLReasonerException {
        return this.modules != null && !this.extractor.isChanged();
    }

    public boolean isDefined(OWLClass cls) throws OWLReasonerException {
        return !this.extractor.getAxioms((OWLEntity)cls).isEmpty();
    }

    public boolean isDefined(OWLDataProperty prop) throws OWLReasonerException {
        return !this.extractor.getAxioms((OWLEntity)prop).isEmpty();
    }

    public boolean isDefined(OWLIndividual ind) throws OWLReasonerException {
        return !this.extractor.getAxioms((OWLEntity)ind).isEmpty();
    }

    public boolean isDefined(OWLObjectProperty prop) throws OWLReasonerException {
        return !this.extractor.getAxioms((OWLEntity)prop).isEmpty();
    }

    public boolean isEquivalentClass(OWLDescription clsC, OWLDescription clsD) throws OWLReasonerException {
        if (clsC.isAnonymous() || clsD.isAnonymous()) {
            throw new UnsupportedReasonerOperationException("This reasoner only supports named classes");
        }
        this.classify();
        return this.taxonomy.isEquivalent((Object)((OWLClass)clsC), (Object)((OWLClass)clsD)) == Bool.TRUE;
    }

    public boolean isRealised() throws OWLReasonerException {
        return false;
    }

    public boolean isSatisfiable(OWLDescription description) throws OWLReasonerException {
        if (description.isAnonymous() || !this.isClassified()) {
            this.reasoner.isSatisfiable(description);
        }
        return !this.getInconsistentClasses().contains(description);
    }

    public boolean isSubClassOf(OWLDescription clsC, OWLDescription clsD) throws OWLReasonerException {
        if (clsC.isAnonymous() || clsD.isAnonymous() || !this.isClassified()) {
            this.reasoner.isSubClassOf(clsC, clsD);
        }
        this.classify();
        return this.taxonomy.isSubNodeOf((Object)((OWLClass)clsC), (Object)((OWLClass)clsD)) == Bool.TRUE;
    }

    public void loadOntologies(Set<OWLOntology> ontologies) throws OWLReasonerException {
        for (OWLOntology ontology : ontologies) {
            this.loadOntology(ontology);
        }
    }

    public void loadOntology(OWLOntology ontology) throws OWLReasonerException {
        if (this.ontologies.add(ontology)) {
            this.extractor.addOntology(ontology);
            this.reasoner.loadOntology(ontology);
        }
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !this.ontologies.contains(oWLOntologyChange.getOntology())) continue;
            OWLAxiom axiom = oWLOntologyChange.getAxiom();
            if (oWLOntologyChange instanceof AddAxiom) {
                this.extractor.addAxiom(axiom);
                continue;
            }
            if (oWLOntologyChange instanceof RemoveAxiom) {
                this.extractor.deleteAxiom(axiom);
                continue;
            }
            throw new UnsupportedOperationException("Unrecognized axiom change: " + oWLOntologyChange);
        }
        this.reasoner.ontologiesChanged(changes);
    }

    public void realise() throws OWLReasonerException {
        throw new UnsupportedReasonerOperationException();
    }

    private void regularClassify() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Regular classification starting");
        }
        Thread classification = new Thread("classification"){

            public void run() {
                Timer timer = IncrementalClassifier.this.timers.startTimer("reasonerClassify");
                IncrementalClassifier.this.reasoner.classify();
                timer.stop();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Regular taxonomy:");
                    new TreeTaxonomyPrinter().print(IncrementalClassifier.this.reasoner.getKB().getTaxonomy(), new PrintWriter(System.err));
                }
                timer = IncrementalClassifier.this.timers.startTimer("buildClassHierarchy");
                IncrementalClassifier.this.taxonomy = IncrementalClassifier.buildClassHierarchy(IncrementalClassifier.this.reasoner);
                timer.stop();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Copied taxonomy:");
                    new TreeTaxonomyPrinter().print(IncrementalClassifier.this.taxonomy, new PrintWriter(System.err));
                }
            }
        };
        Thread partitioning = new Thread("partitioning"){

            public void run() {
                IncrementalClassifier.this.modules = IncrementalClassifier.this.extractor.extractModules();
            }
        };
        try {
            Timer timer = this.timers.startTimer("regularClassify");
            if (this.multiThreaded) {
                classification.start();
                partitioning.start();
                classification.join();
                partitioning.join();
            } else {
                classification.run();
                partitioning.run();
            }
            timer.stop();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Regular classification done");
        }
    }

    public void unloadOntologies(Set<OWLOntology> ontologies) throws OWLReasonerException {
    }

    private Taxonomy<OWLClass> updateClassHierarchy(Taxonomy<OWLClass> taxonomy, Taxonomy<OWLClass> moduleTaxonomy, Set<OWLClass> affected) {
        HashSet inTaxonomy = new HashSet(moduleTaxonomy.getClasses());
        inTaxonomy.remove(OWL.Thing);
        inTaxonomy.remove(OWL.Nothing);
        assert (affected.containsAll(inTaxonomy)) : "Unaffected nodes in changed taxonomy";
        HashSet<OWLClass> removed = new HashSet<OWLClass>(affected);
        removed.removeAll(moduleTaxonomy.getClasses());
        List sorted = taxonomy.topologocialSort(false);
        Set emptySet = Collections.emptySet();
        for (OWLClass cls : sorted) {
            if (removed.contains(cls) || moduleTaxonomy.contains((Object)cls)) continue;
            moduleTaxonomy.addNode((Collection)taxonomy.getAllEquivalents((Object)cls), emptySet, emptySet, false);
            Set supers = taxonomy.getFlattenedSupers((Object)cls, true);
            supers.removeAll(removed);
            moduleTaxonomy.addSupers((Object)cls, (Collection)supers);
        }
        ArrayList<OWLClass> nothings = new ArrayList<OWLClass>();
        for (OWLClass cls : taxonomy.getEquivalents((Object)OWL.Nothing)) {
            if (removed.contains(cls) || moduleTaxonomy.contains((Object)cls)) continue;
            nothings.add(cls);
        }
        if (!nothings.isEmpty()) {
            moduleTaxonomy.addEquivalents((Object)OWL.Nothing, nothings);
        }
        return moduleTaxonomy;
    }

    public boolean isMultiThreaded() {
        return this.multiThreaded;
    }

    public void setMultiThreaded(boolean multiThreaded) {
        this.multiThreaded = multiThreaded;
    }
}

