/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdutil;

import arq.cmdutil.QueryContext;
import com.hp.hpl.jena.query.DataSetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.ResultSetTextFormatter;
import com.hp.hpl.jena.query.vocabulary.ResultSetVocab;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.util.FileUtils;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunQuery {
    public static final String FMT_NONE = "none";
    public static final String FMT_TUPLES = "tuples";
    public static final String FMT_TEXT = "text";
    public static final String FMT_RS_RDF = "rs/graph";
    public static final String FMT_RS_TEXT = "rs/text";
    public static final String FMT_RS_XML = "rs/xml";
    public static final String FMT_RDF_XML = "RDF/XML_ABBREV";
    public static final String FMT_RDF_N3 = "N3";
    public static final String FMT_RDF_NT = "N-TRIPLES";
    static String vocabularyURI = null;
    static Model vocabulary = null;
    protected static Log log = LogFactory.getLog((Class)RunQuery.class);

    public static void query(QueryContext queryContext) {
        RunQuery.queryFixDataSet(queryContext);
        RunQuery.dumpData(queryContext);
        RunQuery.queryFixOutputFormat(queryContext);
        RunQuery.queryCreateQuery(queryContext);
        if (queryContext.query == null) {
            return;
        }
        RunQuery.dumpQuery(queryContext);
        RunQuery.queryExec(queryContext);
    }

    public static void parse(QueryContext queryContext) {
        RunQuery.queryCreateQuery(queryContext);
        if (queryContext.query == null) {
            return;
        }
    }

    public static void doQuery(Query query2, QueryExecution queryExecution, String string) {
        if (query2.isSelectType()) {
            RunQuery.doSelectQuery(query2, queryExecution, string);
        }
        if (query2.isDescribeType()) {
            RunQuery.doDescribeQuery(query2, queryExecution, string);
        }
        if (query2.isConstructType()) {
            RunQuery.doConstructQuery(query2, queryExecution, string);
        }
        if (query2.isAskType()) {
            RunQuery.doAskQuery(query2, queryExecution, string);
        }
        queryExecution.close();
    }

    static void queryFixDataSet(QueryContext queryContext) {
        try {
            if (queryContext.graphURLs != null || queryContext.namedGraphURLs != null) {
                queryContext.dataSet = DataSetFactory.create(queryContext.graphURLs, queryContext.namedGraphURLs, queryContext.fileManager, null);
            }
        }
        catch (Exception exception) {
            System.err.println("Error loading URL " + exception);
            System.exit(1);
        }
    }

    static void queryFixOutputFormat(QueryContext queryContext) {
        if (queryContext.outputFormat == null) {
            queryContext.outputFormat = FMT_TEXT;
        }
    }

    static void queryCreateQuery(QueryContext queryContext) {
        if (queryContext.query != null) {
            return;
        }
        if (queryContext.queryFilename != null && queryContext.queryString != null) {
            System.err.println("Both query string and query file name given");
            return;
        }
        if (queryContext.queryFilename == null && queryContext.queryString == null) {
            System.err.println("No query string and no query file name given");
            return;
        }
        try {
            if (queryContext.queryFilename != null) {
                queryContext.query = QueryFactory.read(queryContext.queryFilename, queryContext.baseURI, queryContext.inSyntax);
            }
            if (queryContext.queryString != null) {
                if (queryContext.inSyntax == null) {
                    queryContext.inSyntax = "http://jena.hpl.hp.com/2003/07/query/SPARQL";
                }
                queryContext.query = QueryFactory.create(queryContext.queryString, queryContext.baseURI, queryContext.inSyntax);
            }
        }
        catch (ARQInternalErrorException aRQInternalErrorException) {
            System.err.println(aRQInternalErrorException.getMessage());
            if (aRQInternalErrorException.getCause() != null) {
                System.err.println("Cause:");
                aRQInternalErrorException.getCause().printStackTrace(System.err);
                System.err.println();
            }
            aRQInternalErrorException.printStackTrace(System.err);
            return;
        }
        catch (QueryException queryException) {
            System.err.println(queryException.getMessage());
            return;
        }
        catch (Exception exception) {
            System.out.flush();
            exception.printStackTrace(System.err);
            return;
        }
    }

    static void queryExec(QueryContext queryContext) {
        try {
            QueryExecution queryExecution = QueryExecutionFactory.create(queryContext.query, queryContext.dataSet);
            if (queryContext.dataSet == null && !queryContext.query.hasDataSetDescription()) {
                System.err.println("Dataset not specified in query nor provided on command line.");
                return;
            }
            if (queryContext.fileManager != null) {
                queryExecution.setFileManager(queryContext.fileManager);
            }
            queryExecution.init();
            RunQuery.doQuery(queryContext.query, queryExecution, queryContext.outputFormat);
            queryExecution.close();
        }
        catch (ARQInternalErrorException aRQInternalErrorException) {
            System.err.println(aRQInternalErrorException.getMessage());
            if (aRQInternalErrorException.getCause() != null) {
                System.err.println("Cause:");
                aRQInternalErrorException.getCause().printStackTrace(System.err);
                System.err.println();
            }
            aRQInternalErrorException.printStackTrace(System.err);
        }
        catch (QueryException queryException) {
            System.err.println("Query Exeception: " + (Object)((Object)queryException));
            System.exit(9);
        }
        catch (Exception exception) {
            System.out.flush();
            exception.printStackTrace(System.err);
        }
    }

    static void doSelectQuery(Query query2, QueryExecution queryExecution, String string) {
        Object object;
        Object object2;
        ResultSet resultSet = queryExecution.execSelect();
        resultSet = ResultSetFactory.makeRewindable(resultSet);
        boolean bl = false;
        if (string.equals(FMT_NONE)) {
            object2 = new ResultSetFormatter(resultSet, query2.getPrefixMap());
            ((ResultSetFormatter)object2).consume();
            bl = true;
        }
        if (string.equals(FMT_RS_RDF)) {
            object2 = new ResultSetFormatter(resultSet, query2.getPrefixMap());
            object = ((ResultSetFormatter)object2).toModel();
            RDFWriter rDFWriter = object.getWriter("TURTLE");
            object.setNsPrefix("rs", ResultSetVocab.getURI());
            rDFWriter.write((Model)object, (OutputStream)System.out, null);
            bl = true;
        }
        object2 = FileUtils.asPrintWriterUTF8((OutputStream)System.out);
        if (string.equals(FMT_RS_XML)) {
            object = new ResultSetFormatter(resultSet, query2.getPrefixMap());
            ((ResultSetFormatter)object).outputAsXML(System.out);
            bl = true;
        }
        if (string.equals(FMT_RS_TEXT)) {
            object = new ResultSetFormatter(resultSet, query2.getPrefixMap());
            ((ResultSetFormatter)object).outputAsText(System.out);
            bl = true;
        }
        object = new ResultSetFormatter(resultSet, query2.getPrefixMap());
        if (string.equals(FMT_TEXT)) {
            ((ResultSetTextFormatter)object).printAll((PrintWriter)object2);
            bl = true;
        }
        if (string.equals(FMT_TUPLES)) {
            ((ResultSetTextFormatter)object).dump((PrintWriter)object2, true);
            bl = true;
        }
        if (!bl) {
            log.warn((Object)("Unknown format request: " + string));
        }
        if (object2 != null) {
            ((PrintWriter)object2).flush();
        }
    }

    static void doDescribeQuery(Query query2, QueryExecution queryExecution, String string) {
        Model model = queryExecution.execDescribe();
        RunQuery.writeModel(model, string);
    }

    static void doConstructQuery(Query query2, QueryExecution queryExecution, String string) {
        Model model = queryExecution.execConstruct();
        RunQuery.writeModel(model, string);
    }

    static void writeModel(Model model, String string) {
        if (string.equals(FMT_NONE)) {
            return;
        }
        if (string.equals(FMT_TEXT)) {
            System.out.println("======== CONSTRUCT results ");
            model.write((OutputStream)System.out, FMT_RDF_N3, null);
            System.out.println("======== ");
            return;
        }
        if (string.equals(FMT_RDF_XML)) {
            model.write((OutputStream)System.out, "RDF/XML-ABBREV", null);
            return;
        }
        if (string.equals(FMT_RDF_N3)) {
            model.write((OutputStream)System.out, FMT_RDF_N3, null);
            return;
        }
        if (string.equals(FMT_RDF_NT)) {
            model.write((OutputStream)System.out, "N_TRIPLES", null);
            return;
        }
        System.err.println("Unknown format: " + string);
    }

    static void doAskQuery(Query query2, QueryExecution queryExecution, String string) {
        boolean bl = queryExecution.execAsk();
        if (!string.equals(FMT_NONE)) {
            System.out.println("Ask => " + (bl ? "Yes" : "No"));
        }
    }

    static void dumpQuery(QueryContext queryContext) {
        if (queryContext.messageLevel > 0) {
            IndentedWriter indentedWriter = new IndentedWriter(System.out, true);
            queryContext.query.serialize(indentedWriter);
            indentedWriter.flush();
            System.out.println();
        }
    }

    static void dumpData(QueryContext queryContext) {
        boolean bl = false;
        if (bl) {
            if (queryContext.dataSet == null) {
                System.out.println("Dataset is null");
            } else {
                System.out.println("DataSet: " + queryContext.dataSet);
            }
        }
    }
}

