/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.ArgDecl;
import arq.cmdline.CommandLine;
import arq.cmdutil.CmdUtils;
import arq.cmdutil.QueryContext;
import arq.cmdutil.RunQuery;
import com.hp.hpl.jena.query.util.QueryUtils;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.query.util.TranslationTable;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.LocationMapper;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class query {
    static String defaultSyntax;
    protected static Log log;
    static TranslationTable resultFormats;

    public static void main(String[] stringArray) {
        Object object;
        String string;
        boolean bl;
        if (stringArray.length == 0) {
            query.usage();
            System.exit(0);
        }
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(false, "h", "help");
        commandLine.add(argDecl);
        ArgDecl argDecl2 = new ArgDecl(false, "v", "verbose");
        commandLine.add(argDecl2);
        ArgDecl argDecl3 = new ArgDecl(false, "q", "quiet");
        commandLine.add(argDecl3);
        ArgDecl argDecl4 = new ArgDecl(true, "graph", "data", "with");
        commandLine.add(argDecl4);
        ArgDecl argDecl5 = new ArgDecl(true, "named", "namedgraph", "namedGraph", "from");
        commandLine.add(argDecl5);
        ArgDecl argDecl6 = new ArgDecl(true, "query", "file");
        commandLine.add(argDecl6);
        ArgDecl argDecl7 = new ArgDecl(true, "syntax", "syn");
        commandLine.add(argDecl7);
        ArgDecl argDecl8 = new ArgDecl(true, "fmt", "format");
        commandLine.add(argDecl8);
        ArgDecl argDecl9 = new ArgDecl(true, "results", "rfmt");
        commandLine.add(argDecl9);
        ArgDecl argDecl10 = new ArgDecl(true, "dir");
        commandLine.add(argDecl10);
        ArgDecl argDecl11 = new ArgDecl(true, "base");
        commandLine.add(argDecl11);
        ArgDecl argDecl12 = new ArgDecl(true, "lmap");
        commandLine.add(argDecl12);
        try {
            commandLine.process(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            query.usage(System.err);
            System.exit(2);
        }
        if (commandLine.contains(argDecl)) {
            query.usage();
            System.exit(0);
        }
        QueryContext queryContext = new QueryContext();
        boolean bl2 = commandLine.contains(argDecl2);
        if (bl2) {
            ++queryContext.messageLevel;
        }
        if (bl = commandLine.contains(argDecl3)) {
            --queryContext.messageLevel;
        }
        if (commandLine.contains(argDecl10)) {
            string = commandLine.getValue(argDecl10);
            queryContext.fileManager = new FileManager();
            queryContext.fileManager.addLocatorFile(string);
            queryContext.fileManager.addLocatorURL();
        } else {
            queryContext.fileManager = FileManager.get();
        }
        if (commandLine.contains(argDecl11)) {
            queryContext.baseURI = commandLine.getValue(argDecl11);
            RelURI.setBaseURI(queryContext.baseURI);
        }
        if (commandLine.contains(argDecl12)) {
            string = commandLine.getValue(argDecl12);
            object = new LocationMapper(string);
            queryContext.fileManager.setMapper(object);
        }
        queryContext.defaultSyntax = defaultSyntax;
        if (commandLine.contains(argDecl7)) {
            string = commandLine.getValue(argDecl7);
            queryContext.inSyntax = QueryUtils.querySyntaxNames.lookup(string);
            if (queryContext.inSyntax == null) {
                query.argError("Unrecognized syntax: " + string);
            }
        }
        string = commandLine.getValue(argDecl6);
        if (commandLine.items().size() == 0 && string == null) {
            query.argError("No query string or query file");
        }
        if (commandLine.items().size() > 1) {
            query.argError("Only one query string allowed");
        }
        if (commandLine.items().size() == 1 && string != null) {
            query.argError("Either query string or query file - not both");
        }
        if (string != null) {
            queryContext.queryFilename = string;
        } else {
            queryContext.queryString = (String)commandLine.items().get(0);
        }
        if (commandLine.contains(argDecl4)) {
            queryContext.graphURLs = commandLine.getValues(argDecl4);
        }
        if (commandLine.contains(argDecl8)) {
            object = commandLine.getValue(argDecl8);
            queryContext.dataSyntax = QueryUtils.dataSyntaxNames.lookup((String)object);
            if (queryContext.dataSyntax == null) {
                query.argError("Unrecognized syntax for data: " + (String)object);
            }
        }
        if (commandLine.contains(argDecl5)) {
            queryContext.namedGraphURLs = commandLine.getValues(argDecl5);
        }
        if (commandLine.contains(argDecl9)) {
            object = commandLine.getValue(argDecl9);
            queryContext.outputFormat = resultFormats.lookup((String)object);
            if (queryContext.outputFormat == null) {
                query.argError("Unrecognized output format: " + (String)object);
            }
        }
        try {
            RunQuery.query(queryContext);
        }
        catch (Exception exception) {
            System.err.println("Exception from RunQuery: " + exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(9);
        }
    }

    static void usage() {
        query.usage(System.out);
    }

    static void usage(PrintStream printStream) {
        printStream.println("Usage: [--data URL] [exprString | --query file]");
        printStream.println("   --query file         Read one query from a file");
        printStream.println("   --syntax SYN         Query syntax");
        printStream.println("                            SPARQL (default), ARQ, RDQL, N3QL");
        printStream.println("                            File suffixes imply syntax:");
        printStream.println("                            .rq / SPARQL,  .arq / ARQ, .rdql / RDQL");
        printStream.println("   --graph URL          DataSource source (can also be part of query)");
        printStream.println("   --data URL           Synonym for --graph");
        printStream.println("   --namedGraph URL     DataSource source (can also be part of query)");
        printStream.println("   --named URL          Synonym for --namedGraph");
        printStream.println("                            URLs can be file: or http:");
        printStream.println("                            No schema => file:");
        printStream.println("                            Extensions used to guess the format as well");
        printStream.println("                                .rdf, .n3, .nt, .ttl");
        printStream.println("   --fmt FMT            Data source format: RDF/XML (default),");
        printStream.println("                            N3, N-TRIPLES, TURTLE");
        printStream.println("   --results FORM       Format of result");
        printStream.println("                          SELECT queries");
        printStream.println("                            text [default], tuples, none for display");
        printStream.println("                            rs, rs/graph, rs/xml, rs/text for the result set ");
        printStream.println("                          CONSTRUCT and DESCRIBE queries");
        printStream.println("                            RDF, RDF/XML, N3, N-TRIPLES");
        printStream.println("   --verbose            Verbose - more messages");
        printStream.println("   --quiet              Quiet - less messages");
    }

    static void argError(String string) {
        System.err.println("Argument Error: " + string);
        System.exit(3);
    }

    static {
        CmdUtils.setLog4j();
        CmdUtils.setN3Params();
        defaultSyntax = "http://jena.hpl.hp.com/2003/07/query/SPARQL";
        log = LogFactory.getLog((Class)query.class);
        resultFormats = new TranslationTable(true);
        resultFormats.put("none", "none");
        resultFormats.put("tuples", "tuples");
        resultFormats.put("text", "text");
        resultFormats.put("xml", "rs/xml");
        resultFormats.put("rs", "rs/graph");
        resultFormats.put("rs/text", "rs/text");
        resultFormats.put("rs/raw", "rs/text");
        resultFormats.put("rs/graph", "rs/xml");
        resultFormats.put("rs/xml", "rs/xml");
        resultFormats.put("rdf", "RDF/XML_ABBREV");
        resultFormats.put("rdf/xml", "RDF/XML_ABBREV");
        resultFormats.put("n3", "N3");
        resultFormats.put("n-triples", "N-TRIPLES");
    }
}

