/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.DescribeHandler;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.QueryElement;
import com.hp.hpl.jena.query.core.Substitution;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.function.FunctionRegistry;
import com.hp.hpl.jena.query.serializer.Serializer;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.PrefixMapping2;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.FileManager;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Query {
    static Log log = LogFactory.getLog((Class)Query.class);
    public static final int QueryTypeUnknown = -123;
    public static final int QueryTypeSelect = 111;
    public static final int QueryTypeConstruct = 222;
    public static final int QueryTypeDescribe = 333;
    public static final int QueryTypeAsk = 444;
    int queryType = -123;
    List graphURIs = null;
    List namedGraphURIs = null;
    ElementBlock queryBlock = null;
    String syntax = "http://jena.hpl.hp.com/2003/07/query/SPARQL";
    public static long NOLIMIT = Long.MIN_VALUE;
    long resultLimit = NOLIMIT;
    boolean strictQuery = true;
    protected boolean queryResultStar = false;
    protected List resultVars = new ArrayList();
    protected boolean distinct = false;
    protected long anonVarCounter = 0L;
    protected Map anonVars = new HashMap();
    protected Template constructTemplate = null;
    protected List resultNodes = new ArrayList();
    protected DescribeHandler defaultDescribeHandler = null;
    protected boolean seenBaseURI = false;
    protected String baseURI = null;
    protected static PrefixMapping globalPrefixMap = new PrefixMappingImpl();
    protected FunctionRegistry registry = FunctionRegistry.global();
    protected PrefixMapping2 prefixMap = new PrefixMapping2(globalPrefixMap, (PrefixMapping)new PrefixMappingImpl());

    public static Query create(String string) {
        return QueryFactory.create(string);
    }

    public static Query create(String string, String string2) {
        return QueryFactory.create(string, string2);
    }

    public static Query create(String string, String string2, String string3) {
        return QueryFactory.create(string, string2, string3);
    }

    public static Query parse(Query query2, String string, String string2, String string3) {
        return QueryFactory.parse(query2, string, string2, string3);
    }

    public static Query read(String string) {
        return QueryFactory.read(string);
    }

    public static Query read(String string, String string2) {
        return QueryFactory.read(string, string2);
    }

    public static Query read(String string, String string2, String string3) {
        return QueryFactory.read(string, string2, string3);
    }

    public static Query read(String string, FileManager fileManager, String string2, String string3) {
        return QueryFactory.read(string, fileManager, string2, string3);
    }

    public void setType(int n) {
        this.queryType = n;
    }

    public int getType(int n) {
        return this.queryType;
    }

    public void setStrict(boolean bl) {
        this.strictQuery = bl;
        if (this.strictQuery) {
            this.initStrict();
        } else {
            this.initLax();
        }
    }

    public boolean isStrict() {
        return this.strictQuery;
    }

    private void initStrict() {
        if (this.prefixMap.getGlobalPrefixMapping() == globalPrefixMap) {
            this.prefixMap.setGlobalPrefixMapping(null);
        }
    }

    private void initLax() {
        if (this.prefixMap.getGlobalPrefixMapping() == null) {
            this.prefixMap.setGlobalPrefixMapping(globalPrefixMap);
        }
    }

    public void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void setSyntax(String string) {
        this.syntax = string;
    }

    public long getLimit() {
        return this.resultLimit;
    }

    public void setLimit(long l) {
        this.resultLimit = l;
    }

    public boolean hasLimit() {
        return this.resultLimit != NOLIMIT;
    }

    public boolean isSelectType() {
        return this.queryType == 111;
    }

    public boolean isConstructType() {
        return this.queryType == 222;
    }

    public boolean isDescribeType() {
        return this.queryType == 333;
    }

    public boolean isAskType() {
        return this.queryType == 444;
    }

    public boolean isUnknownType() {
        return this.queryType == -123;
    }

    public boolean getQueryResultStar() {
        return this.queryResultStar;
    }

    public void setQueryResultStar(boolean bl) {
        this.queryResultStar = bl;
    }

    public void setQueryElement(QueryElement queryElement) {
        if (this.queryBlock == null) {
            this.queryBlock = new ElementBlock(null, null);
        }
        this.queryBlock.setQueryElement(queryElement);
    }

    public void setQueryBlock(ElementBlock elementBlock) {
        this.queryBlock = elementBlock;
    }

    public ElementBlock getQueryBlock() {
        return this.queryBlock;
    }

    public void addGraphURI(String string) {
        if (this.graphURIs == null) {
            this.graphURIs = new ArrayList();
        }
        this.graphURIs.add(string);
    }

    public void addNamedGraphURI(String string) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList();
        }
        this.namedGraphURIs.add(string);
    }

    public List getGraphURIs() {
        return this.graphURIs;
    }

    public List getNamedGraphURIs() {
        return this.namedGraphURIs;
    }

    public boolean hasDataSetDescription() {
        if (this.getGraphURIs() != null && this.getGraphURIs().size() > 0) {
            return true;
        }
        return this.getNamedGraphURIs() != null && this.getNamedGraphURIs().size() > 0;
    }

    public List getResultVars() {
        return this.resultVars;
    }

    public void addResultVar(String string) {
        if (!this.resultVars.contains(string)) {
            this.resultVars.add(string);
        }
    }

    public void addResultVar(Node node) {
        if (!node.isVariable()) {
            throw new QueryException("Not a variable: " + node);
        }
        this.addResultVar(node.getName());
    }

    public Node allocAnonVariable(Node node) {
        if (!this.anonVars.containsKey(node)) {
            ++this.anonVarCounter;
            Node node2 = Node.createVariable((String)(ARQ.anonVarMarker + this.anonVarCounter));
            this.anonVars.put(node, node2);
        }
        return (Node)this.anonVars.get(node);
    }

    public void addDescribeNode(Node node) {
        if (node.isVariable()) {
            this.addResultVar(node);
            return;
        }
        if (node.isURI()) {
            this.addResultURIs(node);
            return;
        }
        if (node.isLiteral()) {
            throw new QueryException("Result node is a literal: " + QueryPrintUtils.stringForNode(node));
        }
        throw new QueryException("Result node not recognized: " + QueryPrintUtils.stringForNode(node));
    }

    public Template getConstructTemplate() {
        return this.constructTemplate;
    }

    public Substitution getTripleSubstitution() {
        if (this.getQueryResultStar()) {
            return this.getQueryBlock();
        }
        return this.getConstructTemplate();
    }

    public void setConstructTemplate(Template template) {
        this.constructTemplate = template;
    }

    public List getResultURIs() {
        return this.resultNodes;
    }

    public void addResultURIs(Node node) {
        if (node.isLiteral()) {
            throw new QueryException("Result URI is a literal: " + QueryPrintUtils.stringForNode(node));
        }
        if (!this.resultNodes.contains(node)) {
            this.resultNodes.add(node);
        }
    }

    public boolean explicitlySetBaseURI() {
        return this.seenBaseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
        this.seenBaseURI = true;
    }

    void initParserBaseURI() {
        this.initParserBaseURI(null);
    }

    void initParserBaseURI(String string) {
        if (this.baseURI != null) {
            return;
        }
        this.baseURI = RelURI.chooseBaseURI(string);
    }

    public void setPrefix(String string, String string2) {
        try {
            this.prefixMap.setNsPrefix(string, string2);
        }
        catch (PrefixMapping.IllegalPrefixException illegalPrefixException) {
            log.warn((Object)("Illegal prefix mapping(ignored): " + string + "=>" + string2));
        }
    }

    public PrefixMapping getPrefixMap() {
        return this.prefixMap;
    }

    public PrefixMapping getLocalPrefixMap() {
        return this.prefixMap.getLocalPrefixMapping();
    }

    public static PrefixMapping getGlobalPrefixMap() {
        return globalPrefixMap;
    }

    public String getPrefix(String string) {
        return this.prefixMap.getNsPrefixURI(string);
    }

    public String expandQName(String string) {
        String string2 = this.prefixMap.expandPrefix(string);
        if (string2.equals(string)) {
            return null;
        }
        return string2;
    }

    public String shortForm(String string) {
        return this.prefixMap.shortForm(string);
    }

    public String toString() {
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        this.serialize(indentedLineBuffer);
        return indentedLineBuffer.toString();
    }

    public void serialize(OutputStream outputStream) {
        Serializer.serialize(this, outputStream);
    }

    public void unparse(OutputStream outputStream) {
        this.serialize(outputStream);
    }

    public void serialize(OutputStream outputStream, String string) {
        Serializer.serialize(this, outputStream, string);
    }

    public void unparse(OutputStream outputStream, String string) {
        this.serialize(outputStream, string);
    }

    public void serialize(IndentedLineBuffer indentedLineBuffer) {
        Serializer.serialize(this, indentedLineBuffer);
    }

    public void unparse(IndentedLineBuffer indentedLineBuffer) {
        this.serialize(indentedLineBuffer);
    }

    public void serialize(IndentedLineBuffer indentedLineBuffer, String string) {
        Serializer.serialize(this, indentedLineBuffer, string);
    }

    public void unparse(IndentedLineBuffer indentedLineBuffer, String string) {
        this.serialize(indentedLineBuffer, string);
    }

    public void serialize(IndentedWriter indentedWriter) {
        Serializer.serialize(this, indentedWriter);
    }

    public void unparse(IndentedWriter indentedWriter) {
        this.serialize(indentedWriter);
    }

    public void serialize(IndentedWriter indentedWriter, String string) {
        Serializer.serialize(this, indentedWriter, string);
    }

    public void unparse(IndentedWriter indentedWriter, String string) {
        this.serialize(indentedWriter, string);
    }

    static {
        globalPrefixMap.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        globalPrefixMap.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        globalPrefixMap.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        globalPrefixMap.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
    }
}

