/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.parser.Parser;
import com.hp.hpl.jena.query.util.QueryUtils;
import com.hp.hpl.jena.util.FileManager;

public class QueryFactory {
    public static Query create(String string) {
        return QueryFactory.create(string, "http://jena.hpl.hp.com/2003/07/query/SPARQL");
    }

    public static Query create(String string, String string2) {
        return QueryFactory.create(string, null, string2);
    }

    public static Query create(String string, String string2, String string3) {
        Query query2 = new Query();
        QueryFactory.parse(query2, string, string2, string3);
        return query2;
    }

    public static Query parse(Query query2, String string, String string2, String string3) {
        if (string3 == null) {
            string3 = query2.getSyntax();
        } else {
            query2.setSyntax(string3);
        }
        query2.initParserBaseURI(string2);
        if (string3.equals("http://jena.hpl.hp.com/2003/07/query/ARQ")) {
            return Parser.parseARQ(query2, string);
        }
        if (string3.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL")) {
            return Parser.parseSPARQL(query2, string);
        }
        if (string3.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL-alt")) {
            return Parser.parseSPARQLalt(query2, string);
        }
        if (string3.equals("http://jena.hpl.hp.com/2003/07/query/RDQL")) {
            return Parser.parseRDQL(query2, string);
        }
        if (string3.equals("http://jena.hpl.hp.com/2003/07/query/N3QL")) {
            return Parser.parseN3QL(query2, string);
        }
        if (string3.equals("http://jena.hpl.hp.com/2003/07/query/plain")) {
            throw new UnsupportedOperationException("Parsing of syntax '" + string3 + "' not supported");
        }
        throw new UnsupportedOperationException("Unrecognized language: " + string3);
    }

    public static Query read(String string) {
        return QueryFactory.read(string, null, null, null);
    }

    public static Query read(String string, String string2) {
        return QueryFactory.read(string, null, string2, null);
    }

    public static Query read(String string, String string2, String string3) {
        return QueryFactory.read(string, null, string2, string3);
    }

    public static Query read(String string, FileManager fileManager, String string2, String string3) {
        if (fileManager == null) {
            fileManager = FileManager.get();
        }
        String string4 = fileManager.readWholeFileAsUTF8(string);
        if (string2 == null) {
            string2 = string;
        }
        if (string3 == null) {
            string3 = QueryUtils.guessQueryFileSyntax(string);
        }
        return QueryFactory.create(string4, string2, string3);
    }
}

