/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryEngineUtils;
import com.hp.hpl.jena.query.core.QueryIterBasePattern;
import com.hp.hpl.jena.query.core.QueryIterRepeatApply;
import com.hp.hpl.jena.query.core.QueryIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementBasePattern
extends Element
implements QueryIterRepeatApply.GeneratorBinding {
    static Log log = LogFactory.getLog((Class)ElementBasePattern.class);
    List pattern = new ArrayList();
    Node[] projectionVars = null;

    public void addTriple(Triple triple) {
        this.pattern.add(triple);
    }

    public ListIterator triples() {
        return this.pattern.listIterator();
    }

    public QueryIterator exec(Mark mark, QueryIterator queryIterator, DataSet dataSet) {
        Mark mark2 = new Mark(mark);
        if (queryIterator == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)mark.msg("exec: Null input"));
            }
            return new QueryIterBasePattern(mark2, dataSet, null, this, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)mark.msg("exec: Start"));
        }
        QueryIterRepeatApply queryIterRepeatApply = new QueryIterRepeatApply(mark2, dataSet, queryIterator, this);
        if (log.isDebugEnabled()) {
            log.debug((Object)mark.msg("exec: End"));
        }
        return queryIterRepeatApply;
    }

    public QueryIterator makeIterator(Mark mark, Binding binding, DataSet dataSet) {
        if (log.isDebugEnabled()) {
            log.debug((Object)mark.msg("makeIterator: " + binding));
        }
        return new QueryIterBasePattern(mark, dataSet, binding, this, null);
    }

    protected void varsRequired(Set set) {
    }

    protected void varsBound(Set set) {
        ListIterator listIterator = this.triples();
        while (listIterator.hasNext()) {
            Triple triple = (Triple)listIterator.next();
            this.addVar(set, triple.getSubject());
            this.addVar(set, triple.getPredicate());
            this.addVar(set, triple.getObject());
        }
    }

    private void addVar(Set set, Node node) {
        if (node.isVariable()) {
            set.add(node.getName());
        }
    }

    public void subst(Collection collection, Binding binding) {
        ListIterator listIterator = this.triples();
        while (listIterator.hasNext()) {
            Triple triple = (Triple)listIterator.next();
            Triple triple2 = QueryEngineUtils.substituteIntoTriple(triple, binding);
            collection.add(triple2);
        }
    }

    public void visit(ElementVisitor elementVisitor) {
        elementVisitor.visit(this);
    }

    public void phase2(Query query2) {
        log.warn((Object)"Unexpected call to ElementBasePattern.phase2 - this class is not used in a parser");
    }
}

